var util = require('util');
var fs= require('fs');
var path= require('path');
var xlsx = require('../../../../node_modules/node-xlsx/lib/node-xlsx');
//var xlsx = require('xlsx');
var uuid = require('node-uuid');
var Service = require('Service');
var utils = require('utils');
var AppAttachDao = require('../../dao/app_attach');

/**
 * 导出Excel数据
 */
var ExportExcel = function() { 
  Service.call(this);
};

util.inherits(ExportExcel, Service);

module.exports = ExportExcel;

ExportExcel.prototype.formatDateTime =  function(fileName) {
  let start = fileName.indexOf("{");
  if(start<0) return fileName;
  let end = fileName.indexOf("}");
  if(end<0) return fileName;
  let format = fileName.substring(start+1, end);
  let date = new Date();
  fileName = fileName.substring(0, start) + date.format(format) + fileName.substring(end+1);
  return this.formatDateTime(fileName);
};

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
ExportExcel.prototype.process =  function(req, res, cb) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../../system/service/exportExcel'), req, res);
    return;
  }
  if(!req.data && !req.sheets) {
    this.onLogicError(1, '请提供要导出的数据！', req, res, cb);
    return;
  }
  if(!req.appCode) {
    this.onLogicError(2, '请提供应用代码！', req, res, cb);
    return;
  }
  if(req.fileName) {
    req.fileName = this.formatDateTime(req.fileName);
    if(utils.isValidDirOrFileName(req.fileName)) {
      this.onLogicError(3, '文件名称不能包含特殊字符：\\/:*?"<>|！', req, res, cb);
      return;
    }
    if(req.fileName.indexOf(".")<0) {
      req.fileName += ".xlsx";
    } else if(!req.fileName.endWith('.xlsx')) {
      this.onLogicError(4, '文件扩展名仅支持.xlsx！', req, res, cb);
      return;
    }
  }

  var rootpath = utils.formatPath(server.attachSavePath);
  let orgCode = server.config.OrgCode;
  if(req.session) orgCode = req.session.orgCode;
  var filepath = '/'+orgCode+'/';
  if(!fs.existsSync(path.join(rootpath,filepath))) fs.mkdirSync(path.join(rootpath,filepath));
  filepath += 'exportFiles/';
  if(!fs.existsSync(path.join(rootpath,filepath))) fs.mkdirSync(path.join(rootpath,filepath));
  filepath += req.appCode+'/';
  if(!fs.existsSync(path.join(rootpath,filepath))) fs.mkdirSync(path.join(rootpath,filepath));
  var fileCode = uuid.v1().replace(/-/g,'');
  var fileName = fileCode+'.xlsx';
  if(req.fileName) fileName = req.fileName;
  filepath += fileCode+'.xlsx';
  var filePath = utils.formatPath(path.join(rootpath,filepath));
  
  var buffer;
  if(req.fields) {
    let data = [];
    let col = [];
    let cols = [];
    for(var i=0;i<req.fields.length;i++) {
      let field = req.fields[i];
      col.push(field.column);
      if(field.width) {
        cols.push({wpx: parseInt(field.width)});
      } else {
        cols.push({wpx: 120});
      }
    }
    data.push(col);
    for(var i=0;i<req.data.length;i++) {
      let dataRow = req.data[i];
      let excelRow = [];
      for(var j=0;j<req.fields.length;j++) {
        let cellVal = dataRow[req.fields[j].name];
        //MSSQL的node.js库查出来的字段都变成小写了
        if(!cellVal && dataRow[req.fields[j].name.toLowerCase()]) 
          cellVal = dataRow[req.fields[j].name.toLowerCase()];
        excelRow.push(cellVal);
      }
      data.push(excelRow);
    }
    buffer = xlsx.build([{"name": "工作表一", "data": data, '!cols': cols}]);
    
    /*const wb = {
      SheetNames: ['工作表一'],
      Sheets: {}
    };

    let ws = xlsx.utils.aoa_to_sheet(data);
    ws["!cols"] = cols;
    const range = {
      s: {
        c: 0,
        r: 0
      },
      e: {
        c: data[0].length - 1,
        r: data.length - 1
      }
    };
    wb.Sheets['工作表一'] = ws;
    xlsx.utils.sheet_add_aoa(ws, data, {
      origin: 'A1',
      skipHeader: true,
      styles: {
        fill: {
          fgColor: { rgb: "FFFFFF00" }
        },
        font: {
          sz: 14,
          bold: true,
          color: { rgb: "00000000" }
        },
        border: {
          top: { style: 'thin' },
          left: { style: 'thin' },
          bottom: { style: 'thin' },
          right: { style: 'thin' }
        }
      }
    });
    let borderAll = {  //单元格外侧框线
      top: {
        style: 'thin',
      },
      bottom: {
        style: 'thin'
      },
      left: {
        style: 'thin'
      },
      right: {
        style: 'thin'
      }
    };
    for (let key in ws) {
      if (ws[key] instanceof Object) {
        ws[key].s = {
          border: borderAll,
          alignment: {
            horizontal: 'center',   //水平居中对齐
            vertical:'center'
          },
          font:{
            sz:11
          },
          bold:true
        }
      }
    }
    console.log(JSON.stringify(wb));
    xlsx.writeFile(wb, filePath, {cellStyles: true});*/
    
  } else if(req.data) {
    var tableName = '工作表一';
    if(req.tableName) tableName = req.tableName;
    buffer = xlsx.build([{"name": tableName, "data": req.data}], req.options);
  } else {
    buffer = xlsx.build(req.sheets, req.options);
  }

  fs.writeFileSync(filePath, buffer, 'binary');
  
  var stat = fs.statSync(filePath);
  var attach = {};
  attach.code = fileCode;
  attach.name = fileName;
  attach.size = stat.size;
  attach.type = path.extname(fileName);
  attach.app_code = req.appCode;
  attach.app_data_id = 0;
  attach.upload_time = new Date();    
  attach.save_path = filepath;
  if(req.enIde) attach.en_ide = req.enIde;
  if(req.session) {
    attach.org_id = req.session.orgId;
    attach.uploader_id = req.session.userId;
    attach.uploader_name = req.session.userName;
  } else {
    attach.org_id = 1;
    attach.uploader_id = 1;
    attach.uploader_name = "匿名用户";
  }

  var self = this;
  var attachDao = new AppAttachDao(this);
  attachDao.create(attach, function(ret) {
    res.fileCode = attach.code;
    res.fileSize = attach.size;
    res.fileName = attach.name;
    res.fileId = ret.insertId;
    if(cb) {
      cb(req, res);
    } else {
      self.end(res);
    }
  });
};