var util = require('util');
var fs = require('fs');
var path = require('path');
var Service = require('Service');
var utils = require('utils');
var Session = require('Session');
var mime = require('../../../../config/mime');
var Connection = require('Connection');
var AttachDao = require('../../dao/app_attach');
var VUser = require('../../dao/vuser');
var User = require('../../dao/user');
var OrgDao = require('../../dao/org');

/**
 * 下载附件
 */
var DownloadAttachByHttp = function () {
  Service.call(this);
  this.checkLogin = false;
  this.checkAuthority = false;
};

util.inherits(DownloadAttachByHttp, Service);

module.exports = DownloadAttachByHttp;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DownloadAttachByHttp.prototype.process = function (req, res) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../../system/service/downloadAttachByHttp'), req, res);
    return;
  }
  if (req.thumbnail == "true" || req.thumbnail) {
    req.thumbnail = true;
  } else {
    req.thumbnail = false;
  }
  var self = this;
  //必须校验应用编码和文件编码的格式，否则可能会被黑客发送非法的路径进行攻击
  if (req.fileCode) {
    var reg2 = /^([a-zA-Z0-9]{32})$/;
    if (!reg2.test(req.fileCode)) {
      this.onLogicError(1, '文件编码格式无效！', req, res);
      return;
    }
    if (!req.session) {
      req.session = {};
      req.session.requestId = req._requestId;
    }
    this.getAttachFromCache(req, res);
  } else {
    if (!req.session) {
      this.endResponse(2, '请提供有效的会话信息。', req);
      return;
    }
    this.getAttachFromCache(req, res);
  }
};

/**
 * 从缓存中查找附件信息
 * @param  {[type]} req [description]
 * @param  {[type]} res [description]
 * @return {[type]}     [description]
 */
DownloadAttachByHttp.prototype.getAttachFromCache = function (req, res) {
  this.fileKey = '';
  if (req.fileId) {
    if (utils.isInt(req.fileId)) {
      this.onLogicError(1, '文件编号格式无效！', req, res);
      return;
    }
    this.fileKey = 'id_' + req.fileId;
  } else if (req.fileCode) {
    this.fileKey = 'code_' + req.fileCode;
  } else if (req.appCode && req.appDataId) {
    var reg1 = /^[a-zA-Z]([_a-zA-Z0-9]{2,30})$/;
    if (!reg1.test(req.appCode)) {
      this.onLogicError(1, '应用编码格式无效！', req, res);
      return;
    }
    var reg3 = /^([_a-zA-Z0-9]{1,32})$/;
    if (!reg3.test(req.appDataId)) {
      this.onLogicError(1, '应用数据编号格式无效！', req, res);
      return;
    }
    this.fileKey = 'app_' + req.appCode + '_' + req.appDataId;
  } else {
    this.endResponse(1, '请提供下载附件所需要的参数！', req);
    return;
  }
  var file = server.attachs[this.fileKey];
  if (!file) {
    this.getAttachFromDb(req, res);
    return;
  }
  file.lastDown = new Date();
  if (file.status == 1) {
    if (req.appCode == 'sys.userHead' && req.appDataId) {
      this.sendDefaultUserHead(req, res);
      return;
    }
    this.endResponse(2, '未找到满足条件的附件！', req);
    return;
  }
  this.downloadPrev(req, res, file);
};

/**
 * 
 * @param {*} req 
 * @param {*} res 
 */
DownloadAttachByHttp.prototype.getAttachFromDb = function (req, res) {
  var self = this;
  var strWhere = '';
  //SQL注入检测 TODO 作为通用方法
  var sqlStrs = ['--', '\'', '"', ' ', '/**/', '%a0'];
  for (var i = 0; i < sqlStrs.length; i++) {
    if ((req.fileId && (req.fileId + "").indexOf(sqlStrs[i]) > 0) ||
      (req.fileCode && req.fileCode.indexOf(sqlStrs[i]) > 0) ||
      (req.appCode && req.appCode.indexOf(sqlStrs[i]) > 0) ||
      (req.appDataId && (req.appDataId + "").indexOf(sqlStrs[i]) > 0)) {
      self.endResponse(9999, '被限制的查询参数！', req);
      return;
    }
  }
  var params = [];
  if (req.fileId) {
    strWhere = 'id=? and org_id=?';
    params = [req.fileId, req.session.orgId];
  } else if (req.fileCode) {
    strWhere = 'code=?';
    params = [req.fileCode];
  } else if (req.appCode && req.appDataId) {
    strWhere = 'app_code=? and app_data_id=? and org_id=?';
    params = [req.appCode, req.appDataId, req.session.orgId];
  } else {
    this.endResponse(1, '请提供下载附件所需要的参数！', req);
    return;
  }
  var attachDao = new AttachDao(this);
  attachDao.query({
    fields: 'id,code,name,save_path,size,type,en_ide',
    where: strWhere,
    params: params
  }, function (rows) {
    // if (self.connection) {
    //   try {
    //     self.connection.end();
    //   } catch (err) {
    //     logger.log('关闭数据库连接时发生意外错误：' + err.message, req._requestId);
    //   }
    //   logger.log('数据库连接已关闭。', req._requestId);
    // }

    if (self.connection) {
      try {
        var connectionClass = new Connection();
        connectionClass.setOption({ "requestId": req._requestId });
        connectionClass.setConnection(self.connection);
        connectionClass.close();
      } catch (err) {
        logger.log('关闭数据库连接时发生意外错误：' + err.message, req._requestId);
      }
      logger.log('数据库连接已关闭。', req._requestId);
    }

    if (rows.length == 0) {
      //有可能还没写完数据库，就有人去查这个文件了，这里改成直接移除
      delete server.attachs[self.fileKey];
      //server.attachs[self.fileKey] = {status: 1, lastDown: new Date()};

      if (req.appCode == 'sys.userHead' && req.appDataId) {
        self.sendDefaultUserHead(req, res);
        return;
      }
      self.endResponse(2, '未找到满足条件的附件！', req);
      return;
    }
    var file = rows[0];
    file.lastDown = new Date();
    file.status = 0;
    server.attachs[self.fileKey] = file;
    self.downloadPrev(req, res, file);
  });
};

/**
 * 下载前校验
 * 校验是否需要身份验证，通过sys_app_attach表中的en_ide是否为1判断
 * @param {*} req 
 * @param {*} res 
 * @param {*} file 
 */
DownloadAttachByHttp.prototype.downloadPrev = function (req, res, file) {
  var self = this;
  if (file.en_ide !== 1) return self.download(req, res, file);

  // 解密req._auth_session，获取sessionId和ts
  if (!req._auth_session) return self.endResponse(1, '身份验证失败：请提供有效的会话信息！', req);
  var authSession = null;
  try {
    var ivData = [req.fileCode];
    var iv = utils.md5(JSON.stringify(ivData)).substr(0, 16);
    ivData.push(iv);
    var key = utils.md5(JSON.stringify(ivData));
    var data = utils.decryptAES(req._auth_session, key, iv);
    authSession = JSON.parse(data);
  } catch (error) {
    console.log(error);
    return self.endResponse(1, '身份验证失败：请提供有效的会话信息！', req);
  }

  // 校验时间戳
  var tsTimeout = 10 * 60 * 1000;
  if (server.config.TimestampTimeout) tsTimeout = parseInt(server.config.TimestampTimeout) * 1000;
  var curTime = (new Date()).getTime();
  var ts = parseInt(authSession.ts);
  if (Math.abs(curTime - ts) > tsTimeout) {
    return self.endResponse(1, '时间戳已超时', req);
  }

  // 校验sessionId是否正确
  server.sessionManager.checkSession(authSession, res, function (code, ret) {
    if (code != 0) return self.endResponse(1, ret, req);
    self.download(req, res, file);
  });
}

/**
 * 下载
 * @param {*} req 
 * @param {*} res 
 * @param {*} file 
 */
DownloadAttachByHttp.prototype.download = function (req, res, file) {
  req.realFileName = file.name;
  var fileCode = file.code;
  var filePath = file.save_path;
  var fileSize = file.size;
  var fileType = file.type;

  var fileName = filePath;
  if (fileName.startWith('/')) {
    var sPath = server.config.Attach.savePath;
    if (fileName.indexOf(sPath) == 0) fileName = fileName.substring(sPath.length);
    fileName = path.join(server.attachSavePath, fileName);
  }

  logger.logDownloadToDB(req, file.id, fileCode, file.name, fileSize, filePath);

  if (!fs.existsSync(fileName)) {
    if (req.appCode == 'sys.userHead' && req.appDataId) {
      this.sendDefaultUserHead(req, res);
      return;
    }
    this.endResponse(3, '附件在服务器上不存在！', req);
    return;
  }
  logger.log('准备发送附件[' + fileCode + ']。', req._requestId);

  //如果要下载缩略图
  if (server.config.Attach.compressImage && req.thumbnail) {
    var tnFile = fileName + '.thumbnail';
    if (!fs.existsSync(tnFile)) {
      this.createThumbnail(req, res, fileName, fileType);
    } else {
      this.sendFile(req, res, tnFile, fileType);
    }
  } else {
    this.sendFile(req, res, fileName, fileType);
  }
};

/**
 * 头像
 * @param {*} req 
 * @param {*} res 
 */
DownloadAttachByHttp.prototype.sendDefaultUserHead = function (req, res) {
  if (req.session.userSex == 0) {
    this.sendFile(req, res, utils.getPath('/web/images/icon/48/men.png'), '.png');
  } else {
    this.sendFile(req, res, utils.getPath('/web/images/icon/48/women.png'), '.png');
  }
};

/**
 * 压缩
 * @param {*} req 
 * @param {*} res 
 * @param {*} fileName 
 * @param {*} fileType 
 */
DownloadAttachByHttp.prototype.createThumbnail = function (req, res, fileName, fileType) {
  var tnFile = fileName + '.thumbnail';
  var self = this;
  var gm = require('gm');
  gm(fileName).size(function (err, size) {
    if (err) {
      logger.log('获得图片尺寸时发生意外错误：' + err.message, req._requestId);
      self.sendFile(req, res, fileName, fileType);
    } else {
      var imageTemp = gm(fileName);
      var imageSize = size.width;
      if (size.width > size.height) {
        imageSize = size.height;
        imageTemp = imageTemp.crop(imageSize, imageSize, 0, 0);
      } else if (size.width < size.height) {
        imageTemp = imageTemp.crop(imageSize, imageSize, 0, 0);
      }
      if (imageSize > 360) imageTemp = imageTemp.resize(360, 360);
      imageTemp.write(tnFile, function (err2) {
        if (err2) {
          logger.log('生成图片的缩略图时发生意外错误：' + err2.message, req._requestId);
          self.sendFile(req, res, fileName, fileType);
          return;
        }
        self.sendFile(req, res, tnFile, fileType);
      });
    }
  });
};

/**
 * 发送文件
 * @param {*} req 
 * @param {*} res 
 * @param {*} fileName 
 * @param {*} fileType 
 */
DownloadAttachByHttp.prototype.sendFile = function (req, res, fileName, fileType) {
  var self = this;
  fs.stat(fileName, function (err, stats) {
    var ext = fileType;
    ext = ext ? ext.slice(1) : 'unknown';
    if (ext == 'timg') ext = 'jpg';
    var contentType = mime[ext] || 'application/octet-stream';
    if (!(req.showImage && (ext == 'jpg' || ext == 'jpeg' || ext == 'png' || ext == 'bmp' || ext == 'gif'))) {
      req.socket.httpResponse.setHeader('Content-Disposition', 'attachment; filename='
        + encodeURIComponent(req.realFileName));
    }
    req.socket.httpResponse.setHeader('Content-Type', contentType);
    req.socket.httpResponse.setHeader('Content-Length', stats.size);
    req.socket.httpResponse.setHeader('Accept-Ranges', 'none');
    req.socket.httpResponse.writeHead(200, 'ok');

    var readStream = fs.createReadStream(fileName);
    self.fileStream = readStream;
    self.lastActive = new Date();
    self.isEnd = false;

    setTimeout(function () { self.checkTimeout(req, res); }, 1000);

    // readStream.pipe(req.socket.httpResponse);

    readStream.on('data', function (chunk) {
      self.lastActive = new Date();
      req.socket.httpResponse.write(chunk);
    });

    readStream.on('end', function (err2) {
      self.isEnd = true;
      req.socket.httpResponse.end();
      if (err2) {
        logger.log('发送文件时发生意外错误，错误描述：' + err2.message, req._requestId);
        logger.logRequestToDBEnd(req.socket.httpRequest, req.socket.httpResponse, 500, err2.message);
        return;
      }
      logger.log('文件[' + fileName + ']发送完毕。', req._requestId);
      logger.logRequestToDBEnd(req.socket.httpRequest, req.socket.httpResponse, 200, '文件[' + fileName + ']发送完毕。');
    });

    req.socket.httpResponse.setTimeout(30 * 1000, function () {
      logger.log('响应超时。', req._requestId);
      req.socket.httpResponse.end();
      logger.logRequestToDBEnd(req.socket.httpRequest, req.socket.httpResponse, 500, ' 响应超时。');
    });
  });
};

/**
 * 验证超时
 * @param {*} req 
 * @param {*} res 
 */
DownloadAttachByHttp.prototype.checkTimeout = function (req, res) {
  var self = this;
  if (!self.isEnd) {
    var timelong = ((new Date()).getTime() - self.lastActive.getTime()) / 1000;
    if (timelong > 10) {
      logger.log(req._requestId + ' 下载文件10秒无响应，超时。');
      req.socket.httpResponse.end();
      logger.logRequestToDBEnd(req.socket.httpRequest, req.socket.httpResponse, 500, ' 下载文件10秒无响应，超时。');
      if (self.fileStream) {
        self.fileStream.close();
      }
    } else {
      setTimeout(function () { self.checkTimeout(req, res); }, 1000);
    }
  }
};

/**
 * 响应
 * @param {*} code 
 * @param {*} content 
 * @param {*} req 
 */
DownloadAttachByHttp.prototype.endResponse = function (code, content, req) {
  var str = '';
  if (content && typeof (content) != "string") {
    if (content.formatFunc) {
      str = JSON.stringify(content, content.formatFunc);
    } else {
      str = JSON.stringify(content);
    }
  } else {
    str = content;
  }
  logger.logRequestToDBEnd(req.socket.httpRequest, req.socket.httpResponse, 500, str);
  logger.log('发送响应数据：' + str, req._requestId);
  req.socket.httpResponse.writeHead(500, { 'Content-Type': 'text/plain' });
  req.socket.httpResponse.write(str);
  req.socket.httpResponse.end();
};