var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/org_app');
var util = require('util');

/**
 * 禁用应用
 */
var Disable = function() { 
  Service.call(this);
  this.dao = new Dao(this);
};

util.inherits(Disable, Service);

module.exports = Disable;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Disable.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  var ids = utils.strToIntArray(req.id);
  if(ids.length==0) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  ids = ids.join();
  var self = this;
  this.dao.update({status: 1},{
    where: 'org_id='+req.session.orgId+' and app_id in ('+ids+')'}, 
    function(ret) {
    req.session.cache.del('app', '['+ids+'].contains(#{app_id})', function(err) {
      if(err) {
        self.onError(err);
        return;
      }
      self.end(res);
    });
  });
};