var Service = require('Service');
var utils = require('utils');
var DaoUser = require('../../dao/user');
var DaoAppAuth = require('../../dao/app_auth');
var util = require('util');

/**
 *  删除应用操作权限
 */
var DelOprationAuth = function() { 
  Service.call(this);
};

util.inherits(DelOprationAuth, Service);

module.exports = DelOprationAuth;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DelOprationAuth.prototype.process =  function(req, res) {

  if(!req.id) {
    this.onLogicError(1, '请提供权限编号！');
    return;
  }
  var ownerIds = utils.strToIntArray(req.id);
  if(ownerIds.length==0) {
    this.onLogicError(3, '请选择权限拥有者！');
    return;
  }
  ownerIds = ownerIds.join(",");

  var self = this;
  daoAppAuth = new DaoAppAuth(self);
  daoAppAuth.delete('org_id='+req.session.orgId+' and id in ('+ownerIds+')', function() {
    req.session.cache.del('app_auth', '['+ownerIds+'].contains(#{id})', function(err) {
      if(err) {
        self.onError(err);
        return;
      }
      self.end(res);
    });
  });
};