var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * DelOpration
 * 删除sys_app_opration
 */
var DelOpration = function() { 
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(DelOpration, Service);

module.exports = DelOpration;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
DelOpration.prototype.process =  function(req , res) {
  //请求参数校验
  if(utils.isNull(req.id)) {
    this.onLogicError(1, '请提供参数操作编号！');
    return;
  }

  var self = this;
  let params = [];
  self._dao.execute("delete from sys_app_opration where  id in ("+req.id+");", params, function() {
    let ids = utils.strToIntArray(req.id);
    server.cache.del(null, 'app_opration', ids, function(err) {
      self.end(res);
    });
  });
};
