var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/org_app_category');
var util = require('util');

/**
 * 删除应用分类
 */
var DeleteAppCategory = function() { 
  Service.call(this);
};

util.inherits(DeleteAppCategory, Service);

module.exports = DeleteAppCategory;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DeleteAppCategory.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供类别编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的类别编号！');
    return;
  }
  var self = this;
  req.session.cache.get('app_category', parseInt(req.id), function(err, category){
    if(err) {
      self.onError(err);
      return;
    }
    if(category.subCategorys.length>0) {
      self.onLogicError(3, '该类别下面还有子类别，目前不能删除！');
      return;
    }
    if(category.apps && category.apps.length>0) {
      self.onLogicError(4, '该类别中有已启用的应用，目前不能删除！');
      return;
    }
    var dao = new Dao(self);
    dao.delete('org_id='+req.session.orgId+' and id in ('+req.id+')', function(ret) {
      req.session.cache.del('app_category', parseInt(req.id), function(err2){
        if(err2) {
          self.onError(err2);
          return;
        }
        self.end(res);
      });
    });
  });
};