var Service = require('Service');
var utils = require('utils');
var DaoUser = require('../../dao/user');
var DaoAppAuth = require('../../dao/app_auth');
var util = require('util');

/**
 *  删除应用权限
 */
var DeleteAuth = function() { 
  Service.call(this);
};

util.inherits(DeleteAuth, Service);

module.exports = DeleteAuth;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DeleteAuth.prototype.process =  function(req, res) {

  if(!req.id) {
    this.onLogicError(1, '请提供权限编号！');
    return;
  }
  var ownerIds = utils.strToIntArray(req.id);
  if(ownerIds.length==0) {
    this.onLogicError(3, '请选择权限拥有者！');
    return;
  }
  ownerIds = ownerIds.join();

  if(!req.appId) {
    this.onLogicError(2, '请提供应用编号！');
    return;
  }
  if(!utils.isInt(req.appId)) {
    this.onLogicError(3, '请提供正确的应用编号！');
    return;
  }
  
  var self = this;
  daoAppAuth = new DaoAppAuth(self);
  daoAppAuth.delete('org_id='+req.session.orgId+' and app_id='
    +req.appId+' and id in ('+ownerIds+')', function() {
    req.session.cache.del('app_auth', '#{app_id}=='+req.appId
      +' && ['+ownerIds+'].contains(#{id})', function(err) {
      if(err) {
        self.onError(err);
        return;
      }
      self.end(res);
    });
  });
};