var Service = require('Service');
var utils = require('utils');
var DaoApp = require('../../dao/app');
var DaoOrgApp = require('../../dao/org_app');
var util = require('util');

/**
 * 删除应用
 */
var Delete = function() { 
  Service.call(this);
  this.daoApp = new DaoApp(this);
  this.daoOrgApp = new DaoOrgApp(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Delete.prototype.process =  function(req, res) {
  if(!req.app_id) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  var appIds = utils.strToIntArray(req.app_id);
  if(appIds.length==0) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  appIds = appIds.join();
  var self = this;
  this.daoApp.delete('developer_id='+req.session.orgId
    +' and id in ('+appIds+')', function(ret) {
    self.daoOrgApp.delete('org_id='+req.session.orgId
      +' and app_id in ('+appIds+')', function(ret) {
      req.session.cache.del('app', '['+appIds+'].contains(#{app_id})', function(err) {
        if(err) {
          self.onError(err);
          return;
        }
        self.end(res);
      });
    });
  });
};