var Service = require('Service');
var util = require('util');
var fs = require('fs');
var path = require('path');

/**
 * 删除附件缓存
 */
var ClearAttachCache = function() { 
  Service.call(this);
};

util.inherits(ClearAttachCache, Service);

module.exports = ClearAttachCache;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
ClearAttachCache.prototype.process =  function(task) {
  var saveDays = 7;
  if(server.config.Attach && server.config.Attach.cacheSaveDays)
    saveDays = parseInt(server.config.Attach.cacheSaveDays);
  logger.log('正在清理过期的附件缓存...');
  var validKeys = [];
  for(var key in server.attachs) {
    var file = server.attachs[key];
    if(((new Date())-(new Date(file.lastDown)))>(saveDays*24*60*60*1000)) {
      validKeys.push(key);
    }
  }
  for(var i=0;i<validKeys.length;i++) {
    delete server.attachs[validKeys[i]];
  }
  logger.log('清理完毕，本次共清理 '+validKeys.length+' 条附件缓存。');
  validKeys = null;

  var self = this;

  //清理临时文件
  var uploadDir = path.join(server.attachSavePath, "/tmp/");
  if (fs.existsSync(uploadDir)) {
    fs.readdir(uploadDir, function(err, list) {
      if(err) {
        logger.log('读取目录信息出错：'+err.message);
        self.end();
        return;
      }
      var pending = list.length;
      if (list.length==0) {
        self.end();
        return;
      }
      list.forEach(function(fileName) {
        var filePath = path.resolve(uploadDir, fileName);
        fs.stat(filePath, function(err, stat) {
          if (stat) {
            if(!stat.isDirectory()) {
              if ((new Date() - new Date(stat.mtime)) > saveDays * 24 * 60 * 60 * 1000) {
                try {
                  fs.unlinkSync(filePath);
                } catch(err3) {
                  logger.log('删除文件'+fileName+'出错：'+err3.message);
                }
              }
            }
          }
          if (!--pending) {
            self.end();
            return;
          }
        });
      });
    });
  }

  this.end();
};

/**
 * 删除过期的文件，例如导出文件
 * @param {*} dir 
 * @returns 
 */
ClearAttachCache.prototype.delOverdueFiles = async function (dir) {
  //获得目录内的子目录和文件列表
  let fileList = fs.readdirSync(dir);
  let haveNotDelFile = false;  //是否有没删除的文件
  //轮询
  for(let i=0;i<fileList.length;i++) {
      let fileName = fileList[i];
      let filePath = dir+"/"+fileName;
      //获得路径信息
      let stat = fs.statSync(filePath);
      //如果是目录，则递归调用delOverdueFiles方法，删除该目录里的子目录和文件
      if(stat.isDirectory()) {
          haveNotDelFile = this.delOverdueFiles(filePath);
      } else {  //否则，如果是文件
          //判断文件是否超过保存期限，如果超过，则删除
          if ((new Date() - new Date(stat.mtime)) > this.saveDays * 24 * 60 * 60 * 1000) {
              try {
                  fs.unlinkSync(filePath);
              } catch (err) {
                  logger.log('删除文件' + filePath + '出错：' + err.message);
              }
          } else {
              haveNotDelFile = true;
          }
      }
  }
  //如果有子目录或文件没有删除，则返回true
  if(haveNotDelFile) return true;
  //如果该目录里的文件都删除了，则删除该目录
  try {
      fs.rmdirSync(dir);
  } catch (err) {
      logger.log('删除文件夹' + dir + '出错：' + err.message);
  }
  return false;
};