var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');


/**
 * 添加应用操作权限
 */
var AddOprationAuth = function() { 
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(AddOprationAuth, Service);

module.exports = AddOprationAuth;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
AddOprationAuth.prototype.process =  function(req, res) {
	
	if(!req.owner_type) {
	  this.onLogicError(1, '请提供权限拥有者类型！');
	  return;
	}
	if(!req.owner_id) {
	  this.onLogicError(2, '请选择权限拥有者编号！');
	  return;
	}
	if(!req.operation_id) {
	  this.onLogicError(3, '请提供操作编号！');
	  return;
	}

  this.appIds = [];
  this.opIds = [];
  let arr = req.operation_id.split(",");
  for(let i=0;i<arr.length;i++) {
  	let id = arr[i];
  	if(id.startsWith("app_")) {
  		this.appIds.push(parseInt(id.replace("app_", "").trim()));
  	} else {
  		this.opIds.push(parseInt(id.replace("opration_", "")));
  	}
  }
  
  this.addAppAuth(req, res);
};

AddOprationAuth.prototype.addAppAuth =  function(req, res) {
  if(this.appIds.length==0) {
  	this.addOpAuth(req, res);
  	return;
  }
  var self = this;
  this._dao.execute("delete from sys_app_auth where org_id="+req.session.orgId
  	+" and app_id in ("+this.appIds.join(",")+") and owner_id="+req.owner_id
  	+" and owner_type='"+req.owner_type+"'", null, function() {
		self._dao.execute("insert into sys_app_auth(org_id,owner_type,owner_id,terminal,app_id) "
	  	+"select "+req.session.orgId+",'"+req.owner_type+"',"+req.owner_id+",terminal,id "
	  	+"from sys_app where id in ("+self.appIds.join(",")+")", null, function() {
	  	self._dao.execute("select * from vsys_app_auth where app_id in ("+self.appIds.join(",")
	  		+") and owner_id="+req.owner_id+" and owner_type='"+req.owner_type+"'", null, function(auths) {
		  	req.session.cache.del('app_auth', "#{owner_id}=="+req.owner_id+" && #{owner_type}=='"
	          +req.owner_type+"' && ["+self.appIds.join(",")+"].contains(#{app_id})", function(err1) {
	        if(err1) {
	          self.onError(err1);
	          return;
	        }
	        var params = [];
          for(var i=0;i<auths.length;i++) {
            var auth = auths[i];
            params.push({
              modelName: 'app_auth',
              key: auth.id,
              value: auth
            });
          }
          req.session.cache.mset(params, function(err2) {
            if(err2) {
              self.onError(err2);
              return;
            }
            self.addOpAuth(req, res);
          });
	      });
  		});
		});
	});
};

AddOprationAuth.prototype.addOpAuth =  function(req, res) {
	if(this.opIds.length==0) {
  	this.end(res);
  	return;
  }
  var self = this;
  this._dao.execute("delete from sys_app_auth where org_id="+req.session.orgId
  	+" and opration_id in ("+this.opIds.join(",")+") and owner_id="+req.owner_id
  	+" and owner_type='"+req.owner_type+"'", null, function() {
		self._dao.execute("insert into sys_app_auth(org_id,owner_type,owner_id,terminal,app_id,opration_id) "
	  	+"select "+req.session.orgId+",'"+req.owner_type+"',"+req.owner_id+",terminal,app_id,id "
	  	+"from sys_app_opration where id in ("+self.opIds.join(",")+")", null, function() {
	  	self._dao.execute("select id,owner_type,owner_id,app_id,opration_id,service_path "
	  		+"from vsys_app_auth where opration_id in ("+self.opIds.join(",")
	  		+") and owner_id="+req.owner_id+" and owner_type='"+req.owner_type+"'", null, function(auths) {
		  	req.session.cache.del('app_auth', "#{owner_id}=="+req.owner_id+" && #{owner_type}=='"
	          +req.owner_type+"' && ["+self.opIds.join(",")+"].contains(#{opration_id})", function(err1) {
	        if(err1) {
	          self.onError(err1);
	          return;
	        }
	        var params = [];
          for(var i=0;i<auths.length;i++) {
            var auth = auths[i];
            params.push({
              modelName: 'app_auth',
              key: auth.id,
              value: auth
            });
          }
          req.session.cache.mset(params, function(err2) {
            if(err2) {
              self.onError(err2);
              return;
            }
            req.session.cache.getList("app_auth", "["+self.opIds.join(",")+"].contains(#{opration_id})" , function(err, ret) {
            	self.end(res);
            });
          });
	      });
  		});	  	
		});
	});
};