var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * AddOpration
 * 添加sys_app_opration
 */
var AddOpration = function() { 
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(AddOpration, Service);

module.exports = AddOpration;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
AddOpration.prototype.process =  function(req , res) {
  //请求参数校验
  if(utils.isNull(req.app_id)) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  if(utils.isNull(req.name)) {
    this.onLogicError(1, '请提供操作名称！');
    return;
  }
  if(utils.isNull(req.service_path)) {
    this.onLogicError(2, '请提供服务路径！');
    return;
  }
  if(utils.isNull(req.terminal)) {
    this.onLogicError(3, '请提供支持终端！');
    return;
  }

  var self = this;
  let params = [];
  params.push(req.app_id,req.name,req.service_path);
  self._dao.execute(
    "select name,service_path,terminal from sys_app_opration where  "
      +"app_id=? and (name=? or service_path=?)", params,
    function(data) {
    if(data.length>0) {
      self.onLogicError(1, "操作名称或路径已存在！");
      return;
    }
    let opr = {};
    opr['app_id'] = parseInt(req.app_id);
    opr['name'] = req.name+'';
    opr['service_path'] = req.service_path+'';
    opr['terminal'] = req.terminal+'';
    self._dao.model = server.loadModule('/app/sys/model/sys_app_opration.tdm');
    self._dao.create(opr, function(ret) {
      opr.id = ret.insertId;
      console.log(opr);
      server.cache.set(null, 'app_opration', opr.id, opr, false, function(err) {
        self.end(res);
      });
    });
  });
};
