var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');


var AddAppAuth = function() { 
  Service.call(this);
  this._dao = new Dao(this);
  this.sqlInject = {
    check: false
  };
};

util.inherits(AddAppAuth, Service);

module.exports = AddAppAuth;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */


AddAppAuth.prototype.process =  function(req, res) {
	
	var self = this;
	self.app_ids = [];
	self.opration_ids = [];
	
	if(!req.tree_id) {
	  this.onLogicError(1, '请选择权限！');
	  return;
	}
	// var tree_id = utils.strToIntArray(req.tree_id);
	// tree_id = tree_id.join();
	var tree_id = JSON.parse(req.tree_id);
	for(var i = 0;i < tree_id.length;i++){
		var ids = tree_id[i];
		var index = ids.lastIndexOf("_");
		var before = ids.substring(0,index);
		var after = parseInt(ids.substring(index + 1,ids.length));
		
		if(before == "tbapp"){
			self.app_ids.push(after);
		}
		if(before == "tbopration"){
			self.opration_ids.push(ids);
		}
		if(i == tree_id.length - 1){
			
			self.num = 0;
			self.insert_app(req,res);
		}
	}
	
	
	
}


AddAppAuth.prototype.insert_app =  function(req, res) {
	var self = this;
	var params = [ req.session.orgId,req.session.userId]
	var field = "";
	var field_val = "";
	if(self.num >= self.app_ids.length){
		self.onum = 0;
		self.insert_opration(req,res);
	}else{
		self._dao.execute(
		  " delete from sys_app_auth where org_id = ? and owner_type = 'user' and owner_id = ? and terminal = 'web' and app_id = "+self.app_ids[self.num] , params,
		  function(ret) {
			self._dao.execute(
			  " insert into sys_app_auth(org_id,owner_type,owner_id,terminal,app_id) values("+req.session.orgId+",'user',"+req.session.userId+",'web',"+self.app_ids[self.num]+") " , null,
			  function(rows) {
			  self.num++;
			  self.insert_app(req,res);
			});
		});
		
	}
	
}

AddAppAuth.prototype.insert_opration =  function(req, res) {
	var self = this;
	var params = [ req.session.orgId,req.session.userId]
	var field = "";
	var field_val = "";
	if(self.onum >= self.opration_ids.length){
		self.end(res);
	}else{
		
		var index2 = self.opration_ids[self.onum].lastIndexOf("_");
		var index3 = self.opration_ids[self.onum].lastIndexOf("&");
		var after2 = parseInt(self.opration_ids[self.onum].substring(index2 + 1,index3 + 1));
		var after3 = parseInt(self.opration_ids[self.onum].substring(index3 + 1,self.opration_ids[self.onum].length));
		
		self._dao.execute(
		  " delete from sys_app_auth where org_id = ? and app_id = "+after2+" and owner_type = 'user' and owner_id = ? and terminal = 'web' and opration_id = "+after3 , params,
		  function(ret) {
			self._dao.execute(
			  " insert into sys_app_auth(org_id,app_id,owner_type,owner_id,terminal,opration_id) values("+req.session.orgId+","+after2+",'user',"+req.session.userId+",'web',"+after3+") " , null,
			  function(rows) {
			  self.onum++;
			  self.insert_opration(req,res);
			});
		});
		
	}
	
}