var Service = require('Service');
var utils = require('utils');
var DaoApp = require('../../dao/app');
var DaoOrgApp = require('../../dao/org_app');
var DaoVOrgApp = require('../../dao/vorg_app');
var DaoAuth = require('../../dao/app_auth');
var util = require('util');
var fs= require('fs');
var uuid = server.loadModule('/node_modules/node-uuid/uuid.js');

/**
 * 添加应用
 */
var Add = function() { 
  Service.call(this);
  this.sqlInject.check = false;
};

util.inherits(Add, Service);

module.exports = Add;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Add.prototype.process =  function(req, res) {
  if(!req.code) {
    req.code = uuid.v1().replace(/-/g, '');
    //this.onLogicError(1, '请提供应用代码！');
    //return;
  }

  if(!req.name) {
    this.onLogicError(2, '请提供应用名称！');
    return;
  }

  if(!req.terminal) {
    this.onLogicError(3, '请提供应用支持的终端类型！');
    return;
  }

  // if(!req.app_icon) {
  //   this.onLogicError(4, '请上传应用图标！');
  //   return;
  // }

  if(!req.categoryId) {
    this.onLogicError(5, '请选择所属类别！');
    return;
  }
  req.category_id = parseInt(req.categoryId);

  if(!req.deploy) {
    req.deploy = 'url';
  }

  if(!req.version) {
    req.version = '1.0.000';
  }

  this.createApp(req, res);
};

Add.prototype.createApp =  function(req, res) {
  var url_phone = '';
  var url_pad = '';
  var url_web = '';
  var url_pc = '';
  var url_phone_detail = '';
  var url_pad_detail = '';
  var url_web_detail = '';
  var url_pc_detail = '';
  var pc_open_type = 0;
  var pc_show_on_sysbar = 0;
  if(req.deploy=='url') {
    if(req.terminal.indexOf('web')>=0) {
      if(!req.url_web) {
        this.onLogicError(7, '请提供Web版首页URL路径！');
        return;
      } else {
        url_web = req.url_web;
      }
      if(req.url_web_detail){
        url_web_detail = req.url_web_detail;
      }
    }
    if(req.terminal.indexOf('phone')>=0) {
      if(!req.url_phone) {
        this.onLogicError(7, '请提供手机客户端首页URL路径！');
        return;
      } else {
        url_phone = req.url_phone;
      }
      if(req.url_phone_detail){
        url_phone_detail = req.url_phone_detail;
      }
    }
    if(req.terminal.indexOf('pad')>=0) {
      if(!req.url_pad) {
        this.onLogicError(7, '请提供平板客户端首页URL路径！');
        return;
      } else {
        url_pad = req.url_pad;
      }
      if(req.url_pad_detail) {
        url_pad_detail = req.url_pad_detail;
      }
    }
    if(req.terminal.indexOf('pc')>=0) {
      if(!req.url_pc) {
        this.onLogicError(7, '请提供电脑客户端首页URL路径！');
        return;
      } else {
        url_pc = req.url_pc;
      }
      if(req.url_pc_detail){
        url_pc_detail = req.url_pc_detail;
      }
      if(req.pc_open_type) pc_open_type = req.pc_open_type;
      if(req.pc_show_on_sysbar) pc_show_on_sysbar = req.pc_show_on_sysbar;
    }
  }

  if (typeof (req.icon_path) != "string") req.icon_path = JSON.stringify(req.icon_path);

  var description = '';
  if(req.description) description = req.description;
  
  var self = this;
  var daoApp = new DaoApp(this);
  var daoVOrgApp = new DaoVOrgApp(this);
  daoVOrgApp.query({where: 'org_id=? and category_id='+req.categoryId+' and (app_code=? or app_name=?)', 
    params: [req.session.orgId, req.code, req.name]}, function(rows) {
    if(rows.length>0) {
      self.onLogicError(8, '该应用已经存在！');
      return;
    }
    let msg_group = 0;
    if(req.msg_group) msg_group = 1;
    var appInfo = {
      code: req.code , 
      name: req.name , 
      deploy: req.deploy , 
      terminal: req.terminal , 
      version: req.version , 
      developer_id: req.session.orgId, 
//       developer: req.session.org.name,
      status: 1,
      mark: 0,
      install_count: 0,
      market_status:1,
      titlebar_color:req.titlebar_color,
      url_phone: url_phone,
      url_pad: url_pad,
      url_pc: url_pc,
      url_web: url_web,
      url_phone_detail: url_phone_detail,
      url_pad_detail: url_pad_detail,
      url_pc_detail: url_pc_detail,
      url_web_detail: url_web_detail,
      // icon_code: req.app_icon.code,
      icon_path: req.icon_path,
      get_badge_service:req.get_badge_service,
      //icon_path: '/app/'+req.session.org.code+'/'+req.code+'/appLogo.png',
      pc_open_type: pc_open_type,
      pc_show_on_sysbar: pc_show_on_sysbar,
      description: description,
      createtime: new Date(),
      default:0,
      free:0,
      msg_group: msg_group,
      lastupdate: new Date()};
    daoApp.create(appInfo, function(ret) {
        appInfo.id = ret.insertId;
        res.appId = ret.insertId;
        var daoOrgApp = new DaoOrgApp(self);
      //添加企业应用信息
        daoOrgApp.create({
          org_id: req.session.orgId, 
          app_id: ret.insertId, 
          status: 0,
          category_id: req.category_id,
          order_no: ret.insertId,
          installer_id: req.session.userId,
          install_time: new Date()}, 
        function() {
          appInfo.status = 0;
          appInfo.category_id = req.category_id;
          appInfo.order_no = appInfo.id;
          appInfo.app_id = appInfo.id;
          appInfo.app_code = appInfo.code;
          appInfo.app_name = appInfo.name;
          appInfo.auths = [];
          req.session.cache.set('app', appInfo.id, appInfo, false, function(err) {
            if(err) {
              self.onError(err);
              return;
            }

            res.app = appInfo;

            //为系统管理员角色添加应用权限
            //先查系统管理员角色编号
            req.session.cache.getList('role', '#{name}=="系统管理员"', function(errRole, ret) {
              if(errRole) {
                logger.log(errRole);
                self.end(res);
                return;
              }
              if(ret.length==0) {
                self.end(res);
                return;
              }
              var sysAdminId = ret[0].id;
              var terminals = req.terminal.split(',');
              var daoAuth = new DaoAuth(self);
              self.createAuth(req, res, daoAuth, appInfo, ret[0].id, terminals, 0);
            });
          });
        });
    });
  });
};

Add.prototype.createAuth =  function(req, res, daoAuth, appInfo, sysAdminId, terminals, index) {
  if(index>=terminals.length) {
    this.end(res);
    return;
  }
  var auth = {
    org_id: req.session.orgId,
    app_id: appInfo.id,
    owner_type: 'role',
    owner_id: sysAdminId,
    terminal: terminals[index]
  };
  var self = this;
  daoAuth.create(auth, function(ret) {
    auth.id = ret.insertId;
    req.session.cache.set('app_auth', auth.id, auth, false, function(errAuth) {
      if(errAuth) {
        self.onError(errAuth);
        return;
      }
      self.createAuth(req, res, daoAuth, appInfo, sysAdminId, terminals, index+1);
    });
  });
};