var util = require('util');
var Dao = require('Dao');

/**
 * 用户数据模型类
 */
var User = function(service) {
  Dao.call(this, service, 'sys', 'user');
};

util.inherits(User, Dao);

module.exports = User;

/**
 * 查询指定登录名的用户
 * @param  {Number}   orgId     组织编号
 * @param  {String}   loginname 登录名
 * @param  {Function} cb        回调函数
 */
User.prototype.findByLoginname = function(orgId, loginname, cb) {
  this.query({ 
    where: 'loginname=\''+loginname+'\' and org_id='+orgId+' and status=0',
    fields: 'id,name,loginname,password,sex,mobile,email,motto' 
  }, cb);
};

/**
 * 查询指定编号的用户
 * @param  {Number}   orgId   组织编号
 * @param  {String}   userId  用户编号
 * @param  {Function} cb      回调函数
 */
User.prototype.findById = function(orgId, userId, cb) {
  this.query({ 
    where: 'id='+userId+' and org_id='+orgId,
    fields: 'id,code,name,loginname,sex,mobile,email,motto' 
  }, cb);
};

/**
 * 查询所有有效的用户
 * @param  {Function} cb 回调函数
 */
User.prototype.findAllValid = function(orgId, depId, cb) {
  var where = 'status=0 and org_id='+orgId;
  if(depId && depId>0) where += ' and id in (select user_id from sys_dep_user '
    +'where org_id='+orgId+' and dep_id='+depId+')';
  this.query({ 
    where: where,
    fields: 'id,code,name,loginname,mobile,email,sex,post,head_id',
    order: 'code ASC,id ASC'
  }, cb);
};

/**
 * 修改用户的最后登录信息
 * @param  {Object}   orgId   组织编号
 * @param  {Object}   userId  用户编号
 * @param  {String}   address IP地址
 * @param  {Function} cb      回调函数
 */
User.prototype.updateLastLogin = function(orgId, userId, address, deviceId, cb) {
  this.update(
      {lastLoginTime: new Date(), lastLoginIp: address, last_device_id: deviceId},
      {where: 'id='+userId+' and org_id='+orgId}, cb);
};