var util = require('util');
var Dao = require('Dao');

/**
 * 角色用户数据模型类
 */
var Role_User = function(service) {
  Dao.call(this, service, 'sys', 'role_user');
};

util.inherits(Role_User, Dao);

module.exports = Role_User;

/**
 * 查询所有角色用户
 * @param  {Function} cb 回调函数
 */
Role_User.prototype.findAll = function(cb) {
  this.query({ 
    fields: 'role_id,user_id',
    where: 'user_id in (select id from sys_user where status=0 and org_id='
    	+'(select org_id from sys_role where id=sys_role_user.role_id and name<>"所有人"))',
    order: '(select code from sys_user where id=sys_role_user.user_id) asc'
  }, cb);
};

/**
 * 查询指定组织所有角色用户
 * @param  {Function} cb 回调函数
 */
Role_User.prototype.findByOrgId = function(orgId, cb) {
  this.query({ 
    fields: 'role_id,user_id',
    where: 'org_id='+orgId+' and user_id in (select id from sys_user where status=0 and org_id='
    	+'(select org_id from sys_role where id=sys_role_user.role_id and name<>"所有人"))',
    order: '(select code from sys_user where id=sys_role_user.user_id) asc'
  }, cb);
};