var util = require('util');
var Dao = require('Dao');

/**
 * 角色数据模型类
 */
var Role = function(service) {
  Dao.call(this, service, 'sys', 'role');
};

util.inherits(Role, Dao);

module.exports = Role;

/**
 * 查询所有有效的角色
 * @param  {Function} cb 回调函数
 */
Role.prototype.findAllValid = function(cb) {
  this.query({ 
    where: 'status=0 and name<>\'所有人\'',
    order: 'code ASC,id ASC'
  }, cb);
};

/**
 * 查询指定组织所有有效的角色
 * @param  {Function} cb 回调函数
 */
Role.prototype.findByOrgId = function(orgId, cb) {
  this.query({ 
    where: 'status=0 and name<>\'所有人\' and org_id='+orgId,
    order: 'code ASC,id ASC'
  }, cb);
};