var util = require('util');
var Dao = require('Dao');

/**
 * 组织数据模型类
 */
var Org = function(service) {
  Dao.call(this, service, 'sys', 'org');
};

util.inherits(Org, Dao);

module.exports = Org; 

/**
 * 查询指定代码的组织
 * @param  {String}   code 组织代码
 * @param  {Function} cb   回调函数
 */
Org.prototype.findByCode = function(code, cb) {
  this.query({ where: 'code=\''+code+'\'' }, cb);
};

/**
 * 查询所有有效的组织
 * @param  {Function} cb   回调函数
 */
Org.prototype.findAllValid = function(cb) {
  this.query({ where: 'status=0' }, cb);
};

/**
 * 查询所有ID
 * @param  {Function} cb   回调函数
 */
Org.prototype.findAllValidId = function(cb) {
  this.query({ fields: 'id', where: 'status=0' }, cb);
};

/**
 * 查询所有组织
 * @param  {Function} cb   回调函数
 */
Org.prototype.findAll = function(cb) {
  this.query(null, cb);
};

/**
 * 修改最后更新时间
 * @param  {Function} cb   回调函数
 */
Org.prototype.setLastUpdate = function(id, cb) {
  var lastUpdate = new Date();
  this.update({last_update: lastUpdate}, {where:'id='+id}, function() {
  	server.cache.setCurOrg({last_update: lastUpdate}, function(){
  		cb(lastUpdate);
  	});
  });
};