var util = require('util');
var Dao = require('Dao');

/**
 * 部门用户数据模型类
 */
var Dep_User = function(service) {
  Dao.call(this, service, 'sys', 'dep_user');
};

util.inherits(Dep_User, Dao);

module.exports = Dep_User;

/**
 * 查询所有部门用户
 * @param  {Function} cb 回调函数
 */
Dep_User.prototype.findAll = function(cb) {
  this.query({ 
    fields: 'dep_id,user_id',
    where: 'user_id in (select id from sys_user where status=0 and org_id='
    	+'(select org_id from sys_dep where id=sys_dep_user.dep_id))',
    order: '(select code from sys_user where id=sys_dep_user.user_id) asc'
  }, cb);
};

/**
 * 查询指定组织所有部门用户
 * @param  {Function} cb 回调函数
 */
Dep_User.prototype.findByOrgId = function(orgId, cb) {
  this.query({ 
    fields: 'dep_id,user_id',
    where: 'org_id='+orgId+' and user_id in (select id from sys_user where status=0 and org_id='
    	+'(select org_id from sys_dep where id=sys_dep_user.dep_id))',
    order: '(select code from sys_user where id=sys_dep_user.user_id) asc'
  }, cb);
};