var util = require('util');
var Dao = require('Dao');

/**
 * 部门数据模型类
 */
var Dep = function(service) {
  Dao.call(this, service, 'sys', 'dep');
};

util.inherits(Dep, Dao);

module.exports = Dep;

/**
 * 查询所有有效的部门
 * @param  {Function} cb 回调函数
 */
Dep.prototype.findAllValid = function(cb) {
  this.query({ 
    where: 'status=0',
    fields: 'id, code, name, org_id, parent_id',
    order: 'code ASC, id ASC'
  }, cb);
};

/**
 * 查询指定组织所有有效的部门
 * @param  {Function} cb 回调函数
 */
Dep.prototype.findByOrgId = function(orgId, cb) {
  this.query({ 
    where: 'status=0 and org_id='+orgId,
    fields: 'id, code, name, org_id, parent_id',
    order: 'code ASC, id ASC'
  }, cb);
};

/**
 * 查询指定父部门中指定名称的部门
 * @param  {Object} user 用户对象
 * @param  {String} name 群组名称
 * @param  {Function} cb 回调函数
 */
Dep.prototype.findByNameAndParentId = function(orgId, parentId, name, cb) {
  this.query({ 
  	where: 'parent_id='+parentId+' and name=\''+name+'\' and org_id='+orgId,
    fields: 'id,name'
  }, cb);
};