/****************************************************
 * 
 * @author smz
 * @version 
 ***************************************************/

var util = require('util');
var utils = require('utils');
var Business = require('Business');
var Dao = require('Dao');
var axios = require('axios');
var crypto = require('crypto');

var WeixinBl = function (service) {
  Business.call(this, service);
 
  // //wxid_v63n8loq4we712
  // this.appId = "wx384499343719f59e";
  // this.appSecret ="900175531128ba6c7c59ae868f99d0a5";

   //gh_cbcd2ccba3a5
   this.appId = "wx1e2215a35c2c2b74";
   this.appSecret ="4151ab1a265d52f3c672d9201b460aae";

  // //gh_8cae1681f3c2 
  // this.appId = "wx1fffb7569d70f4ad";
  // this.appSecret = "301ca85dfb9ebc791ae92db353d0f430";

};

util.inherits(WeixinBl, Business);

module.exports = WeixinBl;

/**
 * 登录
 * @param {*} args 
 * js_code
 * @param {*} cb 
 * {openid session_key unionid}
 */
WeixinBl.prototype.code2Session = function (args, cb) {
  var self = this;
  var parameterData = "?appid=" + self.appId + "&secret=" + self.appSecret + "&js_code=" + args.js_code + "&grant_type=authorization_code";
  axios
    .get('https://api.weixin.qq.com/sns/jscode2session' + parameterData)
    .then(function (res) {
      if (!res.data.errcode) {
        if (!res.data.unionid) res.data.unionid = res.data.openid;
        cb(res.data);
      }
      else {
        // console.log(res.data);
        self.service.onLogicError(80001, "微信公众号授权失败：" + res.data.errmsg);
      }
    })
    .catch(function (error) {
      self.service.onLogicError(80001, error.message);
    });


  // var self = this;
  // var https0 = require('https');

  // var parameterData = "?appid=" + self.appId + "&secret=" + self.appSecret + "&js_code=" + args.js_code + "&grant_type=authorization_code";
  // var options0 = {
  //   hostname: 'api.weixin.qq.com',
  //   port: 443,
  //   path: '/sns/jscode2session' + parameterData,
  //   method: 'GET'
  // };
  // var req0 = https0.request(options0, function (res0) {
  //   res0.setEncoding('utf8');
  //   var bufferHelper0 = new BufferHelper();
  //   res0.on('data', function (chunk) {
  //     bufferHelper0.concat(new Buffer(chunk));
  //   });
  //   res0.on('end', function (chunk) {
  //     try {
  //       var str = bufferHelper0.toBuffer().toString();
  //       bufferHelper0 = null;
  //       var resData = JSON.parse(str);
  //       if (!resData.errcode) {
  //         if (!resData.unionid) resData.unionid = resData.openid;
  //         // cb(0, resData);
  //         cb(resData);
  //       }
  //       else {
  //         // cb(new Error("80001", "微信公众号授权失败：" + resData.errmsg));
  //         // self.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
  //         self.service.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
  //       }
  //     }
  //     catch (e) {
  //       // cb(e);
  //       // self.onLogicError(80001, e.message);
  //       self.service.onLogicError(80001, e.message);
  //     }
  //     res0 = null;
  //     req0 = null;
  //   });
  // });
  // req0.on('error', function (e) {
  //   // cb(e);
  //   // self.onLogicError(80001, e.message);
  //   self.service.onLogicError(80001, e.message);
  // });
  // req0.end();
};

/**
 * 解密
 * @param {*} encryptedData 
 * @param {*} iv 
 * @param {*} session_key 
 * @returns 
 */
WeixinBl.prototype.decryptData = function (encryptedData, iv, session_key) {
  // base64 decode
  var sessionKey = new Buffer(session_key, 'base64');
  encryptedData = new Buffer(encryptedData, 'base64');
  iv = new Buffer(iv, 'base64')

  try {
    // 解密
    var decipher = crypto.createDecipheriv('aes-128-cbc', sessionKey, iv);
    // 设置自动 padding 为 true，删除填充补位
    decipher.setAutoPadding(true);
    var decoded = decipher.update(encryptedData, 'binary', 'utf8');
    decoded += decipher.final('utf8');
    decoded = JSON.parse(decoded);
  } catch (err) {
    throw new Error('Illegal Buffer');
  }

  if (decoded.watermark.appid !== this.appId) {
    throw new Error('Illegal Buffer');
  }

  return decoded;
};

/**
 * 接口调用凭据
 * @param {*} args 
 * @param {*} cb 
 * {access_token expires_in access_time}
 */
WeixinBl.prototype.getAccessToken = function (args, cb) {
  var self = this;
  var parameterData = "?appid=" + self.appId + "&secret=" + self.appSecret + "&grant_type=client_credential";
  axios
    .get('https://api.weixin.qq.com/cgi-bin/token' + parameterData)
    .then(function (res) {
      if (!res.data.errcode) {
        var dd = new Date();
        res.data.access_time = new Date(dd.setSeconds(dd.getSeconds() + res.data.expires_in - 5 * 60));
        cb(res.data);
      }
      else {
        // console.log(res.data);
        self.service.onLogicError(80001, "微信公众号授权失败：" + res.data.errmsg);
      }
    })
    .catch(function (error) {
      self.service.onLogicError(80001, error.message);
    });


  // var self = this;
  // var https0 = require('https');

  // var parameterData = "?appid=" + self.appId + "&secret=" + self.appSecret + "&grant_type=client_credential";
  // var options0 = {
  //   hostname: 'api.weixin.qq.com',
  //   port: 443,
  //   path: '/cgi-bin/token' + parameterData,
  //   method: 'GET'
  // };
  // var req0 = https0.request(options0, function (res0) {
  //   res0.setEncoding('utf8');
  //   var bufferHelper0 = new BufferHelper();
  //   res0.on('data', function (chunk) {
  //     bufferHelper0.concat(new Buffer(chunk));
  //   });
  //   res0.on('end', function (chunk) {
  //     try {
  //       var str = bufferHelper0.toBuffer().toString();
  //       bufferHelper0 = null;
  //       var resData = JSON.parse(str); //access_token expires_in
  //       if (!resData.errcode) {
  //         var dd = new Date();
  //         resData.access_time = new Date(dd.setSeconds(dd.getSeconds() + resData.expires_in - 5 * 60));
  //         // cb(0, resData);
  //         cb(resData);
  //       }
  //       else {
  //         // cb(new Error("80001", "微信公众号授权失败：" + resData.errmsg));
  //         // self.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
  //         self.service.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
  //       }
  //     }
  //     catch (e) {
  //       // cb(e);
  //       // self.onLogicError(80001, e.message);
  //       self.service.onLogicError(80001, e.message);
  //     }
  //     res0 = null;
  //     req0 = null;
  //   });
  // });
  // req0.on('error', function (e) {
  //   // cb(e);
  //   // self.onLogicError(80001, e.message);
  //   self.service.onLogicError(80001, e.message);
  // });
  // req0.end();
};

/**
 * 手机号
 * @param {*} args 
 * access_token phone_code
 * @param {*} cb 
 * {phoneNumber}
 */
WeixinBl.prototype.getPhoneNumber = function (args, cb) {
  var self = this;
  var parameterData = "?access_token=" + args.access_token;
  var postData = {
    code: args.phone_code
  };
  axios
    .post('https://api.weixin.qq.com/wxa/business/getuserphonenumber' + parameterData, postData)
    .then(function (res) {
      if (!res.data.errcode) {
        cb(res.data.phone_info);
      }
      else {
        console.log(res.data);
        self.service.onLogicError(80001, "微信公众号授权失败：" + res.data.errmsg);
      }
    })
    .catch(function (error) {
      self.service.onLogicError(80001, error.message);
    });
};

/**
 * 接口调用凭据
 * @param {*} args 
 * @param {*} cb 
 */
WeixinBl.prototype.checkAccessToken = function (args, cb) {
  var self = this;
  var dao = new Dao(this.service);
  dao.execute("select appid,appsecret,access_token,expires_in,access_time from ares_introduction where id=?", [args.id], function (rows) {
    var data = rows[0];
    if (!data || !data.access_token || !data.access_time || data.access_time < new Date()) {
      self.getAccessToken({}, function (wxobj) {
        data = wxobj;
        dao.execute("update ares_introduction set access_token=?,expires_in=?,access_time=? where id=?",
          [wxobj.access_token, wxobj.expires_in, wxobj.access_time, args.id], function () {
            cb(data);
          });
      });
    }
    else {
      cb(data);
    }
  });
};



/**
 * 
 */
WeixinBl.prototype.checkEncryptedData = function (args, cb) {
  var self = this;
  var https0 = require('https');

  var postData = JSON.stringify({
    "encrypted_msg_hash": args.phone_code
    // "access_token": args.access_token
  });

  var parameterData = "?access_token=" + args.access_token;
  var options0 = {
    hostname: 'api.weixin.qq.com',
    path: '/wxa/business/checkencryptedmsg' + parameterData,
    // url: 'https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=' + args.access_token,
    // header: {
    //   'Content-Type' : 'application/x-www-form-urlencoded', //'application/json'
    //   'content-Length': postData.length
    // },
    method: 'POST'
  };
  var req0 = https0.request(options0, function (res0) {
    console.log(res0);
    cb('dddddddddddd');
    // res0.setEncoding('utf8');
    var bufferHelper0 = new BufferHelper();
    res0.on('data', function (chunk) {
      console.log(chunk);
      console.log("datadatadatadatadatadatadatadatadatadatadatadatadatadata");
      bufferHelper0.concat(new Buffer(chunk));
    });
    res0.on('end', function (chunk) {
      try {
        var str = bufferHelper0.toBuffer().toString();
        console.log("strstrstrstrstrstrstrstrstr");
        console.log(str);
        bufferHelper0 = null;
        var resData = JSON.parse(str);
        if (!resData.errcode) {
          cb(resData);
        }
        else {
          // cb(new Error("80001", "微信公众号授权失败：" + resData.errmsg));
          // self.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
          console.log(resData);
          self.service.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
        }
      }
      catch (e) {
        // cb(e);
        // self.onLogicError(80001, e.message);
        console.log(e);
        self.service.onLogicError(80001, e.message);
      }
      res0 = null;
      req0 = null;
    });
  });
  req0.on('error', function (e) {
    // cb(e);
    // self.onLogicError(80001, e.message);
    self.service.onLogicError(80002, e.message);
  });
  req0.write(postData);
  req0.end();
};

/**
 * 
 * @param {*} args 
 * access_token code
 * @param {*} cb 
 * {openpid}
 */
WeixinBl.prototype.getPluginOpenPId = function (args, cb) {
  var self = this;
  var https0 = require('https');

  var parameterData = "?access_token=" + args.access_token;
  var options0 = {
    hostname: 'api.weixin.qq.com',
    port: 443,
    path: '/wxa/getpluginopenpid' + parameterData,
    method: 'GET'
  };
  var req0 = https0.request(options0, function (res0) {
    res0.setEncoding('utf8');
    var bufferHelper0 = new BufferHelper();
    res0.on('data', function (chunk) {
      bufferHelper0.concat(new Buffer(chunk));
    });
    res0.on('end', function (chunk) {
      try {
        var str = bufferHelper0.toBuffer().toString();
        bufferHelper0 = null;
        var resData = JSON.parse(str);
        if (!resData.errcode) {
          cb(0, resData);
        }
        else {
          // cb(new Error("80001", "微信公众号授权失败：" + resData.errmsg));
          // self.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
          self.service.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
        }
      }
      catch (e) {
        // cb(e);
        // self.onLogicError(80001, e.message);
        self.service.onLogicError(80001, e.message);
      }
      res0 = null;
      req0 = null;
    });
  });
  req0.on('error', function (e) {
    // cb(e);
    // self.onLogicError(80001, e.message);
    self.service.onLogicError(80001, e.message);
  });
  req0.write(postData);
  req0.end();
};

/**
 * 
 * @param {*} args 
 * access_token openid
 * @param {*} cb 
 * {unionid}
 */
WeixinBl.prototype.getPaidUnionId = function (args, cb) {
  var self = this;
  var https0 = require('https');

  var parameterData = "?access_token=" + args.access_token + "&openid=" + args.openid;
  var options0 = {
    hostname: 'api.weixin.qq.com',
    port: 443,
    path: '/wxa/getpaidunionid' + parameterData,
    method: 'GET'
  };
  var req0 = https0.request(options0, function (res0) {
    res0.setEncoding('utf8');
    var bufferHelper0 = new BufferHelper();
    res0.on('data', function (chunk) {
      bufferHelper0.concat(new Buffer(chunk));
    });
    res0.on('end', function (chunk) {
      try {
        var str = bufferHelper0.toBuffer().toString();
        bufferHelper0 = null;
        var resData = JSON.parse(str);
        if (!resData.errcode) {
          cb(0, resData);
        }
        else {
          // cb(new Error("80001", "微信公众号授权失败：" + resData.errmsg));
          // self.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
          self.service.onLogicError(80001, "微信公众号授权失败：" + resData.errmsg);
        }
      }
      catch (e) {
        // cb(e);
        // self.onLogicError(80001, e.message);
        self.service.onLogicError(80001, e.message);
      }
      res0 = null;
      req0 = null;
    });
  });
  req0.on('error', function (e) {
    // cb(e);
    // self.onLogicError(80001, e.message);
    self.service.onLogicError(80001, e.message);
  });
  req0.end();
};