var util = require('util');
var fs = require('fs');
var path = require('path');
var cmd = require('child_process');
var Service = require('Service');
var utils = require('utils');
var MsgDao = require('../dao/vmsg_send');
var MsgReceiveDao = require('../../sys/dao/msg_receive');

/**
 * 接收文件
 */
var ReceiveFile = function() {
    Service.call(this);
    this.checkAuthority = false;
};

util.inherits(ReceiveFile, Service);

module.exports = ReceiveFile;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
ReceiveFile.prototype.process = function(req, res) {
    if (!req.msgId) {
        this.onError(1, '请提供消息编号！', req);
        return;
    }
    var self = this;
    var msgDao = new MsgDao(this);
    msgDao.query({
        //fields: 'sender_id as senderid,file_code as filecode,' +
        //    'file_name as filename,file_type as filetype,send_time as sendtime',
        where: 'id=' + req.msgId + ' and org_id=' + req.session.orgId
    }, function(rows) {
        if (rows.length == 0) {
            self.onLogicError(2, '消息不存在或已过期！', req);
            return;
        }
        let row = rows[0];
        row.senderid = row.sender_id;
        row.filecode = row.file_code;
        row.filename = row.file_name;
        row.filetype = row.file_type;
        row.sendtime = row.send_time;
        var msgReceiveDao = new MsgReceiveDao(self);
        msgReceiveDao.query({
            fields: 'id',
            where: 'msg_id=' + req.msgId + ' and receiver_id=' + req.session.userId
        }, function(rows2) {
            if (rows2.length == 0) {
                self.onLogicError(2, '您无权接收该文件！', req);
                return;
            }
              //暂时先关闭数据库连接，等接收完毕再连，以免因为上传文件时间太久造成数据库连接超时
              var pid = self.connection.threadId;
              self.log('[pid:' + pid + ']关闭数据库连接。');
              if(server.config.Database.type=="mssql") {
                  self.connection.close();
              } else {
                  self.connection.end();
              }
              self.connection = null;
            self.Receive(req, res, row);
        });
    });
};

ReceiveFile.prototype.Receive = function(req, res, fileMsg) {
    //后面发送已读回执要用
    req.receiverId = fileMsg.senderid;

    var fileCode = fileMsg.filecode;
    var fileType = fileMsg.filetype;
    var fileName = fileMsg.filename;
    var sendtime = new Date(fileMsg.sendtime);

    if (req.isDirFile) {
        fileCode = req.fileCode;
        fileType = 'file';
        fileName = req.fileName;
    }

    //创建文件保存路径
    var relativePath = '/' + req.session.orgCode + '/im/' + fileType +
        '/' + utils.formatDate(sendtime, 'yyyy_MM') + '/' + fileCode;
    var filePath = path.join(server.attachSavePath, relativePath);

    if (fileType == 'image') {
        filePath += path.extname(fileName);
    }
    if (req.thumbnail && (fileType == 'image' || fileType == 'video')) {
        if (fs.existsSync(filePath + '.thumbnail')) filePath += '.thumbnail';
    }

    console.log("*****************", filePath);

    if (!fs.existsSync(filePath)) {
        this.onLogicError(2, '文件不存在或已过期！', req);
        return;
    }

    if (req.session.clientType == 'pc' && fileType == 'voice') {
        this.sendMp3File(req, res, fileCode, filePath);
    } else {
        this.sendFile(req, res, fileCode, filePath);
    }
};

ReceiveFile.prototype.sendMp3File = function(req, res, fileCode, filePath) {
    var self = this;
    var mp3File = filePath + '.mp3';
    if (fs.existsSync(mp3File)) {
        self.sendFile(req, res, fileCode, mp3File);
        return;
    }

    cmd.exec('ffmpeg -i ' + filePath + ' ' + mp3File, function(error, stdout, stderr) {
        if (error) {
            logger.log('将语音文件转换为MP3格式时发生意外错误：' + error.message, req._requestId);
            self.sendFile(req, res, fileCode, filePath);
            return;
        }
        self.sendFile(req, res, fileCode, mp3File);
    });
};

ReceiveFile.prototype.sendFile = function(req, res, fileCode, filePath) {
    var self = this;
    fs.stat(filePath, function(err, stats) {
        if (err) {
            self.onLogicError(3, err.message, req);
            return;
        }

        logger.log('准备发送文件[' + fileCode + ']。', req._requestId);

        var readStream = null;
        if (req.start) {
            readStream = fs.createReadStream(filePath, { start: req.start, end: stats.size - 1 });
        } else {
            readStream = fs.createReadStream(filePath);
        }
        readStream.on('end', function(err2) {
            if (err2) {
                logger.log('发送文件时发生意外错误，错误描述：' + err2.message, req._requestId);
                return;
            }
            logger.log('文件[' + fileCode + ']发送完毕。', req._requestId);

            server.requestAppService(req, "im/service/readMsg", {
                msgId: req.msgId,
                receiverId: req.receiverId
            }, function(res) {
                if (res.code != 0) {
                    self.onLogicError(10, res.message, req);
                    return;
                }

                //self.end(null);
            });
        });

        req.socket._socket.on('data', function() {
            readStream.pipe(req.socket._socket);
        });

        req.socket.stopListen();

        var msg = {};
        msg.code = 0;
        msg.fileSize = stats.size;
        req.socket.push(msg, function(err) {
            if (err) {
                logger.log('发送文件时发生意外错误，错误描述：' + err.message, req._requestId);
                self.end(null);
                return;
            }
        });
    });
};