var util = require('util');
var Dao = require('Dao');

var Group_User = function (service) {
  Dao.call(this, service, 'im', 'group_user');
};

util.inherits(Group_User, Dao);

module.exports = Group_User;

/**
 * 查询所有群组用户
 * @param  {Function} cb 回调函数
 */
Group_User.prototype.findAll = function (cb) {
  this.query({
    fields: 'group_id,user_id,favorite',
    where: 'user_id in (select id from tm_user where status=0 and org_id=im_group_user.org_id)',
    order: '(select code from tm_user where id=im_group_user.user_id) asc'
  }, cb);
};