var util = require('util');
var Dao = require('Dao');

var Group = function (service) {
  Dao.call(this, service, 'im', 'group');
};

util.inherits(Group, Dao);

module.exports = Group;

/**
 * 查询所有群组
 * @param  {Function} cb 回调函数
 */
Group.prototype.findAll = function (cb) {
  this.query({ order: 'code ASC,id ASC' }, cb);
};

/**
 * 查询指定名称的群组
 * @param  {Object} user 用户对象
 * @param  {String} name 群组名称
 * @param  {Function} cb 回调函数
 */
Group.prototype.findByName = function (orgId, userId, name, cb, type) {
  var where = '';
  if (type == "repeat") {
    where += ' and status=0';
  }
  this.query({
    where: 'user_id=' + userId + ' and name="' + name + '" and org_id=' + orgId + where,
    fields: 'id,name'
  }, cb);
};