var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
// var WXFPHandler = require('WXFPHandler');
var WXFPHandler = require('../wxfp/WXFPHandler');

/**
 * 获得WXFP页面的HTML代码
 */
var GetHtml = function () {
  Service.call(this);
};

util.inherits(GetHtml, Service);

module.exports = GetHtml;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetHtml.prototype.process = function (req, res) {
  if (!req.pagePath) {
    this.onLogicError(1, "请提供TFP页面路径！");
    return;
  }
  // if (!req.pageDataModel) {
  //   this.onLogicError(2, "请提供TFP页面数据模型！");
  //   return;
  // }
  let self = this;
  if (!req.pageDataModel) {
    self.getPageDataModel(req, res, function () {
      self.run(req, res);
    });
  }
  else {
    self.run(req, res);
  }
};

GetHtml.prototype.run = function (req, res) {
  let self = this;
  var pp = req.pagePath.replace('/minisrc/', '');
  req.projCode = pp.substring(0, pp.indexOf('/'));
  pp = pp.substring(pp.indexOf('/') + 1);
  req.miniCode = pp.substring(0, pp.indexOf('/'));
  // pp = pp.substring(pp.indexOf('/') + 1).replace('.wxfp', ''); //TODO:wxfp
  pp = pp.substring(pp.indexOf('/') + 1).replace('.tfp', '');
  req.pageDir = pp + "/";
  req.pageName = pp.substring(pp.lastIndexOf('/') + 1);
  req.relativeDir = "";
  var rs = req.pageDir.split("/").length;
  for (var i = 0; i < rs; i++) {
    req.relativeDir += "../";
  }

  let options = {
    urlPath: req.pagePath,
    pageDir: req.pageDir,
    pageName: req.pageName,
    relativeDir: req.relativeDir,
    pageDataModel: req.pageDataModel,
    createFile: false
  };
  let wxFPHandler = new WXFPHandler();
  wxFPHandler.compileWXFP(options, function (err, wx) {
    if (err) {
      logger.log(err);
      self.onLogicError(500, '编译TFP文件失败。');
      return;
    }

    res.json = wx.wxjson;
    res.js = wx.wxjs;
    res.html = wx.wxml;
    res.css = wx.wxss;

    if (req.compileWXFP) {
      self.setMiniAppConfig(req, res, function () {
        self.setMiniDir(req, res, function () {
          self.setMiniJson(req, res, function () {
            self.setMiniJs(req, res, function () {
              self.setMiniHtml(req, res, function () {
                self.setMiniCss(req, res, function () {
                  self.end(res);
                });
              });
            });
          });
        });
      });
    }
    else {
      self.end(res);
    }
  });
};

GetHtml.prototype.getPageDataModel = function (req, res, cb) {
  var filePath = utils.getPath(req.pagePath);
  if (!fs.existsSync(filePath)) {
    this.onLogicError(2, '文件不存在！');
    return;
  }
  var self = this;
  fs.readFile(filePath, "utf-8", function (err, data) {
    req.pageDataModel = JSON.parse(data);
    cb();
  });
}

GetHtml.prototype.setMiniAppConfig = function (req, res, cb) {
  var self = this;
  var miniAppConfigFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/app.json");
  console.log(miniAppConfigFile);
  fs.readFile(miniAppConfigFile, "utf-8", function (err, data) {
    var data0 = JSON.parse(data);

    var b = false;
    for (var i = 0; i < data0.pages.length; i++) {
      if (data0.pages[i] == 'pages/' + req.pageDir + req.pageName) {
        b = true;
        break;
      }
    }
    if (!b) {
      data0.pages.push('pages/' + req.pageDir + req.pageName);
    }

    fs.writeFile(miniAppConfigFile, JSON.stringify(data0, null, 2), function (err) {
      cb();
    });
  });
};

GetHtml.prototype.setMiniDir = function (req, res, cb) {
  var pageDir = req.pageDir;

  var d = "/miniprogram/" + req.projCode + "/" + req.miniCode + "/pages";
  var miniDir = utils.getPath(d);
  if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);

  do {
    d = d + '/' + pageDir.substring(0, pageDir.indexOf('/'));
    miniDir = utils.getPath(d);
    if (!fs.existsSync(miniDir)) fs.mkdirSync(miniDir);
    pageDir = pageDir.substring(pageDir.indexOf('/') + 1);
  }
  while (pageDir.indexOf('/') > 0)

  cb();
};

GetHtml.prototype.setMiniJson = function (req, res, cb) {
  var self = this;
  var miniJsonFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/pages/" + req.pageDir + req.pageName + ".json");
  fs.writeFile(miniJsonFile, res.json, function (err) {
    cb();
  });
};

GetHtml.prototype.setMiniJs = function (req, res, cb) {
  var self = this;
  var miniJsFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/pages/" + req.pageDir + req.pageName + ".js");
  fs.writeFile(miniJsFile, res.js, function (err) {
    cb();
  });
};

GetHtml.prototype.setMiniHtml = function (req, res, cb) {
  var self = this;
  var miniHtmlFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/pages/" + req.pageDir + req.pageName + ".wxml");
  fs.writeFile(miniHtmlFile, res.html, function (err) {
    cb();
  });
};

GetHtml.prototype.setMiniCss = function (req, res, cb) {
  var self = this;
  var miniCssFile = utils.getPath("/miniprogram/" + req.projCode + "/" + req.miniCode + "/pages/" + req.pageDir + req.pageName + ".wxss");
  fs.writeFile(miniCssFile, res.css, function (err) {
    cb();
  });
};