var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 创建空白WXFP文件
 */
var createNullWXFP = function () {
  Service.call(this);
};

util.inherits(createNullWXFP, Service);

module.exports = createNullWXFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
createNullWXFP.prototype.process = function (req, res) {
  if (!req.path) {
    this.onLogicError(1, "请提供路径！");
    return;
  }
  if (!req.filename) {
    this.onLogicError(2, "请提供文件名称！");
    return;
  }
  if (req.filename.match(/[^\w]/g)) {
    this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  let pageType = "page";
  if (req.pageType == "dialog") pageType = "dialog";
  if (req.pageType == "dialog") {
    if (!req.dialogWidth) {
      this.onLogicError(9, "请提供窗口宽度！");
      return;
    }
    req.dialogWidth += "";
    if (!req.dialogHeight) {
      this.onLogicError(10, "请提供窗口高度！");
      return;
    }
    req.dialogHeight += "";
  }
  let positionType = "float";
  if (req.positionType) positionType = req.positionType;
  let bgColorMode = "light";
  if (req.bgColorMode == "dark") bgColorMode = "dark";

  // let fileName = req.filename.endWith(".wxfp") ? req.filename : req.filename + ".wxfp"; //TODO:wxfp
  let fileName = req.filename.endWith(".tfp") ? req.filename : req.filename + ".tfp"; //TODO:tfp
  let filePath = utils.getPath(req.path + "/" + fileName);
  if (fs.existsSync(filePath)) {
    this.onLogicError(11, "文件已存在！");
    return;
  }

  var tfp = {
    client: req.client,
    framework: "wxfp",
    positionType: positionType,
    pageType: pageType,
    bgColorMode: bgColorMode,
    title: req.title,
    type: "Page",
    components: []
  };
  if (req.pageType == "dialog") {
    tfp.width = req.dialogWidth + "";
    tfp.width = tfp.width.indexOf("px") > 0 ? tfp.width : tfp.width + "px";
    tfp.height = req.dialogHeight + "";
    tfp.height = tfp.height.indexOf("px") > 0 ? tfp.height : tfp.height + "px";
    tfp.components.push({
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "left": "0",
        "height": "50px",
        "right": "0",
        "bottom": "0",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [{
        id: "button_cancel",
        type: "Button",
        buttonType: "default",
        value: "取消",
        theme: "rect",
        onClick: "tfp.closeCurDialog()",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "20px",
          "cursor": "pointer",
          "text-align": "center"
        }
      }, {
        id: "button_submit",
        type: "Button",
        buttonType: "primary",
        value: "确定",
        theme: "rect",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "10px",
          "cursor": "pointer",
          "text-align": "center"
        },
        onClick: "form1.submit()"
      }]
    });
  }
  fs.writeFileSync(filePath, JSON.stringify(tfp, null, "  "));

  this.end(res);
};