var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 创建登录页WXFP文件
 */
var createNullWXFP = function () {
  Service.call(this);
};

util.inherits(createNullWXFP, Service);

module.exports = createNullWXFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
createNullWXFP.prototype.process = function (req, res) {
  if (!req.path) {
    this.onLogicError(1, "请提供路径！");
    return;
  }
  if (!req.filename) {
    this.onLogicError(2, "请提供文件名称！");
    return;
  }
  if (req.filename.match(/[^\w]/g)) {
    this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  let pageType = "page";
  if (req.pageType == "dialog") pageType = "dialog";
  if (req.pageType == "dialog") {
    if (!req.dialogWidth) {
      this.onLogicError(9, "请提供窗口宽度！");
      return;
    }
    req.dialogWidth += "";
    if (!req.dialogHeight) {
      this.onLogicError(10, "请提供窗口高度！");
      return;
    }
    req.dialogHeight += "";
  }
  let positionType = "float";
  if (req.positionType) positionType = req.positionType;
  let bgColorMode = "light";
  if (req.bgColorMode == "dark") bgColorMode = "dark";

  // let fileName = req.filename.endWith(".wxfp") ? req.filename : req.filename + ".wxfp"; //TODO:wxfp
  let fileName = req.filename.endWith(".tfp") ? req.filename : req.filename + ".tfp"; //TODO:tfp
  let filePath = utils.getPath(req.path + "/" + fileName);
  if (fs.existsSync(filePath)) {
    this.onLogicError(11, "文件已存在！");
    return;
  }

  var tfp = {
    client: req.client,
    framework: "wxfp",
    positionType: positionType,
    pageType: pageType,
    bgColorMode: bgColorMode,
    title: req.title,
    type: "Page",
    components: [],
	"jsFuncs": [
		{
			"name": "button1_bindtap",
			"comment": "点击时",
			"editType": "code",
			"args": [
				{
					"name": "e"
				}
			],
			"eventArgs": "",
			"code": "\n    var that = this;\r\n    that.tfp.login({ \"loginname\": that.data.loginname, \"password\": that.data.password }, function () {\r\n        wx.redirectTo({\r\n            url: '../home/home'\r\n        });\r\n    })\r\n",
			"statements": [
				{
					"category": "logic",
					"defaultVal": "this",
					"type": "declare",
					"varName": "that"
				}
			]
		}
	]
  };
  if (req.logoImageSrc) {
    tfp.components.push({
			"type": "Image",
			"id": "image1",
			"styles": {
				"width": "100%",
				"height": "30%"
			},
			"src": req.logoImageSrc
		});
  }
  tfp.components.push({
    "type": "FlexBox",
    "id": "flexBox1",
    "styles": {},
    "components": [
      {
        "id": "flexBox1_panel1",
        "type": "Panel",
        "isAttached": true,
        "styles": {
          "flex-basis": "30%"
        },
        "components": [
          {
            "type": "Label",
            "id": "label1",
            "value": "登录名：",
            "styles": {}
          }
        ]
      },
      {
        "id": "flexBox1_panel2",
        "type": "Panel",
        "isAttached": true,
        "styles": {
          "flex-basis": "60%"
        },
        "components": [
          {
            "type": "Text",
            "id": "loginname",
            "styles": {},
            "dataType": "text",
            "value": "admin",
            "required": true
          }
        ]
      }
    ]
  },
  {
    "type": "FlexBox",
    "id": "flexBox2",
    "styles": {},
    "components": [
      {
        "id": "flexBox2_panel1",
        "type": "Panel",
        "isAttached": true,
        "styles": {
          "flex-basis": "30%"
        },
        "components": [
          {
            "type": "Label",
            "id": "label2",
            "value": "密码：",
            "styles": {}
          }
        ]
      },
      {
        "id": "flexBox2_panel2",
        "type": "Panel",
        "isAttached": true,
        "styles": {
          "flex-basis": "60%"
        },
        "components": [
          {
            "type": "Password",
            "id": "password",
            "styles": {},
            "value": "tasgine"
          }
        ]
      }
    ]
  },
  {
    "type": "Panel",
    "id": "panel1",
    "styles": {
      "width": "100%",
      "padding-top": "20",
      "padding-bottom": "20",
      "position": "absolute",
      "z-index": "1",
      "left": "0",
      "bottom": "0",
	  "height":"100px",
	  "display":"flex",
	  "justify-items":"center",
	  "align-items":"center"
    },
    "components": [
      {
        "type": "Button",
        "id": "button1",
        "value": "登录",
        "buttonType": "primary",
        "styles": {},
        "sizeType": "",
		"bindtap": "button1_bindtap"
      }
    ]
  });
  if (req.pageType == "dialog") {
    tfp.width = req.dialogWidth + "";
    tfp.width = tfp.width.indexOf("px") > 0 ? tfp.width : tfp.width + "px";
    tfp.height = req.dialogHeight + "";
    tfp.height = tfp.height.indexOf("px") > 0 ? tfp.height : tfp.height + "px";
    tfp.components.push({
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "left": "0",
        "height": "50px",
        "right": "0",
        "bottom": "0",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [{
        id: "button_cancel",
        type: "Button",
        buttonType: "default",
        value: "取消",
        theme: "rect",
        onClick: "tfp.closeCurDialog()",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "20px",
          "cursor": "pointer",
          "text-align": "center"
        }
      }, {
        id: "button_submit",
        type: "Button",
        buttonType: "primary",
        value: "确定",
        theme: "rect",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "10px",
          "cursor": "pointer",
          "text-align": "center"
        },
        onClick: "form1.submit()"
      }]
    });
  }
  fs.writeFileSync(filePath, JSON.stringify(tfp, null, "  "));

  this.end(res);
};