var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 创建首页WXFP文件
 */
var createHomeWXFP = function () {
  Service.call(this);
};

util.inherits(createHomeWXFP, Service);

module.exports = createHomeWXFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
createHomeWXFP.prototype.process = function (req, res) {
  if (!req.path) {
    this.onLogicError(1, "请提供路径！");
    return;
  }
  if (!req.filename) {
    this.onLogicError(2, "请提供文件名称！");
    return;
  }
  if (req.filename.match(/[^\w]/g)) {
    this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  let pageType = "page";
  if (req.pageType == "dialog") pageType = "dialog";
  if (req.pageType == "dialog") {
    if (!req.dialogWidth) {
      this.onLogicError(9, "请提供窗口宽度！");
      return;
    }
    req.dialogWidth += "";
    if (!req.dialogHeight) {
      this.onLogicError(10, "请提供窗口高度！");
      return;
    }
    req.dialogHeight += "";
  }
  let positionType = "float";
  if (req.positionType) positionType = req.positionType;
  let bgColorMode = "light";
  if (req.bgColorMode == "dark") bgColorMode = "dark";

  // let fileName = req.filename.endWith(".wxfp") ? req.filename : req.filename + ".wxfp"; //TODO:wxfp
  let fileName = req.filename.endWith(".tfp") ? req.filename : req.filename + ".tfp"; //TODO:tfp
  let filePath = utils.getPath(req.path + "/" + fileName);
  if (fs.existsSync(filePath)) {
    this.onLogicError(11, "文件已存在！");
    return;
  }
  var tfp = {
    client: req.client,
    framework: "wxfp",
    positionType: positionType,
    pageType: pageType,
    bgColorMode: bgColorMode,
    title: req.title,
    type: "Page",
    components: [],
    styleSheets: [
      {
        "id": ".appRow",
        "styles": [
          {
            "name": "display",
            "value": "flex"
          },
          {
            "name": "flex-direction",
            "value": "column"
          },
          {
            "name": "align-items",
            "value": "center"
          },
          {
            "name": "justify-content",
            "value": "space-evenly"
          },
          {
            "name": "height",
            "value": "100px"
          }
        ]
      }
    ],
    "onLoad": "page1_onLoad",
    "jsFuncs": [
      {
        "name": "page1_onLoad",
        "comment": "",
        "editType": "code",
        "args": [{"name":"cb"}],
        "code": "    this.tfp.checkLogin({url:'../login/login'},cb);\n"
      }
    ]
  };
  if (req.have_swiper == 'true') {
    tfp.components.push({
      "type": "Swiper",
      "id": "topSwiper",
      "interval": "3000",
      "duration": "1000",
      "previousMargin": "0",
      "nextMargin": "0",
      "aspectRatio": "4:3",
      "autoplay": false,
      "vertical": false,
      "indicatorDots": false,
      "circular": false,
      "styles": {
        "width": "100%",
        "min-height": "150px"
      },
      "options": []
    });
    if (req.swiperList) {
      tfp.components.forEach(item => {
        if (item.id == 'topSwiper') {
          item.options = req.swiperList;
        }
      })
    }
  }
  if (req.have_appList == 'true') {
    tfp.components.push(
      {
        "type": "Panel",
        "id": "appListPanel",
        "styles": {
          "width": "100%",
          "height": "auto",
          "display": "flex",
          "flex-wrap": "wrap",
          "align-items": "center",
          "align-content": "flex-start",
          "justify-content": "flex-start",
          "flex-direction": "row"
        },
        "components": [

        ]
      });
    if (req.appList) {
      tfp.components.forEach(item => {
        if (item.id == 'appListPanel') {
          for (var x = 0; x < req.appList.length; x++) {
            item.components.push({
              "type": "OneAppModule",
              "id": "oneAppModule1" + (x + 1),
              "imageWidth": 48,
              "imageHeight": 48,
              "styles": {
                "background": "white",
                "width": "25%",
                "height": "100px",
                "cursor": "pointer"
              },
              "options": req.appList[x]
            });
          }
        }
      })
    }
  }
  if (req.have_tabbar == 'true') {
    tfp.components.push({
      "type": "Tabbar",
      "id": "tabbarList",
      "options": [],
      "selectednow": "0",
      "tabcolor": "#888888",
      "selectedColor": "#2AA144",
      "styles": {
        "width": "100%",
        "height": "48px",
        "position": "fixed",
        "z-index": "99",
        "left": "0",
        "bottom": "0",
        "right": "0",
        "display": "flex",
        "flex-direction": "row",
        "flex-wrap": "nowrap",
        "justify-content": "space-evenly",
        "align-items": "center",
		"background": "white",
      }
    });
    if (req.tabbarList) {
      tfp.components.forEach(item => {
        if (item.id == 'tabbarList') {
          item.options = req.tabbarList;
        }
      })
    }
  }

  // console.log(req.swiperList)
  // console.log(req.appList)
  // console.log(req.tabbarList)
  // console.log(tfp)
  // return

  if (req.pageType == "dialog") {
    tfp.width = req.dialogWidth + "";
    tfp.width = tfp.width.indexOf("px") > 0 ? tfp.width : tfp.width + "px";
    tfp.height = req.dialogHeight + "";
    tfp.height = tfp.height.indexOf("px") > 0 ? tfp.height : tfp.height + "px";
    tfp.components.push({
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "left": "0",
        "height": "50px",
        "right": "0",
        "bottom": "0",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [{
        id: "button_cancel",
        type: "Button",
        buttonType: "default",
        value: "取消",
        theme: "rect",
        onClick: "tfp.closeCurDialog()",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "20px",
          "cursor": "pointer",
          "text-align": "center"
        }
      }, {
        id: "button_submit",
        type: "Button",
        buttonType: "primary",
        value: "确定",
        theme: "rect",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "10px",
          "cursor": "pointer",
          "text-align": "center"
        },
        onClick: "form1.submit()"
      }]
    });
  }
  fs.writeFileSync(filePath, JSON.stringify(tfp, null, "  "));
  this.end(res);
};