var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var TBSCompiler = require('TBSCompiler');
var PackageManager = require('../proj/packageManager.js');

/**
 * 生成数据列表页面
 */
var CreateListPage = function() { 
  Service.call(this);
  this.sqlInject = {
    check: false   
  };
  this.pkManager = new PackageManager();
};

util.inherits(CreateListPage, Service);

module.exports = CreateListPage;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateListPage.prototype.process =  function(req, res) {
  if(!req.path) {
    this.onLogicError(1, '请提供应用路径！');
    return;
  }
  if(!req.name) {
    this.onLogicError(2, '请提供应用名称！');
    return;
  }
  if(!req.model) {
    this.onLogicError(3, '请提供主数据模型路径！');
    return;
  }
  if(!req.serviceSavePath) {
    this.onLogicError(3, '请提供后台服务保存路径！');
    return;
  }
  if(!req.pageSavePath) {
    this.onLogicError(3, '请提供前端页面保存路径！');
    return;
  }
  let modelName = "";
  let modelPath = "";
  if(req.model.indexOf("/")<0) {
    modelName = req.model;
    modelPath = "/app/"+req.proj+"/model/"+req.model+".tdm";
  } else {
    modelName = req.model.substr(req.model.lastIndexOf("/")+1);
    modelName = modelName.substr(0, modelName.lastIndexOf("."));
    modelPath = "/app/"+req.model;
  }
  var filePath = utils.getPath(req.path);
  let dir = filePath.substring(0, filePath.lastIndexOf("/"));
  if (!fs.existsSync(dir)) fs.mkdirSync(dir);
  if(fs.existsSync(filePath)) {
    this.onLogicError(6, '文件已存在！');
    return;
  }
  //加载数据模型
  let dataModel = server.loadModule(modelPath);
  let tgaName = req.path.substr(req.path.lastIndexOf("/")+1);
  tgaName = tgaName.substr(0, tgaName.lastIndexOf("."));
  tgaName = tgaName.substr(0, 1).toUpperCase()+tgaName.substr(1);
  var tga = {
    name: tgaName,
    mainModel: {
      name: modelName,
      path: modelPath
    },
    serviceSavePath: req.serviceSavePath,
    pageSavePath: req.pageSavePath,
    subModels: [],
    pages: []
  };

  if(req.comment) tga.comment = req.comment;

  //更新项目包信息
  var self = this;
  this.pkManager.setTGAInfo(req, req.path, tga, function() {
    fs.writeFileSync(filePath, JSON.stringify(tga, null, "\t"));
    self.end(res);
  });
};

CreateListPage.prototype.createNewPage = function(client, pageType, title, useLayout) {
    let pageModel = {
        "client": client,
        "framework": "tfp",
        "positionType": "float",
        "pageType": pageType,
        "title": title,
        "bgColorMode": "light",
        "type": "Page",
        "docType": "HTML5",
        "components": [],
        "styleSheets": [],
        "jsFuncs": [
          {
            "name": "page1_onLoad",
            "comment": "页面加载后",
            "editType": "gui",
            "args": [],
            "statements": []
          }
        ],
        "cptDataBindSetting": {},
        "styles": {
            "background-color": "#F0F0F0"
        },
        "id": "page1"
    };
    if(useLayout) {
        pageModel.components.push(
            {
                "id": "panelPage",
                "type": "Panel",
                "components": [],
                "styles": {
                    "left": "10px",
                    "top": "10px",
                    "right": "10px",
                    "bottom": "10px",
                    "position": "absolute",
                    "border-radius": " 6px 6px 6px 6px",
                    "border-color": "#CCCCCC",
                    "border-width": "0",
                    "box-shadow": " 3px 5px 5px #cccccc",
                    "min-width": "780px",
                    "overflow": "auto",
                    "background-color": "#FFFFFF"
                }
            }
        );
    } else {
        pageModel.components.push(
            {
                "type": "Layout",
                "id": "layout1",
                "topPanelHeight": 150,
                "topPanelShow": false,
                "topPanelToggle": false,
                "leftPanelWidth": 240,
                "leftPanelShow": true,
                "leftPanelToggle": true,
                "rightPanelWidth": 240,
                "rightPanelShow": false,
                "rightPanelToggle": false,
                "bottomPanelHeight": 150,
                "bottomPanelShow": false,
                "bottomPanelToggle": false,
                "styles": {
                    "position": "absolute",
                    "z-index": 1,
                    "left": "0",
                    "top": "0",
                    "right": "0",
                    "bottom": "0",
                    "background-color": "#efefef"
                },
                "components": [
                    {
                        "id": "layout1_top_panel",
                        "type": "Panel",
                        "isAttached": true,
                        "styles": {},
                        "components": []
                    },
                    {
                        "id": "layout1_left_panel",
                        "type": "Panel",
                        "isAttached": true,
                        "styles": {},
                        "components": []
                    },
                    {
                        "id": "layout1_main_panel",
                        "type": "Panel",
                        "isAttached": true,
                        "styles": {},
                        "components": []
                    },
                    {
                        "id": "layout1_right_panel",
                        "type": "Panel",
                        "isAttached": true,
                        "styles": {},
                        "components": []
                    },
                    {
                        "id": "layout1_bottom_panel",
                        "type": "Panel",
                        "isAttached": true,
                        "styles": {},
                        "components": []
                    }
                ]
            });
    }
    return pageModel;
}
