var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var TBSCompiler = require('TBSCompiler');
var PackageManager = require('../proj/packageManager.js');

/**
 * 创建生成式应用
 */
var CreateApp = function() { 
  Service.call(this);
  this.sqlInject = {
    check: false   
  };
  this.pkManager = new PackageManager();
};

util.inherits(CreateApp, Service);

module.exports = CreateApp;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateApp.prototype.process =  function(req, res) {
  if(!req.path) {
    this.onLogicError(1, '请提供应用路径！');
    return;
  }
  if(!req.name) {
    this.onLogicError(2, '请提供应用代码！');
    return;
  }
  if(!req.model) {
    this.onLogicError(3, '请提供主数据模型路径！');
    return;
  }
  if(!req.serviceSavePath) {
    this.onLogicError(3, '请提供后台服务保存路径！');
    return;
  }
  if(!req.pageSavePath) {
    this.onLogicError(3, '请提供前端页面保存路径！');
    return;
  }
  let modelName = "";
  let modelPath = "";
  if(req.model.indexOf("/")<0) {
    modelName = req.model;
    modelPath = "/app/"+req.proj+"/model/"+req.model+".tdm";
  } else {
    modelName = req.model.substr(req.model.lastIndexOf("/")+1);
    modelName = modelName.substr(0, modelName.lastIndexOf("."));
    modelPath = "/app/"+req.model;
  }
  var filePath = utils.getPath(req.path);
  let dir = filePath.substring(0, filePath.lastIndexOf("/"));
  if (!fs.existsSync(dir)) fs.mkdirSync(dir);
  if(fs.existsSync(filePath)) {
    this.onLogicError(6, '文件已存在！');
    return;
  }
  var self = this;
  this.createDir(req.serviceSavePath, function(err) {
    if(err) {
      self.end(res);
      return;
    }
    self.createDir(req.pageSavePath, function(err) {
      if(err) {
        self.end(res);
        return;
      }
      self.createTgaFile(req, res, modelName, modelPath, filePath);
    });
  });
};

CreateApp.prototype.createTgaFile = function (req, res, modelName, modelPath, filePath) {
  let tgaName = req.path.substr(req.path.lastIndexOf("/")+1);
  tgaName = tgaName.substr(0, tgaName.lastIndexOf("."));
  tgaName = tgaName.substr(0, 1).toUpperCase()+tgaName.substr(1);
  var tga = {
    name: tgaName,
    mainModel: {
      name: modelName,
      path: modelPath
    },
    serviceSavePath: req.serviceSavePath,
    pageSavePath: req.pageSavePath,
    subModels: [],
    pageSettings: []
  };

  if(req.comment) tga.comment = req.comment;

  //更新项目包信息
  var self = this;
  this.pkManager.setTGAInfo(req, req.path, tga, function() {
    fs.writeFileSync(filePath, JSON.stringify(tga, null, "\t"));
    self.end(res);
  });
};

CreateApp.prototype.createDir = function (dirPath, cb) {
  let arrDir = dirPath.split("/");
  try {
    let dir = utils.getPath("/");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      dir += "/" + arrDir[i];
      if (!fs.existsSync(dir)) fs.mkdirSync(dir);
    }
    cb();
  } catch (err) {
    logger.log(err);
    cb(err);
  }
};