var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var TBSCompiler = require('TBSCompiler');
var PackageManager = require('../proj/packageManager.js');

/**
 * 克隆生成式应用
 */
var CloneApp = function () {
    Service.call(this);
    this.sqlInject = {
        check: false
    };
    this.pkManager = new PackageManager();
};

util.inherits(CloneApp, Service);

module.exports = CloneApp;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CloneApp.prototype.process = function (req, res) {
    if (!req.srcPath) {
        this.onLogicError(1, '请提供原应用的路径！');
        return;
    }
    if (!req.desPath) {
        this.onLogicError(1, '请提供克隆后的应用的路径！');
        return;
    }
    if (!req.code) {
        this.onLogicError(2, '请提供应用代码！');
        return;
    }
    if (!req.model) {
        this.onLogicError(3, '请提供主数据模型路径！');
        return;
    }
    if (!req.serviceSavePath) {
        this.onLogicError(3, '请提供后台服务保存路径！');
        return;
    }
    if (!req.pageSavePath) {
        this.onLogicError(3, '请提供前端页面保存路径！');
        return;
    }
    let modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    modelName = modelName.substr(0, modelName.lastIndexOf("."));
    let modelPath = req.model;
    var srcFilePath = utils.getPath(req.srcPath);
    if (!fs.existsSync(srcFilePath)) {
        this.onLogicError(6, '原应用文件不存在！');
        return;
    }
    var desFilePath = utils.getPath(req.desPath + "/" + req.code + ".tga");
    if (fs.existsSync(desFilePath)) {
        this.onLogicError(6, '克隆应用文件已存在！');
        return;
    }
    var self = this;
    this.createDir(req.desPath, function (err) {
        if (err) {
            self.end(res);
            return;
        }
        self.createDir(req.serviceSavePath, function (err) {
            if (err) {
                self.end(res);
                return;
            }
            self.createDir(req.pageSavePath, function (err) {
                if (err) {
                    self.end(res);
                    return;
                }
                self.cloneTgaFile(req, res, modelName, modelPath, srcFilePath, desFilePath);
            });
        });
    });
};

CloneApp.prototype.cloneTgaFile = function (req, res, modelName, modelPath, srcFilePath, desFilePath) {
    //更新项目包信息
    var self = this;
    fs.readFile(srcFilePath, "utf-8", function (err1, data) {
        if(err1) {
            logger.log(err1);
            self.end(res);
            return;
        }
        let tga = JSON.parse(data);
        tga.name = req.code.substr(0, 1).toUpperCase() + req.code.substr(1);
        tga.mainModel.name = modelName;
        tga.mainModel.path = modelPath;
        tga.serviceSavePath = req.serviceSavePath;
        tga.pageSavePath = req.pageSavePath;
        tga.comment = req.comment;
        self.pkManager.setTGAInfo(req, req.desPath+"/"+req.code+".tga", tga, function () {
            fs.writeFile(desFilePath, JSON.stringify(tga, null, "\t"), function(err2) {
                if(err2) {
                    logger.log(err2);
                    self.end(res);
                    return;
                }
                self.end(res);
            });
        });
    });
};

CloneApp.prototype.createDir = function (dirPath, cb) {
    let arrDir = dirPath.split("/");
    try {
        let dir = utils.getPath("/");
        for (let i = 0; i < arrDir.length; i++) {
            if (arrDir[i] == "") continue;
            if(!dir.endsWith("/")) dir += "/";
            dir += arrDir[i];
            if (!fs.existsSync(dir)) fs.mkdirSync(dir);
        }
        cb();
    } catch (err) {
        logger.log(err);
        cb(err);
    }
};