var util = require('util');
var Service = require('Service');
var TFPHandler = require('TFPHandler');

/**
 * 获得TFP页面的HTML代码
 */
var GetHtml = function () {
  Service.call(this);
};

util.inherits(GetHtml, Service);

module.exports = GetHtml;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetHtml.prototype.process = function (req, res) {
  if (!req.pagePath) {
    this.onLogicError(1, "请提供TFP页面路径！");
    return;
  }
  if (!req.pageDataModel) {
    this.onLogicError(2, "请提供TFP页面数据模型！");
    return;
  }
  let self = this;
  let options = {
    urlPath: req.pagePath,
    pageDataModel: req.pageDataModel,
    createFile: false
  };
  let tfpHandler = new TFPHandler();
  tfpHandler.compileTfp(options, function (err, html) {
    if (err) {
      logger.log(err);
      self.onLogicError(500, '编译TFP文件失败。');
      return;
    }
    res.html = html;
    self.end(res);
  });
}