var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 创建用戶組件
 */
var CreateTUC = function () {
    Service.call(this);
};

util.inherits(CreateTUC, Service);

module.exports = CreateTUC;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateTUC.prototype.process = function (req, res) {
    if (!req.path) {
        this.onLogicError(1, "请提供路径！");
        return;
    }
    if (!req.filename) {
        this.onLogicError(2, "请提供文件名称！");
        return;
    }
    if (req.filename.match(/[^\w]/g)) {
        this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
        return;
    }
    if (!req.client) {
        this.onLogicError(5, "请提供客户端类型！");
        return;
    }
    let positionType = "float";
    if (req.positionType) positionType = req.positionType;
    let bgColorMode = "light";
    if (req.bgColorMode == "dark") bgColorMode = "dark";

    let fileName = req.filename.endWith(".tuc") ? req.filename : req.filename + ".tuc";
    let filePath = utils.getPath(req.path + "/" + fileName);
    if (fs.existsSync(filePath)) {
        this.onLogicError(11, "文件已存在！");
        return;
    }
    let mobileType = "H5";
    if (req.client == "taskmsg") {
        mobileType = "TaskMsg";
        req.client = "phone";
    } else if (req.client == "dingding") {
        mobileType = "dingding";
        req.client = "phone";
    } else if (req.client == "workweixin") {
        mobileType = "workweixin";
        req.client = "phone";
    }

    var tuc = {
        client: req.client,
        mobileType: mobileType,
        framework: "tfp",
        positionType: positionType,
        bgColorMode: bgColorMode,
        pageType: "component",
        type: "Page",
        docType: "HTML5",
        id: "component1",
        components: []
    };

    if (tuc.bgColorMode == "dark") {
        tuc.styles = {
            "background-color": "#222222"
        };
    }

    fs.writeFileSync(filePath, JSON.stringify(tuc, null, "  "));

    this.end(res);
};