var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');

/**
 * 创建空白TFP文件
 */
var CreateNullTFP = function () {
  Service.call(this);
};

util.inherits(CreateNullTFP, Service);

module.exports = CreateNullTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateNullTFP.prototype.process = function (req, res) {
  if (!req.path) {
    this.onLogicError(1, "请提供路径！");
    return;
  }
  if (!req.filename) {
    this.onLogicError(2, "请提供文件名称！");
    return;
  }
  if (req.filename.match(/[^\w]/g)) {
    this.onLogicError(3, "文件名称只能包含字母、数字或下划线！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  let pageType = "page";
  if (req.pageType == "dialog") pageType = "dialog";
  if (req.pageType == "dialog") {
    if (!req.dialogWidth) {
      this.onLogicError(9, "请提供窗口宽度！");
      return;
    }
    req.dialogWidth += "";
    if (!req.dialogHeight) {
      this.onLogicError(10, "请提供窗口高度！");
      return;
    }
    req.dialogHeight += "";
  }
  let positionType = "float";
  if (req.positionType) positionType = req.positionType;
  let bgColorMode = "light";
  if (req.bgColorMode == "dark") bgColorMode = "dark";

  let fileName = req.filename.endWith(".tfp") ? req.filename : req.filename + ".tfp";
  let filePath = utils.getPath(req.path + "/" + fileName);
  if (fs.existsSync(filePath)) {
    this.onLogicError(11, "文件已存在！");
    return;
  }
  let mobileType = "H5";
  if (req.client == "taskmsg") {
    mobileType = "TaskMsg";
    req.client = "phone";
  } else if (req.client == "dingding") {
    mobileType = "dingding";
    req.client = "phone";
  } else if (req.client == "workweixin") {
    mobileType = "workweixin";
    req.client = "phone";
  }

  var tfp = {
    client: req.client,
    mobileType: mobileType,
    framework: "tfp",
    positionType: positionType,
    pageType: pageType,
    bgColorMode: bgColorMode,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: []
  };

  if (req.createBgPanel && req.pageType != "dialog") {
    tfp.components.push({
      id: "panel_page",
      type: "Panel",
      components: [],
      styles: {
        "left": "10px",
        "top": "10px",
        "right": "10px",
        "bottom": "10px",
        "position": "absolute",
        "border-radius": " 6px 6px 6px 6px",
        "border": "1px solid #eee",
        "box-shadow": " 3px 5px 5px #cccccc",
        "overflow": "auto",
        "background-color": "#FFFFFF"
      }
    });
    if (tfp.bgColorMode != "dark") {
      tfp.styles = {
        "background-color": "#f0f0f0"
      };
    }
  }

  if (tfp.bgColorMode == "dark") {
    tfp.styles = {
      "background-color": "#222222"
    };
  }
  if (req.pageType == "dialog") {
    tfp.width = req.dialogWidth + "";
    tfp.width = tfp.width.indexOf("px") > 0 ? tfp.width : tfp.width + "px";
    tfp.height = req.dialogHeight + "";
    tfp.height = tfp.height.indexOf("px") > 0 ? tfp.height : tfp.height + "px";
    tfp.components.push({
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "left": "0",
        "height": "50px",
        "right": "0",
        "bottom": "0",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [{
        id: "button_cancel",
        type: "Button",
        buttonType: "default",
        value: "取消",
        theme: "rect",
        onClick: "tfp.closeCurDialog()",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "20px",
          "cursor": "pointer",
          "text-align": "center"
        }
      }, {
        id: "button_submit",
        type: "Button",
        buttonType: "primary",
        value: "确定",
        theme: "rect",
        styles: {
          "float": "right",
          "margin-top": "10px",
          "margin-right": "10px",
          "cursor": "pointer",
          "text-align": "center"
        },
        onClick: "form1.submit()"
      }]
    });
  }
  fs.writeFileSync(filePath, JSON.stringify(tfp, null, "  "));

  this.end(res);
};