var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TBSCompiler = require('TBSCompiler');

/**
 * 添加数据查询页面
 */
var CreateDataQueryTFP = function () {
  Service.call(this);
  this.sqlInject = { check: false };
};

util.inherits(CreateDataQueryTFP, Service);

module.exports = CreateDataQueryTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataQueryTFP.prototype.process = function (req, res) {
  if (!req.proj) {
    this.onLogicError(1, "请提供项目名称！");
    return;
  }
  if (!req.path) {
    this.onLogicError(2, "请提供保存路径！");
    return;
  }
  req.path = req.path.endWith(".tfp") ? req.path : req.path + ".tfp";
  let fileName = req.path.substr(req.path.lastIndexOf("/") + 1);
  if (!fileName) {
    this.onLogicError(3, "请提供文件名称！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.positionType) {
    this.onLogicError(8, "请提供定位方式！");
    return;
  }
  if (!req.bgColorMode) {
    this.onLogicError(8, "请提供背景颜色！");
    return;
  }
  if (!req.model) {
    this.onLogicError(11, "请提供数据模型名称！");
    return;
  }

  req.modelName = "";
  req.modelPath = "";
  if (req.model.indexOf("/") < 0) {
    req.modelName = req.model;
    req.modelPath = "/app/" + req.proj + "/model/" + req.model + ".tdm";
  } else {
    req.modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    req.modelName = req.modelName.substr(0, req.modelName.lastIndexOf("."));
    req.modelPath = "/app/" + req.model;
  }

  if (!req.fields || req.fields.length == 0) {
    this.onLogicError(12, "请提供要添加的字段信息！");
    return;
  }
  let filePath = utils.getPath(req.path);
  if (fs.existsSync(filePath)) {
    this.onLogicError(14, "TFP文件已存在！");
    return;
  }
  let mobileType = "H5";
  if (req.client == "taskmsg") {
    mobileType = "TaskMsg";
  } else if (req.client == "dingding") {
    mobileType = "dingding";
  } else if (req.client == "workweixin") {
    mobileType = "workweixin";
  }
  req.client = "phone";
  req.pageType = "page";

  let tbsPath = req.path.substring(("/web/app/"+req.proj+"/").length);
  if (tbsPath.indexOf("/") < 0) {
    tbsPath = req.proj+"/service";
  } else {
    tbsPath = req.proj+"/service/"+tbsPath.substring(0, tbsPath.lastIndexOf("/"));
  }

  let fileNameMini = fileName.substring(0, fileName.lastIndexOf("."));

  req.queryServiceExists = false;
  let queryServicePath = "";
  let queryServiceType = ".tbs";
  let queryServiceFilePath = "";
  if (req.createQueryService) {
    queryServicePath = tbsPath + "/" + fileNameMini + "_grid1_query.tbs";
    req.queryServicePath = queryServicePath;
  } else {
    if (!req.queryServicePath) {
      this.onLogicError(15, "请提供查询数据的服务路径！");
      return;
    }
    queryServicePath = req.queryServicePath;
  }
  queryServiceFilePath = utils.getPath("/app/" + queryServicePath);
  if (fs.existsSync(queryServiceFilePath)) {
    req.queryServiceExists = true;
    //this.onLogicError(16, "查询数据的服务已存在！");
    //return;
  }

  var pageDM = {
    client: "phone",
    mobileType: mobileType,
    framework: "tfp",
    positionType: req.positionType,
    bgColorMode: req.bgColorMode,
    pageType: req.pageType,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: [{
      "type": "Grid",
      "id": "grid1",
      "showSearchBox": true,
      "allowPaging": true,
      "dataBindingKey": "",
      "styles": {
        "position": "absolute",
        "left": 0,
        "top": 0,
        "right": 0,
        "bottom": 0,
        "width": "100%"
      },
      "components": [
        {
          "id": "grid1_DataRow",
          "type": "GridDataRow",
          "styles": {
            "position": "absolute",
            "top": "0",
            "left": "10px",
            "right": "10px",
            "height": req.gridColumns.length * 40 + "px",
            "border": "1px solid #cccccc",
            "border-radius": "10px"
          },
          components: []
        }
      ],
      "dataQuerySetting": {
        "requestMode": req.createQueryService ? "model" : "service",
        "requestArgs": [],
        "dataMember": req.dataBindingMember ? req.dataBindingMember : "data",
        "servicePath": queryServicePath
      }
    },
      /*{
        id: "serviceGetList",
        type: "Service",
        path: queryServicePath,
        autoShowError: true,
        argSettings: []
      }*/
    ],
    jsFuncs: [],
    cptDataBindSetting: {
      grid1: {}
    }
  };

  if (pageDM.bgColorMode == "light") {
    pageDM.styles = {
      "background-color": "#FFFFFF"
    };
  } else {
    pageDM.styles = {
      "background-color": "#333333"
    };
  }

  if (req.createQueryService) {
    let dataQuerySetting = {
      "requestMode": "model",
      "modelPath": req.modelPath.substring(("/app/").length),
      "fields": req.fields,
      "type": "query",
      "orderByGridId": "grid1",
      "enableDataPage": true,
      "serviceName": "grid1_query",
      "servicePath": queryServicePath,
      "conditions": []
    };
    if (req.orderConditions) dataQuerySetting.orders = req.orderConditions;
    if (req.pageSize) dataQuerySetting.pageSize = parseInt(req.pageSize);
    if (req.count) dataQuerySetting.count = parseInt(req.count);
    if (req.distinct) dataQuerySetting.distinct = true;
    if (req.where) dataQuerySetting.where = req.where;
    if (req.enableDataPage) dataQuerySetting.enableDataPage = true;
    pageDM.cptDataBindSetting.grid1.dataQuerySetting = dataQuerySetting;
  }

  var dbQuery = {
    category: "db",
    type: "query",
    model: {
      name: req.modelName,
      path: req.modelPath
    },
    fields: req.fields,
    where: "",
    cbArg: "rows",
    queryArgs: [],
    statements: [{
      category: "common",
      type: "assign",
      varName: "res.data",
      operator: "=",
      value: "rows"
    }, {
      category: "common",
      type: "end"
    }]
  };
  if (req.orderConditions) dbQuery.orders = req.orderConditions;
  if (req.pageSize) dbQuery.pageSize = parseInt(req.pageSize);
  if (req.count) dbQuery.count = parseInt(req.count);
  if (req.distinct) dbQuery.distinct = true;
  if (req.where) dbQuery.where = req.where;
  var resArg = { name: "data", type: "array" };
  if (req.enableDataPage) {
    dbQuery.enableDataPage = true;
    resArg = { name: "data", type: "object" };
  }
  var reqArgs = [{
    name: "keyword",
    type: "string",
    comment: "关键字"
  }];

  var grid = pageDM.components[0];

  if (req.queryArgs && req.queryArgs.length > 0) {
    dbQuery.queryArgs = [];
    for (var i = 0; i < req.queryArgs.length; i++) {
      let queryArg = req.queryArgs[i];
      let qArg = {
        name: queryArg.name,
        comment: queryArg.comment,
        condition: queryArg.condition
      };
      dbQuery.queryArgs.push(qArg);
      grid.dataQuerySetting.requestArgs.push({
        "name": queryArg.name,
        "type": "ComponentVal",
        "value": queryArg.name
      });
    }
    if (req.createQueryService) pageDM.cptDataBindSetting.grid1.dataQuerySetting.conditions = dbQuery.queryArgs;
  }

  let cptMetaDatas = global.server.tfpLibFilesCache[req.client].metaDatas;

  if (req.operates && req.operates.indexOf("add") >= 0) {
    let addPageName = "add.tfp";
    if (req.addFileName) addPageName = req.addFileName;
    pageDM.components.push({
      id: "button_add",
      type: "Button",
      buttonType: "primary",
      theme: "rect",
      value: "添加",
      styles: {
        "position": "absolute",
        "top": "10px",
        "left": "20px",
        "width": "60px",
        "cursor": "pointer",
        "padding-left": "10px",
        "padding-right": "10px",
        "text-align": "center"
      },
      onClick: "tfp.gotoPage('" + addPageName + "')"
    });
    grid.styles.top = "50px";
  }

  let gridKeys = "";
  let detailFuncArgs = "";
  let detailUrlArgs = "";
  let updateFunc = {
    "name": "grid1_DataRow_onClick",
    "comment": "",
    "editType": "gui",
    "args": [],
    "statements": [
      {
        "category": "logic",
        "type": "comment",
        "message": "如果详情页面文件名不是detail.tfp，请修改！"
      },
      {
        "category": "basic",
        "type": "tfp.gotoPage",
        "url": "update.tfp?"
      }
    ]
  };
  for (var i = 0; i < req.dataKeys.length; i++) {
    let key = req.dataKeys[i];
    if (i > 0) {
      gridKeys += ",";
      detailFuncArgs += ",";
      detailUrlArgs += "&";
    }
    updateFunc.args.push(
      {
        "name": key.name,
        "type": "int",
        "required": true
      }
    );
    gridKeys += key.name;
    detailFuncArgs += "{" + key.name + "}";
    detailUrlArgs += key.name + "={" + key.name + "}";
    let isAddKey = false;
    for (var j = 0; j < dbQuery.fields.length; j++) {
      if (dbQuery.fields[j].name == key.name) {
        isAddKey = true;
        break;
      }
    }
    if (!isAddKey) dbQuery.fields.push({
      name: key.name,
      format: key.name
    });
  }
  grid.dataBindingKey = gridKeys;

  if (req.operates && req.operates.indexOf("update") >= 0) {
    let updateFileName = "update.tfp";
    if (req.updateFileName) updateFileName = req.updateFileName;
    updateFunc.statements[1].url = "'" + updateFileName + "?" + detailUrlArgs + "'";
    pageDM.jsFuncs.push(updateFunc);
    grid.components[0].onClick = "grid1_DataRow_onClick(" + detailFuncArgs + ")";
  }

  if (req.enableDataPage) {
    grid.allowPaging = true;
    if (req.pageSize) grid.pageSize = req.pageSize;
  }

  this.curCptTop = 10;
  for (var i = 0; i < req.gridColumns.length; i++) {
    let field = req.gridColumns[i];
    this.addRow(pageDM, cptMetaDatas, grid.components[0], field, i);
  }

  fs.writeFileSync(filePath, JSON.stringify(pageDM, null, "\t"));

  if (!req.createQueryService) {
    this.end(res);
    return;
  }

  var options = {
    reqArgs: reqArgs,
    resArg: resArg,
    dbQuery: dbQuery,
    queryServiceFilePath: queryServiceFilePath
  };

  this.createGetListService(req, res, options);
};

CreateDataQueryTFP.prototype.createServiceDir = function (req, res, servicePath, cb) {
  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
    cb();
  } catch (err) {
    logger.log(err);
    cb(err);
    return;
  }
};

CreateDataQueryTFP.prototype.createGetListService = function (req, res, options) {
  if (!req.createQueryService || req.queryServiceExists) {
    this.end(res);
    return;
  }
  var tbsQuery = {
    name: req.modelName + "_GetList",
    comment: "获得" + req.modelName + "列表",
    reqArgs: options.reqArgs,
    resArgs: [options.resArg],
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: []
    }]
  };
  if (options.dbQuery.queryArgs && options.dbQuery.queryArgs.length > 0) {
    for (let i = 0; i < options.dbQuery.queryArgs.length; i++) {
      let qArg = options.dbQuery.queryArgs[i];
      if (qArg.condition && (qArg.condition + "").indexOf(" like {%req.") > 0) {
        tbsQuery.methods[0].statements.push({
          "category": "common",
          "type": "assign",
          "operator": "=",
          "varName": "req." + qArg.name,
          "value": "req.keyword"
        });
      }
    }
  }
  tbsQuery.methods[0].statements.push(options.dbQuery);

  var self = this;
  this.createServiceDir(req, res, req.queryServicePath, function (err) {
    if (err) {
      self.onLogicError(16, "创建服务目录失败：" + err.message);
      return;
    }
    if (req.queryServiceType == ".js") {
      var compiler = new TBSCompiler();
      compiler.process({ tbs: tbsQuery }, { code: 0 }, function (res2) {
        if (res2.code != 0) {
          self.onLogicError(6, "TBS文件编译失败：" + res2.message);
          return;
        }
        fs.writeFileSync(options.queryServiceFilePath, res2.jsCode);
        self.end(res);
      });
    } else {
      fs.writeFileSync(options.queryServiceFilePath, JSON.stringify(tbsQuery, null, "\t"));
      self.end(res);
    }
  });
};

CreateDataQueryTFP.prototype.addRow = function (pageDM, cptMetaDatas, gridRowDM, field, index) {
  let labelWidth = "180px";
  let cptLabelDM = {
    id: "label_" + field.name,
    type: "Label",
    value: (field.comment ? field.comment : field.name) + "："
  };
  if (pageDM.positionType == "float") {
    cptLabelDM.styles = {
      "float": "left",
      "height": "30px",
      "line-height": "30px"
    };
  } else {
    cptLabelDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": "20px",
      "top": this.curCptTop + "px",
      "height": "30px",
      "line-height": "30px"
    };
  }
  //if(field.notnull) cptLabelDM.styles["color"] = "#FF0000";
  let cptType = cptMetaDatas["Text"];

  let cptDM = {
    id: field.name,
    type: "Text",
    comment: field.comment,
    dataBindingFormat: field.format,
    readonly: true
  };
  if (pageDM.positionType == "float") {
    cptDM.styles = {
      "float": "left",
      "border": "0",
      "text-align": "right",
      "background-color": "#FFFFFF"
    };
  } else {
    cptDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": labelWidth,
      "top": this.curCptTop + "px",
      "border": "0",
      "text-align": "right",
      "background-color": "#FFFFFF"
    };
  }
  if (cptType.defaultStyles) {
    for (styleName in cptType.defaultStyles) {
      cptDM.styles[styleName] = cptType.defaultStyles[styleName];
    }
  }
  if (field.width) {
    cptDM.styles.width = field.width + "";
    if (cptDM.styles.width.indexOf("px") < 0) cptDM.styles.width += "px";
  }

  let labelContainerDM = gridRowDM;
  let cptContainerDM = gridRowDM;
  if (pageDM.positionType == "float") {
    let flexDM = {
      "type": "FlexBox",
      "id": "flexBox" + index,
      "styles": {
        "display": "flex",
        "flex-direction": "row",
        "padding": "5px 20px 5px 20px"
      },
      "components": [
        {
          "id": "flexBox" + index + "_panel1",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": labelWidth,
            "height": "30px",
            "line-height": "30px"
          },
          "components": []
        },
        {
          "id": "flexBox" + index + "_panel2",
          "type": "Panel",
          "styles": {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          },
          "components": []
        }
      ]
    };
    labelContainerDM = flexDM.components[0];
    cptContainerDM = flexDM.components[1];
    gridRowDM.components.push(flexDM);
  } else {
    this.curCptTop += 40;
  }

  labelContainerDM.components.push(cptLabelDM);
  cptContainerDM.components.push(cptDM);
};