var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TBSCompiler = require('TBSCompiler');

/**
 * 添加数据查询页面
 */
var CreateDataQueryTFP = function () {
  Service.call(this);
  this.sqlInject = {
    check: false
  };
};

util.inherits(CreateDataQueryTFP, Service);

module.exports = CreateDataQueryTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataQueryTFP.prototype.process = function (req, res) {
  if (!req.proj) {
    this.onLogicError(1, "请提供项目名称！");
    return;
  }
  if (!req.path) {
    this.onLogicError(1, "请提供保存路径！");
    return;
  }
  req.path = req.path.endWith(".tfp") ? req.path : req.path + ".tfp";
  let fileName = req.path.substr(req.path.lastIndexOf("/") + 1);
  if (!fileName) {
    this.onLogicError(3, "请提供文件名称！");
    return;
  }
  if (!req.model) {
    this.onLogicError(11, "请提供数据模型名称！");
    return;
  }

  req.modelName = "";
  req.modelPath = "";
  if (req.model.indexOf("/") < 0) {
    req.modelName = req.model;
    req.modelPath = "/app/" + req.proj + "/model/" + req.model + ".tdm";
  } else {
    req.modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    req.modelName = req.modelName.substr(0, req.modelName.lastIndexOf("."));
    req.modelPath = "/app/" + req.model;
  }

  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.pageType) {
    this.onLogicError(7, "请提供页面类型！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  if (!req.positionType) {
    this.onLogicError(8, "请提供定位方式！");
    return;
  }
  // if(!req.bgColorMode) {
  //   this.onLogicError(8, "请提供背景颜色！");
  //   return;
  // }
  // if(req.pageType=="dialog") {
  //   if(!req.dialogWidth) {
  //     this.onLogicError(9, "请提供窗口宽度！");
  //     return;
  //   }
  //   req.dialogWidth += "";
  //   if(!req.dialogHeight) {
  //     this.onLogicError(10, "请提供窗口高度！");
  //     return;
  //   }
  //   req.dialogHeight += "";
  // }
  if (!req.fields || req.fields.length == 0) {
    this.onLogicError(12, "请提供要查询的字段信息！");
    return;
  }
  if (!req.gridColumns || req.gridColumns.length == 0) {
    this.onLogicError(12, "请提供要显示设置信息！");
    return;
  }

  let tfpFilePath = utils.getPath(req.path);
  if (fs.existsSync(tfpFilePath)) {
    this.onLogicError(14, "TFP文件已存在！");
    return;
  }

  req.queryServiceExists = false;
  let queryServicePath = "";
  let queryServiceType = ".tbs";
  let queryServiceFilePath = "";
  if (req.createQueryService) {
    if (!req.queryServicePath) {
      this.onLogicError(15, "请提供查询数据的服务路径！");
      return;
    }
    if (req.queryServiceType == ".js") queryServiceType = ".js";
    queryServicePath = req.queryServicePath + queryServiceType;
    queryServiceFilePath = utils.getPath("/app/" + queryServicePath);
    if (fs.existsSync(queryServiceFilePath)) {
      req.queryServiceExists = true;
      //this.onLogicError(16, "查询数据的服务已存在！");
      //return;
    }
  }

  req.deleteServiceExists = false;
  let deleteServicePath = "";
  let deleteServiceType = ".tbs";
  let deleteServiceFilePath = "";
  if (req.createDeleteService) {
    if (!req.deleteServicePath) {
      this.onLogicError(17, "请提供删除数据的服务路径！");
      return;
    }
    if (req.deleteServiceType == ".js") deleteServiceType = ".js";
    deleteServicePath = req.deleteServicePath + deleteServiceType;
    deleteServiceFilePath = utils.getPath("/app/" + deleteServicePath);
    if (fs.existsSync(deleteServiceFilePath)) {
      req.deleteServiceExists = true;
      //this.onLogicError(18, "删除数据的服务已存在！");
      //return;
    }
  }

  var pageDM = {
    client: req.client,
    framework: "wxfp",
    positionType: req.positionType,
    bgColorMode: req.bgColorMode,
    pageType: req.pageType,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: [{
      id: "panelPage",
      type: "Panel",
      components: [
        // {
        //   id: "label1",
        //   type: "Label",
        //   value: "查询条件",
        //   styles: {
        //     "width": "100%",
        //     "height": "50px",
        //   }
        // },
        {
          id: "panel1",
          type: "Panel",
          styles: {
            "width": "100%",
            "height": "50px",
          },
          components: [{
            id: "label1",
            type: "Label",
            value: "查询条件",
            styles: {
              "margin-left": "20px",
              "font-weight": "bold",
              "height": "50px",
              "line-height": "50px"
            }
          }]
        },
        {
          id: "panelQuery",
          type: "Panel",
          // styles: {
          //   "left": "20px",
          //   "top": "50px",
          //   "right": "20px",
          //   "height": "50px",
          //   "position": "absolute",
          //   "background-color": "#f0f0ff",
          //   "overflow": "auto",
          //   "display": "flex",
          //   "align-items": "center"
          // },
          components: []
        },
        // {
        //   id: "label2",
        //   type: "Label",
        //   value: "查询结果",
        //   styles: {
        //     "width": "100%",
        //     "height": "50px",
        //   }
        // },

        {
          id: "panel2",
          type: "Panel",
          styles: {
            "width": "100%",
            "height": "50px",
          },
          components: [{
            id: "label2",
            type: "Label",
            value: "查询结果",
            styles: {
              "margin-left": "20px",
              "font-weight": "bold",
              "height": "50px",
              "line-height": "50px"
            }
          }]
        },
        {
          "id": "grid1",
          "type": "Grid",
          "loadDataService": "serviceGetList",
          "dataBindingMember": "data",
          // "dataBindingKey": "id",
          "allowPaging": true,
          "styles": {
            "width": "100%",
            "height": "100%"
          },
          "components": [
            {
              "id": "grid1_DataRow",
              "type": "GridDataRow",
              "components": [

                {
                  "id": "grid1_panel1",
                  "type": "Panel",
                  "styles": {
                    "width": "100%",
                    "margin-bottom": "10px",
                    "background-color": "#ffffff"
                  },
                  "components": []
                }

              ]
            }
          ]
          // "columns": req.gridColumns
        }]
    },
    {
      id: "serviceGetList",
      type: "Service",
      path: queryServicePath,
      autoShowError: true,
      argSettings: []
    }],
    jsFuncs: []
  };

  var dbQuery = {
    category: "db",
    type: "query",
    model: {
      name: req.modelName,
      path: req.modelPath
    },
    fields: req.fields,
    where: "",
    cbArg: "rows",
    statements: [{
      category: "common",
      type: "assign",
      varName: "res.data",
      operator: "=",
      value: "rows"
    }, {
      category: "common",
      type: "end"
    }]
  };
  if (req.orderConditions) dbQuery.orders = req.orderConditions;
  if (req.pageSize) dbQuery.pageSize = parseInt(req.pageSize);
  if (req.count) dbQuery.count = parseInt(req.count);
  if (req.distinct) dbQuery.distinct = true;
  if (req.where) dbQuery.where = req.where;
  var resArg = { name: "data", type: "array" };
  if (req.enableDataPage) {
    dbQuery.enableDataPage = true;
    resArg = { name: "data", type: "object" };
  }
  var reqArgs = [];

  var labelQuery = pageDM.components[0].components[0];
  var panelQuery = pageDM.components[0].components[1];

  var labelGrid = pageDM.components[0].components[2];
  var grid = pageDM.components[0].components[3];
  var gridDM = pageDM.components[0].components[3].components[0].components[0];


  for (var i = 0; i < req.gridColumns.length; i++) {
    let column = req.gridColumns[i];
    this.addColumn(pageDM, gridDM, column, i);
  }

  if (req.queryArgs && req.queryArgs.length > 0) {
    dbQuery.queryArgs = [];
    for (var i = 0; i < req.queryArgs.length; i++) {
      let queryArg = req.queryArgs[i];
      dbQuery.queryArgs.push({
        name: queryArg.name,
        comment: queryArg.comment,
        condition: queryArg.condition
      });

      // panelQuery.components.push({
      //   id: "label_" + queryArg.name,
      //   type: "Label",
      //   value: queryArg.comment + "：",
      //   styles: {
      //     "display": "inline-block",
      //     "flex-grow": 0,
      //     "flex-shrink": 0,
      //     "flex-basis": "auto",
      //     "line-height": "30px",
      //     "margin-left": "10px"
      //   }
      // });


      let flexDM = {
        "type": "FlexBox",
        "id": "flexBox" + i,
        "styles": {
          "width": "100%"
        },
        "components": [
          {
            "id": "flexBox" + i + "_panel1",
            "type": "Panel",
            "styles": {
              "flex-basis": "30%"
            },
            "components": []
          },
          {
            "id": "flexBox" + i + "_panel2",
            "type": "Panel",
            "styles": {
              "flex-basis": "60%"
            },
            "components": []
          }
        ]
      };

      var labelContainerDM = flexDM.components[0];
      var cptContainerDM = flexDM.components[1];

      panelQuery.components.push(flexDM);

      let cptLabelDM = {
        id: "label_" + queryArg.name,
        type: "Label",
        value: queryArg.comment + "："
      };

      let ipt = {
        id: queryArg.name,
        type: queryArg.type,
        comment: queryArg.comment
      };

      // let ipt = {
      //   id: queryArg.name,
      //   type: queryArg.type,
      //   styles: {
      //     "display": "inline-block",
      //     "flex-grow": 0,
      //     "flex-shrink": 0,
      //     "flex-basis": "auto",
      //     "margin-left": "5px"
      //   }
      // };
      // if (queryArg.width) {
      //   ipt.styles.width = queryArg.width;
      // }

      // if (queryArg.type == "Text" || queryArg.type == "Select") {
      //   if (!ipt.styles.width) ipt.styles["width"] = "80px";
      //   ipt.styles["height"] = "24px";
      //   ipt.styles["padding-left"] = "2px";
      //   ipt.styles["padding-right"] = "2px";
      //   ipt.styles["background-color"] = "#FFFFFF";
      // }
      // else if (queryArg.type == "Switch") {
      //   ipt.styles["margin-top"] = "14px";
      // }

      if (queryArg.type == "Select" || queryArg.type == "Radio"
        || queryArg.type == "CheckBox" || queryArg.type == "Switch") {
        try {
          //console.log(queryArg.options);
          if (queryArg.options) {
            if (typeof (queryArg.options) == "string") {
              if (queryArg.type == "Switch") {
                ipt.options = queryArg.options.split(",");
              } else {
                if (queryArg.options.startWith("[") && queryArg.options.endWith("]")) {
                  ipt.options = JSON.parse(queryArg.options);
                } else {
                  let arrTmp = queryArg.options.split(",");
                  ipt.options = [];
                  for (var j = 0; j < arrTmp.length; j++) {
                    ipt.options.push({ value: arrTmp[j] });
                  }
                }
              }
            }
            else if (Array.isArray(queryArg.options)) {
              ipt.options = queryArg.options;
            }
          }
        }
        catch (e) {
          logger.log(e);
        }
      }
      if (queryArg.default) ipt.value = queryArg.default;
      // panelQuery.components.push(ipt);
      reqArgs.push({ name: queryArg.name, type: "string" });
      pageDM.components[1].argSettings.push({
        "name": queryArg.name,
        "type": "ComponentVal",
        "value": queryArg.name
      });

      labelContainerDM.components.push(cptLabelDM);
      cptContainerDM.components.push(ipt);
    }
  }

  if (req.queryArgs && req.queryArgs.length > 0) {

    pageDM.jsFuncs.push(
      {
        "name": "button_query_bindtap",
        "comment": "点击时",
        "editType": "code",
        "args": [
          {
            "name": "e"
          }
        ],
        "eventArgs": "",
        "code": "    this.tfp.get(\"grid1\").loadData(1);\n"
      }
    )

    panelQuery.components.push({
      id: "button_query",
      type: "Button",
      buttonType: "primary",
      value: "查询",
      sizeType: "mini",
      styles: {
        "margin": "6px"
      },
      bindtap: "button_query_bindtap"
    });
  }

  if (req.operates && req.operates.indexOf("add") >= 0) {
    // let addFileName = "add.tfp";
    // if (req.addFileName) addFileName = req.addFileName;
    // let addBtnOnClick = "tfp.gotoPage('" + addFileName + "')";
    // if (req.addFileType == "dialog") {
    //   if (addFileName.indexOf("/") < 0) {
    //     addFileName = req.path.substring(4, req.path.lastIndexOf("/") + 1) + addFileName;
    //   }
    //   addBtnOnClick = "tfp.openDialog('添加', '" + addFileName + "', '480px', '480px')";
    // }

    pageDM.jsFuncs.push(
      {
        "name": "button_add_bindtap",
        "comment": "点击时",
        "editType": "code",
        "args": [
          {
            "name": "e"
          }
        ],
        "eventArgs": "",
        "code": "    wx.navigateTo({\n        url: '../add/add'\n      });\n"
      }
    )

    panelQuery.components.push({
      id: "button_add",
      type: "Button",
      buttonType: "primary",
      value: "添加",
      sizeType: "mini",
      styles: {
        "margin": "6px"
      },
      bindtap: "button_add_bindtap"
    });
  }

  let gridKeys = "";
  let delReqArgs = [];
  let updateArgs = "";
  let deleteArgs = "";
  let delSmWhere = "";
  for (var i = 0; i < req.dataKeys.length; i++) {
    let key = req.dataKeys[i];
    if (i > 0) {
      gridKeys += ",";
      updateArgs += "&";
      deleteArgs += " , ";
      delSmWhere += " and ";
    }
    gridKeys += key.name;
    updateArgs += key.name + "={" + key.name + "}";
    delReqArgs.push({
      name: key.name,
      type: key.type,
      notNull: true
    });
    if (key.type == "int" || key.type == "numeric") {
      deleteArgs += "{" + key.name + "}";
      delSmWhere += key.name + "={req." + key.name + "}";
    } else {
      deleteArgs += "'{" + key.name + "}'";
      delSmWhere += key.name + "='{req." + key.name + "}'";
    }
    let isAddKey = false;
    for (var j = 0; j < dbQuery.fields.length; j++) {
      if (dbQuery.fields[j].name == key.name) {
        isAddKey = true;
        break;
      }
    }
    if (!isAddKey) dbQuery.fields.push({ name: key.name });
  }
  grid.dataBindingKey = gridKeys;
  if (req.operates && req.operates.indexOf("update") >= 0) {
    // let updateFileName = "update.tfp";
    // if (req.updateFileName) updateFileName = req.updateFileName;
    // let updateColOnClick = "tfp.gotoPage('" + updateFileName + "?" + updateArgs + "')";
    // if (req.updateFileType == "dialog") {
    //   if (updateFileName.indexOf("/") < 0) {
    //     updateFileName = req.path.substring(4, req.path.lastIndexOf("/") + 1) + updateFileName;
    //   }
    //   updateColOnClick = "tfp.openDialog('修改', '" + updateFileName + "?" + updateArgs + "', '480px', '480px')";
    // }
    // grid.columns.push({
    //   "align": "center",
    //   "color": "#000099",
    //   "format": "修改",
    //   "name": "修改",
    //   "onClick": updateColOnClick,
    //   "width": "50"
    // });

    pageDM.jsFuncs.push(
      {
        "name": "button_update_bindtap",
        "comment": "点击时",
        "editType": "code",
        "args": [
          {
            "name": "e"
          }
        ],
        "eventArgs": "",
        "code": "     var id = this.tfp.get(\"grid1\").getKey(e.currentTarget);\n     wx.navigateTo({\n        url: '../update/update?id=' + id\n      });\n"
      }
    )

    gridDM.components.push({
      id: "button_update",
      type: "Button",
      buttonType: "primary",
      value: "修改",
      sizeType: "mini",
      styles: {
        "margin": "6px"
      },
      bindtap: "button_update_bindtap"
    });
  }
  if (req.operates && req.operates.indexOf("delete") >= 0) {
    // grid.columns.push({
    //   "align": "center",
    //   "color": "#FF0000",
    //   "format": "删除",
    //   "name": "删除",
    //   "onClick": "grid1.deleteRow(" + deleteArgs + ")",
    //   "width": "50"
    // });

    pageDM.jsFuncs.push(
      {
        "name": "button_delete_bindtap",
        "comment": "点击时",
        "editType": "code",
        "args": [
          {
            "name": "e"
          }
        ],
        "eventArgs": "",
        "code": "     var id = this.tfp.get(\"grid1\").getKey(e.currentTarget);\n    this.tfp.get(\"grid1\").deleteRow(id);\n"
      }
    )

    gridDM.components.push({
      id: "button_delete",
      type: "Button",
      buttonType: "primary",
      value: "删除",
      sizeType: "mini",
      styles: {
        "margin": "6px"
      },
      bindtap: "button_delete_bindtap"
    });

    pageDM.components.push({
      id: "serviceDelete",
      type: "Service",
      autoShowError: true,
      path: deleteServicePath
    });
    grid.delDataService = "serviceDelete";
  }
  if (panelQuery.components.length == 0) {
    labelQuery.styles.display = "none";
    panelQuery.styles.display = "none";
    labelGrid.styles.top = "20px";
    grid.styles.top = "60px";
  }
  if (req.enableDataPage) {
    grid.allowPaging = true;
    if (req.pageSize) grid.pageSize = req.pageSize;
  }
  // if (req.pageType == "dialog") {
  //   pageDM.components[0].styles = {
  //     "left": "0",
  //     "top": "0",
  //     "right": "0",
  //     "bottom": "0",
  //     "position": "absolute",
  //     "overflow": "auto"
  //   };
  //   pageDM.width = req.dialogWidth.indexOf("px") > 0 ? req.dialogWidth : req.dialogWidth + "px";
  //   pageDM.height = req.dialogHeight.indexOf("px") > 0 ? req.dialogHeight : req.dialogHeight + "px";
  // }
  // else {
  //   pageDM.components[0].styles = {
  //     "left": "10px",
  //     "top": "10px",
  //     "right": "10px",
  //     "bottom": "10px",
  //     "position": "absolute",
  //     "border-radius": " 6px 6px 6px 6px",
  //     "border-color": "#CCCCCC",
  //     "border-width": "0",
  //     "box-shadow": " 3px 5px 5px #cccccc",
  //     "min-width": "780px",
  //     "overflow": "auto"
  //   };
  // }
  // if (pageDM.bgColorMode == "light") {
  //   pageDM.components[0].styles["background-color"] = "#FFFFFF";
  //   pageDM.styles = {
  //     "background-color": "#F0F0F0"
  //   };
  // } else {
  //   pageDM.components[0].styles["background-color"] = "#333333";
  //   pageDM.styles = {
  //     "background-color": "#222222"
  //   };
  // }

  fs.writeFileSync(tfpFilePath, JSON.stringify(pageDM, null, "\t"));

  if ((!req.createQueryService || req.queryServiceExists)
    && (!req.createDeleteService || req.deleteServiceExists)) {
    this.end(res);
    return;
  }

  let options = {
    modelName: req.modelName.substr(0, 1).toUpperCase() + req.modelName.substr(1),
    reqArgs: reqArgs,
    resArg: resArg,
    dbQuery: dbQuery,
    queryServiceFilePath: queryServiceFilePath,
    delReqArgs: delReqArgs,
    delSmWhere: delSmWhere,
    deleteServiceFilePath: deleteServiceFilePath
  };

  this.createQueryService(req, res, options);
};

CreateDataQueryTFP.prototype.createServiceDir = function (req, res, servicePath, cb) {
  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
    cb();
  } catch (err) {
    logger.log(err);
    cb(err);
    return;
  }
};

CreateDataQueryTFP.prototype.createQueryService = function (req, res, options) {
  if (!req.createQueryService || req.queryServiceExists) {
    this.createDeleteService(req, res, options);
    return;
  }
  var tbsQuery = {
    name: req.modelName + "_GetList",
    comment: "获得" + req.modelName + "列表",
    reqArgs: options.reqArgs,
    resArgs: [options.resArg],
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: []
    }]
  };
  tbsQuery.methods[0].statements.push(options.dbQuery);

  var self = this;
  this.createServiceDir(req, res, req.queryServicePath, function (err) {
    if (err) {
      self.onLogicError(16, "创建服务目录失败：" + err.message);
      return;
    }
    if (req.queryServiceType == ".js") {
      var compilerQuery = new TBSCompiler();
      compilerQuery.process({ tbs: tbsQuery }, { code: 0 }, function (res2) {
        if (res2.code != 0) {
          self.onLogicError(6, "TBS文件编译失败：" + res2.message);
          return;
        }
        fs.writeFileSync(options.queryServiceFilePath, res2.jsCode);
        self.createDeleteService(req, res, options);
      });
    } else {
      fs.writeFileSync(options.queryServiceFilePath, JSON.stringify(tbsQuery, null, "\t"));
      self.createDeleteService(req, res, options);
    }
  });
};

CreateDataQueryTFP.prototype.createDeleteService = function (req, res, options) {
  if (!req.createDeleteService || req.deleteServiceExists) {
    this.end(res);
    return;
  }
  var tbsDelete = {
    name: req.modelName + "_Delete",
    comment: "删除" + req.modelName,
    reqArgs: options.delReqArgs,
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [{
        category: "db",
        type: "delete",
        model: {
          name: req.modelName,
          path: req.modelPath
        },
        where: options.delSmWhere,
        statements: [{
          category: "common",
          type: "end"
        }]
      }]
    }]
  };

  var self = this;
  this.createServiceDir(req, res, req.deleteServicePath, function (err) {
    if (err) {
      self.onLogicError(16, "创建服务目录失败：" + err.message);
      return;
    }
    if (req.deleteServiceType == ".js") {
      var compilerDelete = new TBSCompiler();
      compilerDelete.process({ tbs: tbsDelete }, { code: 0 }, function (res3) {
        if (res3.code != 0) {
          self.onLogicError(6, "TBS文件编译失败：" + res3.message);
          return;
        }
        fs.writeFileSync(options.deleteServiceFilePath, res3.jsCode);
        self.end(res);
      });
    } else {
      fs.writeFileSync(options.deleteServiceFilePath, JSON.stringify(tbsDelete, null, "\t"));
      self.end(res);
    }
  });
};

CreateDataQueryTFP.prototype.addColumn = function (pageDM, gridDM, column, index) {
  let cptDM = {
    type: "Label",
    id: "grid_label_" + column.name,
    dataBindingFormat: column.format,
    styles: {
      "width": column.width ? column.width : "100%",
      "text-align": column.align ? column.align : "center",
      "padding-left": "5px",
      "padding-right": "5px",
      "height": "32px",
      "line-height": "32px"
    },
  }


  gridDM.components.push(cptDM);
  // {
  //   "type": "Label",
  //   "id": "label1",
  //   "value": "",
  //   "styles": {
  //     "width": "100%",
  //     "text-align": "left",
  //     "padding-left": "5px",
  //     "padding-right": "5px",
  //     "height": "32px",
  //     "line-height": "32px"
  //   },
  //   "dataBindingFormat": "{title}"
  // }


};