var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TBSCompiler = require('TBSCompiler');

/**
 * 添加数据详情页面
 */
var CreateDataDetailTFP = function () {
  Service.call(this);
  this.sqlInject = {check: false};
};

util.inherits(CreateDataDetailTFP, Service);

module.exports = CreateDataDetailTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataDetailTFP.prototype.process = function (req, res) {
  if (!req.proj) {
    this.onLogicError(1, "请提供项目名称！");
    return;
  }
  if (!req.path) {
    this.onLogicError(2, "请提供保存路径！");
    return;
  }
  req.path = req.path.endWith(".tfp") ? req.path : req.path + ".tfp";
  let fileName = req.path.substr(req.path.lastIndexOf("/") + 1);
  if (!fileName) {
    this.onLogicError(3, "请提供文件名称！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.positionType) {
    this.onLogicError(8, "请提供定位方式！");
    return;
  }
  if (!req.bgColorMode) {
    this.onLogicError(8, "请提供背景颜色！");
    return;
  }
  if (!req.model) {
    this.onLogicError(11, "请提供数据模型名称！");
    return;
  }

  req.modelName = "";
  req.modelPath = "";
  if (req.model.indexOf("/") < 0) {
    req.modelName = req.model;
    req.modelPath = "/app/" + req.proj + "/model/" + req.model + ".tdm";
  } else {
    req.modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    req.modelName = req.modelName.substr(0, req.modelName.lastIndexOf("."));
    req.modelPath = "/app/" + req.model;
  }

  if (!req.fields || req.fields.length == 0) {
    this.onLogicError(12, "请提供要添加的字段信息！");
    return;
  }
  let filePath = utils.getPath(req.path);
  if (fs.existsSync(filePath)) {
    this.onLogicError(14, "TFP文件已存在！");
    return;
  }
  let mobileType = "H5";
  if (req.client == "taskmsg") {
    mobileType = "TaskMsg";
  } else if (req.client == "dingding") {
    mobileType = "dingding";
  } else if (req.client == "workweixin") {
    mobileType = "workweixin";
  }
  req.client = "phone";
  req.pageType = "page";

  let tbsPath = req.path.substring(("/web/app/"+req.proj+"/").length);
  if (tbsPath.indexOf("/") < 0) {
    tbsPath = req.proj+"/service";
  } else {
    tbsPath = req.proj+"/service/"+tbsPath.substring(0, tbsPath.lastIndexOf("/"));
  }

  let fileNameMini = fileName.substring(0, fileName.lastIndexOf("."));

  req.getServiceExists = false;
  let getServicePath = "";
  let getServiceType = ".tbs";
  let getServiceFilePath = "";
  if (req.createGetService) {
    getServicePath = tbsPath + "/" + fileNameMini + "_form1_query.tbs";
    req.getServicePath = getServicePath;
  } else {
    if (!req.getServicePath) {
      this.onLogicError(15, "请提供查询数据的服务路径！");
      return;
    }
    getServicePath = req.getServicePath;
  }
  getServiceFilePath = utils.getPath("/app/" + getServicePath);
  if (fs.existsSync(getServiceFilePath)) {
    req.getServiceExists = true;
    //this.onLogicError(16, "查询数据的服务已存在！");
    //return;
  }

  var pageDM = {
    client: "phone",
    mobileType: mobileType,
    framework: "tfp",
    positionType: req.positionType,
    bgColorMode: req.bgColorMode,
    pageType: req.pageType,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: [{
      id: "form1",
      type: "Form",
      styles: {
        "left": "0",
        "top": "0",
        "right": "0",
        "bottom": "50px",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [],
      "dataQuerySetting": {
        "requestMode": req.createGetService ? "model" : "service",
        "requestArgs": [],
        "dataMember": req.dataBindingMember ? req.dataBindingMember : "data",
        "servicePath": getServicePath
      }
    }, {
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "left": "0",
        "height": "50px",
        "right": "0",
        "bottom": "0",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [{
        id: "button_cancel",
        type: "Button",
        buttonType: "default",
        value: "返回",
        theme: "rect",
        styles: {
          "float": "left",
          "margin-top": "10px",
          "margin-left": "calc(50% - 30px)",
          "cursor": "pointer",
          "text-align": "center"
        },
        onClick: "history.back()"
      }]
    }],
    jsFuncs: [],
    "cptDataBindSetting": {
      "form1": {}
    }
  };

  if(req.createGetService) {
    pageDM.cptDataBindSetting.form1.dataQuerySetting = {
      "requestMode": "model",
      "modelPath": req.modelPath.substring(("/app/").length),
      "fields": [],
      "where": "",
      "conditions": [],
      "type": "query",
      "queryOne": true,
      "serviceName": "form1_query",
      "servicePath": getServicePath
    };
  }

  if (pageDM.bgColorMode == "light") {
    pageDM.styles = {
      "background-color": "#FFFFFF"
    };
  } else {
    pageDM.styles = {
      "background-color": "#333333"
    };
  }

  var statementGet = {
    category: "db",
    type: "query",
    model: {
      name: req.modelName,
      path: req.modelPath
    },
    fields: [],
    count: 1,
    where: "",
    cbArg: "rows",
    statements: [{
      category: "common",
      type: "assign",
      varName: "res.data",
      operator: "=",
      value: "rows[0]"
    }, {
      category: "common",
      type: "end"
    }]
  };

  let cptMetaDatas = global.server.tfpLibFilesCache[req.client].metaDatas;
  let formDM = pageDM.components[0];

  this.curCptTop = 10;
  for (var i = 0; i < req.fields.length; i++) {
    let field = req.fields[i];
    this.addRow(pageDM, cptMetaDatas, formDM, field, i);

    statementGet.fields.push({ name: field.name, comment: field.label });

    let reqArg = {
      name: field.name,
      comment: field.label,
      type: "string"
    };
    if (field.notnull) reqArg.notNull = true;
  }
  if(req.createGetService) pageDM.cptDataBindSetting.form1.dataQuerySetting.fields = statementGet.fields;

  let smWhere = "";
  let reqArgsGet = [];
  for (var i = 0; i < req.dataKeys.length; i++) {
    let key = req.dataKeys[i];
    formDM.dataQuerySetting.requestArgs.push({ name: key.name, type: "QueryString" });
    //pageDM.components[2].argSettings.push({ name: key.name, type: "QueryString" });
    reqArgsGet.push({ name: key.name, type: key.type, notNull: true });
    if (i > 0) smWhere += " and ";
    smWhere += key.name + "={req." + key.name + "}";
    let isAddKey = false;
    for (var j = 0; j < statementGet.fields.length; j++) {
      if (statementGet.fields[j].name == key.name) {
        isAddKey = true;
        break;
      }
    }
  }
  statementGet.where = smWhere;
  if(req.createGetService) pageDM.cptDataBindSetting.form1.dataQuerySetting.where = smWhere;

  fs.writeFileSync(filePath, JSON.stringify(pageDM, null, "\t"));

  if (!req.createGetService) {
    this.end(res);
    return;
  }

  var options = {
    reqArgsGet: reqArgsGet,
    statementGet: statementGet,
    getServiceFilePath: getServiceFilePath
  };

  this.createGetService(req, res, options);
};

CreateDataDetailTFP.prototype.createServiceDir = function (req, res, servicePath, cb) {
  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
    cb();
  } catch (err) {
    logger.log(err);
    cb(err);
    return;
  }
};

CreateDataDetailTFP.prototype.createGetService = function (req, res, options) {
  if (!req.createGetService || req.getServiceExists) {
    this.end(res);
    return;
  }
  var tbsGet = {
    name: req.modelName.substr(0, 1).toUpperCase() + req.modelName.substr(1) + "_Get",
    comment: "获得" + req.modelName,
    reqArgs: options.reqArgsGet,
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [options.statementGet]
    }]
  };

  var self = this;
  this.createServiceDir(req, res, req.getServicePath, function (err) {
    if (err) {
      self.onLogicError(16, "创建服务目录失败：" + err.message);
      return;
    }
    if (req.getServiceType == ".js") {
      var compiler = new TBSCompiler();
      compiler.process({ tbs: tbsGet }, { code: 0 }, function (res2) {
        if (res2.code != 0) {
          self.onLogicError(6, "TBS文件编译失败：" + res2.message);
          return;
        }
        fs.writeFileSync(options.getServiceFilePath, res2.jsCode);
        self.end(res);
      });
    } else {
      fs.writeFileSync(options.getServiceFilePath, JSON.stringify(tbsGet, null, "\t"));
      self.end(res);
    }
  });
};

CreateDataDetailTFP.prototype.addRow = function (pageDM, cptMetaDatas, formDM, field, index) {
  let labelWidth = "180px";
  let cptLabelDM = {
    id: "label_" + field.name,
    type: "Label",
    value: field.label + "："
  };
  let cptLabelRequired = {
    id: "label_" + field.name + "_required",
    type: "Label",
    value: "*",
    styles: {
      "color": "#FF0000",
      "height": "30px",
      "line-height": "30px"
    }
  };
  if (pageDM.positionType == "float") {
    cptLabelDM.styles = {
      "float": "left",
      "height": "30px",
      "line-height": "30px"
    };
    cptLabelRequired.styles["float"] = "left";
  } else {
    cptLabelDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": "30px",
      "top": this.curCptTop + "px",
      "height": "30px",
      "line-height": "30px"
    };
    cptLabelRequired.styles["position"] = "absolute";
    cptLabelRequired.styles["z-index"] = "1";
    cptLabelRequired.styles["left"] = "10px";
    cptLabelRequired.styles["top"] = this.curCptTop + "px";
  }
  //if(field.notnull) cptLabelDM.styles["color"] = "#FF0000";
  let cptType = cptMetaDatas[field.type];

  let cptDM = {
    id: field.name,
    type: field.type,
    comment: field.label,
    dataBindingFormat: field.format
  };
  if (field.type == "Text" || field.type == "textarea") {
    cptDM.readonly = true;
  }
  if (pageDM.positionType == "float") {
    cptDM.styles = {
      "float": "left"
    };
  } else {
    cptDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": labelWidth,
      "top": this.curCptTop + "px",
    };
  }
  if (field.notnull) {
    cptDM.required = true;
  }
  if (field.default) cptDM.value = field.default;
  if (cptType.defaultStyles) {
    for (styleName in cptType.defaultStyles) {
      cptDM.styles[styleName] = cptType.defaultStyles[styleName];
    }
  }
  if (field.width) {
    cptDM.styles.width = field.width + "";
    if (cptDM.styles.width.indexOf("px") < 0) cptDM.styles.width += "px";
  }

  let labelContainerDM = formDM;
  let cptContainerDM = formDM;
  if (pageDM.positionType == "float") {
    let flexDM = {
      "type": "FlexBox",
      "id": "flexBox" + index,
      "styles": {
        "display": "flex",
        "flex-direction": "row",
        "padding": "5px 20px 5px 20px"
      },
      "components": [
        {
          "id": "flexBox" + index + "_panel1",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": labelWidth,
            "height": "30px",
            "line-height": "30px"
          },
          "components": []
        },
        {
          "id": "flexBox" + index + "_panel2",
          "type": "Panel",
          "styles": {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          },
          "components": []
        }
      ]
    };
    labelContainerDM = flexDM.components[0];
    cptContainerDM = flexDM.components[1];
    if (cptDM.type == "TextArea" || cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      labelContainerDM.styles["height"] = cptType.defaultStyles.height;
      labelContainerDM.styles["line-height"] = cptType.defaultStyles.height;
    }
    formDM.components.push(flexDM);
  } else {
    if (cptDM.type == "TextArea") {
      let height = 120;
      if (field.height) {
        cptDM.styles.height = (field.height + "").indexOf("px") < 0 ? field.height + "px" : field.height;
        height = parseInt((cptDM.styles.height + "").replace("px", ""));
      } else if (cptType.defaultStyles.height) {
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      }
      this.curCptTop += height + 20;
    } else if (cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      let height = 220;
      if (field.height) {
        cptDM.styles.height = (field.height + "").indexOf("px") < 0 ? field.height + "px" : field.height;
        height = parseInt((cptDM.styles.height + "").replace("px", ""));
      } else if (cptType.defaultStyles.height) {
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      }
      this.curCptTop += height + 20;
    } else {
      this.curCptTop += 40;
    }
  }

  //如果当前页面为绝对定位，必填项提示放在输入项标签前面，因为无法很好的计算输入项标题组件的长度
  if (pageDM.positionType == "absolute" && field.notnull)
    labelContainerDM.components.push(cptLabelRequired);
  labelContainerDM.components.push(cptLabelDM);
  //如果当前页面为浮动定位，必填项提示放在输入项标签后面
  if (pageDM.positionType == "float" && field.notnull)
    labelContainerDM.components.push(cptLabelRequired);
  cptContainerDM.components.push(cptDM);
};