var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TBSCompiler = require('TBSCompiler');

/**
 * 添加数据修改页面
 */
var CreateDataDetailTFP = function () {
  Service.call(this);
  this.sqlInject = { check: false };
};

util.inherits(CreateDataDetailTFP, Service);

module.exports = CreateDataDetailTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataDetailTFP.prototype.process = function (req, res) {
  if (!req.proj) {
    this.onLogicError(1, "请提供项目名称！");
    return;
  }
  if (!req.path) {
    this.onLogicError(2, "请提供保存路径！");
    return;
  }
  req.path = req.path.endWith(".tfp") ? req.path : req.path + ".tfp";
  let fileName = req.path.substr(req.path.lastIndexOf("/") + 1);
  if (!fileName) {
    this.onLogicError(3, "请提供文件名称！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  if (!req.pageType) {
    this.onLogicError(7, "请提供页面类型！");
    return;
  }
  if (!req.positionType) {
    this.onLogicError(8, "请提供定位方式！");
    return;
  }
  if (!req.bgColorMode) {
    this.onLogicError(8, "请提供背景颜色！");
    return;
  }
  if (req.pageType == "dialog") {
    if (!req.dialogWidth) {
      this.onLogicError(9, "请提供窗口宽度！");
      return;
    }
    req.dialogWidth += "";
    if (!req.dialogHeight) {
      this.onLogicError(10, "请提供窗口高度！");
      return;
    }
    req.dialogHeight += "";
  }
  if (!req.model) {
    this.onLogicError(11, "请提供数据模型名称！");
    return;
  }

  this.labelPosition = req.labelPosition;

  req.modelName = "";
  req.modelPath = "";
  if (req.model.indexOf("/") < 0) {
    req.modelName = req.model;
    req.modelPath = "/app/" + req.proj + "/model/" + req.model + ".tdm";
  } else {
    req.modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    req.modelName = req.modelName.substr(0, req.modelName.lastIndexOf("."));
    req.modelPath = "/app/" + req.model;
  }

  if (!req.fields || req.fields.length == 0) {
    this.onLogicError(12, "请提供要查询的字段信息！");
    return;
  }
  let serviceExists = false;
  let filePath = utils.getPath(req.path);
  if (fs.existsSync(filePath)) {
    serviceExists = true;
    //this.onLogicError(14, "TFP文件已存在！");
    //return;
  }

  let tbsPath = req.path.substring(("/web/app/"+req.proj+"/").length);
  if (tbsPath.indexOf("/") < 0) {
    tbsPath = req.proj+"/service";
  } else {
    tbsPath = req.proj+"/service/"+tbsPath.substring(0, tbsPath.lastIndexOf("/"));
  }

  let fileNameMini = fileName.substring(0, fileName.lastIndexOf("."));

  let getServicePath = "";
  let getServiceType = ".tbs";
  let getServiceFilePath = "";
  if (req.createGetService) {
    if (req.getServicePath) {
      getServicePath = req.getServicePath.substring(0, req.getServicePath.lastIndexOf('/')) + "/" + fileNameMini + "_form1_query.tbs";
    } else {
      getServicePath = tbsPath + "/" + fileNameMini + "_form1_query.tbs";
      req.getServicePath = getServicePath;
    }
  } else {
    if (!req.getServicePath) {
      this.onLogicError(15, "请提供查询数据的服务路径！");
      return;
    }
    getServicePath = req.getServicePath;
  }
  getServiceFilePath = utils.getPath("/app/" + getServicePath);

  var pageDM = {
    client: req.client,
    framework: "tfp",
    positionType: req.positionType,
    pageType: req.pageType,
    bgColorMode: req.bgColorMode,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: [{
      id: "panel_page",
      type: "Panel",
      components: [{
        id: "form1",
        type: "Form",
        styles: {
          "left": "0",
          "top": "20px",
          "right": "0",
          "bottom": "20px",
          "position": "absolute",
          "overflow": "auto"
        },
        components: [],
        "dataQuerySetting": {
          "requestMode": req.createGetService ? "model" : "service",
          "requestArgs": [],
          "dataMember": req.dataBindingMember ? req.dataBindingMember : "data",
          "servicePath": getServicePath
        }
      }]
    }],
    "cptDataBindSetting": {
      "form1": {}
    }
  };
  if(req.createGetService) {
    pageDM.cptDataBindSetting.form1.dataQuerySetting = {
      "requestMode": "model",
      "modelPath": req.modelPath.substring(("/app/").length),
      "fields": [],
      "where": "",
      "conditions": [],
      "type": "query",
      "queryOne": true,
      "serviceName": "form1_query",
      "servicePath": getServicePath
    };
  }

  if (pageDM.pageType != "dialog" && pageDM.pageType != "drawer") {
    pageDM.components[0].styles = {
      "left": "10px",
      "top": "10px",
      "right": "10px",
      "bottom": "10px",
      "position": "absolute",
      "border-radius": " 6px 6px 6px 6px",
      "border": "1px solid #eee",
      "box-shadow": " 3px 5px 5px #cccccc",
      "overflow": "auto"
    };
  } else {
    pageDM.components[0].styles = {
      "left": "0",
      "top": "0",
      "right": "0",
      "bottom": "0",
      "position": "absolute",
      "overflow": "auto"
    };
    if(pageDM.pageType == "dialog") {
      pageDM.width = req.dialogWidth.indexOf("px") > 0 ? req.dialogWidth : req.dialogWidth + "px";
      pageDM.height = req.dialogHeight.indexOf("px") > 0 ? req.dialogHeight : req.dialogHeight + "px";
    }
    //对话框不显示标题栏
    //pageDM.components[0].components[0].styles["display"] = "none";
    pageDM.components[0].components[0].styles["top"] = "0";
  }
  if (pageDM.bgColorMode == "light") {
    pageDM.components[0].styles["background-color"] = "#FFFFFF";
    pageDM.styles = {
      "background-color": "#F0F0F0"
    };
  } else {
    pageDM.components[0].styles["background-color"] = "#333333";
    pageDM.styles = {
      "background-color": "#222222"
    };
  }

  var statementGet = {
    category: "db",
    type: "query",
    model: {
      name: req.modelName,
      path: req.modelPath
    },
    fields: [],
    count: 1,
    where: "",
    cbArg: "rows",
    statements: [{
      category: "common",
      type: "assign",
      varName: "res.data",
      operator: "=",
      value: "rows[0]"
    }, {
      category: "common",
      type: "end"
    }]
  };

  this.curCptTop = 60;
  let inputSizeInRow = 1;
  if (req.inputSizeInRow) inputSizeInRow = parseInt(req.inputSizeInRow);
  let cptMetaDatas = global.server.tfpLibFilesCache[req.client].metaDatas;
  let formDM = pageDM.components[0].components[0];
  let rowIndex = 0;
  let cellIndex = 0;
  let colIndex = 0;
  for (var i = 0; i < req.fields.length; i++) {
    let field = req.fields[i];
    //如果一行显示一个输入项，或者定位方式为绝对定位
    if (inputSizeInRow == 1 || pageDM.positionType == "absolute") {
      this.addRow(pageDM, cptMetaDatas, formDM, field, i);
    } else {  //如果是浮动定位，且一行多个输入项，则每行要先用一个弹性栅格作为容器
      let flexBasisOneCol = Number((100 / inputSizeInRow).toString().match(/^\d+(?:\.\d{0,2})?/));
      if (cellIndex % inputSizeInRow == 0) {
        colIndex = 0;
        let rowPanel = {
          "id": "flexBox_row_" + (rowIndex + 1),
          "type": "FlexBox",
          "styles": {
            "display": "flex",
            "width": "100%",
            "padding-left": "20px",
            "padding-right": "20px"
          },
          "components": []
        };
        for (let j = 0; j < inputSizeInRow; j++) {
          let cptPanel = {
            "id": "flexBox_row_" + (rowIndex + 1) + "_panel" + (j + 1),
            "type": "Panel",
            "styles": {
              "flex-grow": 0,
              "flex-shrink": 0,
              "height": "40px"
            },
            "components": []
          };
          if (req.labelPosition == "top") cptPanel.styles["height"] = "80px";
          cptPanel.styles["flex-basis"] = flexBasisOneCol + "%";
          rowPanel.components.push(cptPanel);
        }
        this.curRowPanel = rowPanel;
        formDM.components.push(rowPanel);
        rowIndex++;
      }
      let curCptPanel = this.curRowPanel.components[colIndex];
      //如果当前输入项占用多列
      if(field.colcount && field.colcount>1) {
        if(field.colcount>inputSizeInRow) field.colcount = inputSizeInRow;
        //如果剩下的列数小于当前输入项需要占用的列数，则需要另起一行
        if((inputSizeInRow-cellIndex % inputSizeInRow)<field.colcount) {
          cellIndex += inputSizeInRow - cellIndex % inputSizeInRow;
          console.log("另起一行,cellIndex:"+cellIndex);
          i--;
          colIndex = 0;
          continue;
        } else {
          curCptPanel.styles["flex-basis"] = (flexBasisOneCol * field.colcount) + "%";
          cellIndex += field.colcount - 1;
          for(let j=0;j<field.colcount - 1;j++) {
            this.curRowPanel.components.pop();
          }
        }
      }
      colIndex++;
      cellIndex++;
      this.addRow(pageDM, cptMetaDatas, curCptPanel, field, i);
    }

    let dbField = { name: field.name, comment: field.label };
    if(field.datadic) {
      let model = server.loadModule(req.modelPath);
      dbField.format = "(select name from sys_data_dic where code="+model.table
        +"."+field.name+" and type_code='"+field.datadic+"' limit 1 )";
      dbField.alias = field.name;
    }

    statementGet.fields.push(dbField);
  }
  if(req.createGetService) pageDM.cptDataBindSetting.form1.dataQuerySetting.fields = statementGet.fields;

  let smWhere = "";
  let reqArgsGet = [];
  for (var i = 0; i < req.dataKeys.length; i++) {
    let key = req.dataKeys[i];
    formDM.dataQuerySetting.requestArgs.push({ name: key.name, type: "QueryString" });
    //pageDM.components[1].argSettings.push({ name: key.name, type: "QueryString" });
    reqArgsGet.push({ name: key.name, type: key.type, notNull: true });
    if (i > 0) smWhere += " and ";
    smWhere += key.name + "={req." + key.name + "}";
    let isAddKey = false;
    for (var j = 0; j < statementGet.fields.length; j++) {
      if (statementGet.fields[j].name == key.name) {
        isAddKey = true;
        break;
      }
    }
    if (!isAddKey) {
      statementGet.fields.push({ name: key.name });
    }
  }
  statementGet.where = smWhere;
  if(req.createGetService) pageDM.cptDataBindSetting.form1.dataQuerySetting.where = smWhere;

  if (req.pageType == "dialog") {
    pageDM.width = req.dialogWidth.indexOf("px") > 0 ? req.dialogWidth : req.dialogWidth + "px";
    pageDM.height = req.dialogHeight.indexOf("px") > 0 ? req.dialogHeight : req.dialogHeight + "px";
    //pageDM.components[0].components[1].components[1].onClick = "closeCurDialog()";
  }

  fs.writeFileSync(filePath, JSON.stringify(pageDM, null, "  "));

  if (!req.createGetService) {
    this.end(res);
    return;
  }

  var options = {
    reqArgsGet: reqArgsGet,
    statementGet: statementGet,
    getServiceFilePath: getServiceFilePath
  };

  this.createGetService(req, res, options);
};

CreateDataDetailTFP.prototype.addRow = function (pageDM, cptMetaDatas, parentDM, field, index) {
  let cptLabelDM = {
    id: "label_" + field.name,
    type: "Label",
    value: field.label + "："
  };
  if (pageDM.positionType == "float") {
    cptLabelDM.styles = {
      "line-height": "30px",
      "color": "#666666",
      "width": "100%"
    };
  } else {
    cptLabelDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": "40px",
      "top": this.curCptTop + "px",
      "color": "#666666"
    };
  }
  let cptType = cptMetaDatas[field.type];

  let cptDM = {
    id: field.name,
    type: field.type,
    comment: field.label,
    styles: {},
    dataBindingFormat: field.format
  };
  if (field.type == "Text" || field.type == "textarea") {
    cptDM.readonly = true;
  }
  //设置组件默认样式
  if (cptType.defaultStyles) {
    for (styleName in cptType.defaultStyles) {
      cptDM.styles[styleName] = cptType.defaultStyles[styleName];
    }
  }
  if (pageDM.positionType == "float") {
    cptDM.styles.width = "100%";
  } else {
    cptDM.styles.position = "absolute";
    cptDM.styles["z-index"] = "1";
    cptDM.styles.left = labelWidth;
    cptDM.styles.top = this.curCptTop + "px";
  }
  if (field.default) cptDM.value = field.default;
  if (field.width) {
    cptDM.styles.width = field.width + "";
    if (cptDM.styles.width.indexOf("px") < 0 && cptDM.styles.width.indexOf("%") < 0) cptDM.styles.width += "px";
  } else if (cptDM.type == "User" || cptDM.type == "Dep" || cptDM.type == "Role") {
    cptDM.styles["height"] = "30px";
    cptDM.valueType = "obj";
  } else if (cptDM.type == "Date" || cptDM.type == "DateTime" || cptDM.type == "Time") {
    cptDM.styles["height"] = "30px";
  }
  if(cptDM.type=="Switch") delete cptDM.styles["width"];

  let labelContainerDM = parentDM;
  let cptContainerDM = parentDM;
  if (pageDM.positionType == "float") {
    let flexDM = {
      "type": "FlexBox",
      "id": "flexBox" + index,
      "styles": {
        "display": "flex",
        "width": "100%",
        "padding-left": "10px",
        "padding-right": "10px"
      },
      "components": [
        {
          "id": "flexBox" + index + "_panel1",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "40%",
            "height": "30px",
            "line-height": "30px",
            "margin-top": "5px",
            "margin-bottom": "5px"
          },
          "components": []
        },
        {
          "id": "flexBox" + index + "_panel2",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "60%",
            "height": "30px",
            "line-height": "30px",
            "margin-top": "5px",
            "margin-bottom": "5px"
          },
          "components": []
        }
      ]
    };
    labelContainerDM = flexDM.components[0];
    cptContainerDM = flexDM.components[1];
    if (this.labelPosition == "top") {
      flexDM.styles["flex-direction"] = "column";
      flexDM.components[0].styles["flex-basis"] = "30px";
      flexDM.components[1].styles["flex-grow"] = "0";
      flexDM.components[1].styles["flex-basis"] = "30px";
    } else {
      flexDM.components[0].styles["flex-basis"] = "100px";
      flexDM.components[1].styles["flex-grow"] = "1";
      flexDM.components[1].styles["flex-shrink"] = "1";
      flexDM.components[1].styles["flex-basis"] = "auto";
    }
    if (cptDM.type == "TextArea" || cptDM.type == "Pre") {
      let iptHeight = 200;
      if (cptDM.type == "TextArea") iptHeight = parseInt(cptType.defaultStyles.height.replace("px", ""));
      if (this.labelPosition == "top") {
        cptContainerDM.styles["flex-basis"] = iptHeight + "px";
      } else {
        cptContainerDM.styles["height"] = iptHeight + "px";
      }
      if (parentDM.type != "Form") {
        if (this.labelPosition == "top") {
          parentDM.styles["height"] = (iptHeight + 50) + "px";
        } else {
          parentDM.styles["height"] = (iptHeight + 10) + "px";
        }
      }
      //labelContainerDM.styles["line-height"] = cptType.defaultStyles.height;
    }
    parentDM.components.push(flexDM);
  } else {
    if (cptDM.type == "TextArea") {
      let height = 120;
      if (field.height) {
        cptDM.styles.height = (field.height + "").indexOf("px") < 0 ? field.height + "px" : field.height;
        height = parseInt((cptDM.styles.height + "").replace("px", ""));
      } else if (cptType.defaultStyles.height) {
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      }
      this.curCptTop += height + 20;
    } else if (cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      let height = 220;
      if (field.height) {
        cptDM.styles.height = (field.height + "").indexOf("px") < 0 ? field.height + "px" : field.height;
        height = parseInt((cptDM.styles.height + "").replace("px", ""));
      } else if (cptType.defaultStyles.height) {
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      }
      this.curCptTop += height + 20;
    } else {
      this.curCptTop += 40;
    }
  }

  labelContainerDM.components.push(cptLabelDM);
  cptContainerDM.components.push(cptDM);
};

CreateDataDetailTFP.prototype.createServiceDir = function (req, res, servicePath, cb) {
  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
    cb();
  } catch (err) {
    logger.log(err);
    cb(err);
    return;
  }
};

CreateDataDetailTFP.prototype.createGetService = function (req, res, options) {
  if (!req.createGetService) {
    this.end(res);
    return;
  }
  var tbsGet = {
    name: req.modelName.substr(0, 1).toUpperCase() + req.modelName.substr(1) + "_Get",
    comment: "获得" + req.modelName,
    reqArgs: options.reqArgsGet,
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [options.statementGet]
    }]
  };

  var self = this;
  this.createServiceDir(req, res, req.getServicePath, function (err) {
    if (err) {
      self.onLogicError(16, "创建服务目录失败：" + err.message);
      return;
    }
    if (req.getServiceType == ".js") {
      var compiler = new TBSCompiler();
      compiler.process({ tbs: tbsGet }, { code: 0 }, function (res2) {
        if (res2.code != 0) {
          self.onLogicError(6, "TBS文件编译失败：" + res2.message);
          return;
        }
        fs.writeFileSync(options.getServiceFilePath, res2.jsCode);
        self.end(res);
      });
    } else {
      fs.writeFileSync(options.getServiceFilePath, JSON.stringify(tbsGet, null, "\t"));
      self.end(res);
    }
  });
};