var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TBSCompiler = require('TBSCompiler');

/**
 * 添加数据添加页面
 */
var CreateDataAddTFP = function () {
  Service.call(this);
  this.sqlInject = {check: false};
};

util.inherits(CreateDataAddTFP, Service);

module.exports = CreateDataAddTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataAddTFP.prototype.process = function (req, res) {
  if (!req.proj) {
    this.onLogicError(1, "请提供项目名称！");
    return;
  }
  if (!req.path) {
    this.onLogicError(2, "请提供保存路径！");
    return;
  }
  req.path = req.path.endWith(".tfp") ? req.path : req.path + ".tfp";
  let fileName = req.path.substr(req.path.lastIndexOf("/") + 1);
  if (!fileName) {
    this.onLogicError(3, "请提供文件名称！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.positionType) {
    this.onLogicError(8, "请提供定位方式！");
    return;
  }
  if (!req.bgColorMode) {
    this.onLogicError(8, "请提供背景颜色！");
    return;
  }
  if (!req.model) {
    this.onLogicError(11, "请提供数据模型名称！");
    return;
  }

  req.modelName = "";
  req.modelPath = "";
  if (req.model.indexOf("/") < 0) {
    req.modelName = req.model;
    req.modelPath = "/app/" + req.proj + "/model/" + req.model + ".tdm";
  } else {
    req.modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    req.modelName = req.modelName.substr(0, req.modelName.lastIndexOf("."));
    req.modelPath = "/app/" + req.model;
  }

  if (!req.fields || req.fields.length == 0) {
    this.onLogicError(12, "请提供要添加的字段信息！");
    return;
  }
  let filePath = utils.getPath(req.path);
  if (fs.existsSync(filePath)) {
    this.onLogicError(14, "TFP文件已存在！");
    return;
  }
  let mobileType = "H5";
  if (req.client == "taskmsg") {
    mobileType = "TaskMsg";
  } else if (req.client == "dingding") {
    mobileType = "dingding";
  } else if (req.client == "workweixin") {
    mobileType = "workweixin";
  }
  req.client = "phone";
  req.pageType = "page";

  let tbsPath = req.path.substring(("/web/app/"+req.proj+"/").length);
  if (tbsPath.indexOf("/") < 0) {
    tbsPath = req.proj+"/service";
  } else {
    tbsPath = req.proj+"/service/"+tbsPath.substring(0, tbsPath.lastIndexOf("/"));
  }

  let fileNameMini = fileName.substring(0, fileName.lastIndexOf("."));

  let serviceFilePath = "";
  let servcieType = "tbs";
  let servicePath = "";
  let addServiceExists = false;
  if (req.createService) {
    servicePath = tbsPath + "/" + fileNameMini + "_form1_add.tbs";
    req.addServicePath = servicePath;
  } else {
    if (!req.addServicePath) {
      this.onLogicError(15, "请设置添加数据的服务路径！");
      return;
    }
    servicePath = req.addServicePath;
  }
  serviceFilePath = utils.getPath("/app/" + req.addServicePath);
  if (fs.existsSync(serviceFilePath)) {
    addServiceExists = true;
    //this.onLogicError(16, "服务文件已存在！");
    //return;
  }

  var pageDM = {
    client: "phone",
    mobileType: mobileType,
    framework: "tfp",
    positionType: req.positionType,
    bgColorMode: req.bgColorMode,
    pageType: req.pageType,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: [{
      id: "form1",
      type: "Form",
      //submitService: "serviceAdd",
      styles: {
        "left": "0",
        "top": "10px",
        "right": "0",
        "bottom": "50px",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [],
      "dataSubmitSetting": {
        "requestMode": req.createService ? "model" : "service",
        "requestArgs": [],
        "servicePath": servicePath
      },
      "onAfterSubmit": "form1_onAfterSubmit(req, res)"
    }, {
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "left": "0",
        "height": "50px",
        "right": "0",
        "bottom": "0",
        "position": "absolute",
        "overflow": "auto"
      },
      components: [{
        id: "button_submit",
        type: "Button",
        buttonType: "primary",
        value: "确定",
        theme: "rect",
        styles: {
          "float": "left",
          "margin-top": "10px",
          "margin-left": "calc(50% - 80px)",
          "cursor": "pointer",
          "text-align": "center"
        },
        onClick: "form1.submit()"
      }, {
        id: "button_cancel",
        type: "Button",
        buttonType: "default",
        value: "取消",
        theme: "rect",
        styles: {
          "float": "left",
          "margin-top": "10px",
          "margin-left": "10px",
          "cursor": "pointer",
          "text-align": "center"
        },
        onClick: "history.back()"
      }]
    }],
    jsFuncs: [
      {
        "name": "form1_onAfterSubmit",
        "comment": "服务响应时",
        "editType": "gui",
        "args": [
          {
            "name": "req",
            "type": "Object",
            "comment": "请求参数"
          },
          {
            "name": "res",
            "type": "Object",
            "comment": "响应参数"
          }
        ],
        "statements": [
          {
            "category": "common",
            "type": "comment",
            "message": "如果首页文件名不是index.tfp，请修改！"
          },
          {
            "category": "page",
            "type": "tfp.gotoPage",
            "url": "'index.tfp'"
          }
        ]
      }
    ],
    "cptDataBindSetting": {
      "form1": {}
    }
  };

  if(req.createService) {
    pageDM.cptDataBindSetting.form1.dataSubmitSetting = {
      "requestMode": "model",
      "modelPath": req.modelPath.substring(("/app/").length),
      "submitType": "add",
      "cptType": "Form",
      "fields": [],
      "uploaders": [],
      "type": "submit",
      "serviceName": "form1_add",
      "servicePath": servicePath
    };
  }

  if (pageDM.bgColorMode == "light") {
    pageDM.styles = {
      "background-color": "#FFFFFF"
    };
  } else {
    pageDM.styles = {
      "background-color": "#333333"
    };
  }

  var statement = {
    category: "db",
    type: "insert",
    model: {
      name: req.modelName,
      path: req.modelPath
    },
    fields: [],
    cbArg: "ret",
    statements: [{
      category: "common",
      type: "assign",
      varName: "res.id",
      operator: "=",
      value: "ret.insertId"
    }, {
      category: "common",
      type: "end"
    }]
  };

  var reqArgs = [];

  let cptMetaDatas = global.server.tfpLibFilesCache[req.client].metaDatas;
  let formDM = pageDM.components[0];

  this.curCptTop = 10;
  for (var i = 0; i < req.fields.length; i++) {
    let field = req.fields[i];
    this.addRow(pageDM, cptMetaDatas, formDM, field, i);

    statement.fields.push({
      name: field.name,
      comment: field.label,
      value: "req." + field.name
    });

    let reqArg = {
      name: field.name,
      comment: field.label,
      type: "string"
    };
    if (field.notnull) reqArg.notNull = true;
    reqArgs.push(reqArg);
  }

  if(req.createService) pageDM.cptDataBindSetting.form1.dataSubmitSetting.fields = statement.fields;

  fs.writeFileSync(filePath, JSON.stringify(pageDM, null, "\t"));

  if (!req.createService) {
    this.end(res);
    return;
  }

  var tbs = {
    name: req.modelName.substr(0, 1).toUpperCase() + req.modelName.substr(1) + "_Add",
    comment: "添加" + req.modelName,
    reqArgs: reqArgs,
    resArgs: [{ name: "id", type: "int" }],
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [statement]
    }]
  };

  res.servicePath = "/app/" + servicePath;
  res.servcieType = servcieType;

  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
  } catch (err) {
    logger.log(err);
    cb(err);
    return;
  }

  if (servcieType == "js") {
    var self = this;
    var compiler = new TBSCompiler();
    compiler.process({ tbs: tbs }, { code: 0 }, function (res2) {
      if (res2.code != 0) {
        self.onLogicError(6, "TBS文件编译失败：" + res2.message);
        return;
      }
      fs.writeFileSync(serviceFilePath, res2.jsCode);
      self.end(res);
    });
  } else {
    fs.writeFileSync(serviceFilePath, JSON.stringify(tbs, null, "\t"));
    this.end(res);
  }
};

CreateDataAddTFP.prototype.addRow = function (pageDM, cptMetaDatas, formDM, field, index) {
  let labelWidth = "180px";
  let cptLabelDM = {
    id: "label_" + field.name,
    type: "Label",
    value: field.label + "："
  };
  /*let cptLabelRequired = {
    id: "label_" + field.name + "_required",
    type: "Label",
    value: "*",
    styles: {
      "color": "#FF0000",
      "height": "30px",
      "line-height": "30px"
    }
  };*/
  if (pageDM.positionType == "float") {
    cptLabelDM.styles = {
      "float": "left",
      "height": "30px",
      "line-height": "30px"
    };
    //cptLabelRequired.styles["float"] = "left";
  } else {
    cptLabelDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": "40px",
      "top": this.curCptTop + "px",
      "height": "30px",
      "line-height": "30px"
    };
    //cptLabelRequired.styles["position"] = "absolute";
    //cptLabelRequired.styles["z-index"] = "1";
    //cptLabelRequired.styles["left"] = "20px";
    //cptLabelRequired.styles["top"] = this.curCptTop + "px";
  }
  //if(field.notnull) cptLabelDM.styles["color"] = "#FF0000";
  let cptType = cptMetaDatas[field.type];

  let cptDM = {
    id: field.name,
    type: field.type,
    comment: field.label
  };
  if (pageDM.positionType == "float") {
    cptDM.styles = {
      "float": "left"
    };
  } else {
    cptDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": labelWidth,
      "top": this.curCptTop + "px",
    };
  }
  if (field.notnull) {
    cptDM.required = true;
    cptLabelDM.attach = "asterisk-suffix";
  }
  if (field.default) cptDM.value = field.default;
  if (cptType.defaultStyles) {
    for (styleName in cptType.defaultStyles) {
      cptDM.styles[styleName] = cptType.defaultStyles[styleName];
    }
  }
  if (field.width) {
    cptDM.styles.width = field.width + "";
    if (cptDM.styles.width.indexOf("px") < 0) cptDM.styles.width += "px";
  }

  let labelContainerDM = formDM;
  let cptContainerDM = formDM;
  if (pageDM.positionType == "float") {
    let flexDM = {
      "type": "FlexBox",
      "id": "flexBox" + index,
      "styles": {
        "display": "flex",
        "flex-direction": "row",
        "padding": "5px 20px 5px 20px"
      },
      "components": [
        {
          "id": "flexBox" + index + "_panel1",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": labelWidth,
            "height": "30px",
            "line-height": "30px"
          },
          "components": []
        },
        {
          "id": "flexBox" + index + "_panel2",
          "type": "Panel",
          "styles": {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          },
          "components": []
        }
      ]
    };
    labelContainerDM = flexDM.components[0];
    cptContainerDM = flexDM.components[1];
    if (cptDM.type == "TextArea" || cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      labelContainerDM.styles["height"] = cptType.defaultStyles.height;
      labelContainerDM.styles["line-height"] = cptType.defaultStyles.height;
    }
    formDM.components.push(flexDM);
  } else {
    if (cptDM.type == "TextArea") {
      let height = 120;
      if (cptType.defaultStyles.height)
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      this.curCptTop += height + 20;
      //cptDM.styles["margin-top"] = "10px";
    } else if (cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      let height = 220;
      if (cptType.defaultStyles.height)
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      this.curCptTop += height + 20;
      //cptDM.styles["margin-top"] = "10px";
    } else if (cptDM.type == "Radio" || cptDM.type == "CheckBox") {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "9px";
    } else if (cptDM.type == "Switch") {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "10px";
    } else {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "8px";
    }
  }
  if (field.options && ["Radio", "CheckBox", "Select", "Switch"].contains(cptDM.type)) {
    cptDM.options = [];
    if (typeof (field.options) == "string") {
      if (field.options.startWith("[") && field.options.endWith("[")) {
        cptDM.options = JSON.parse(field.options);
      } else {
        let options = field.options.split(",");
        if (cptDM.type == "Switch") {
          cptDM.options = options;
        } else {
          for (var j = 0; j < options.length; j++) {
            cptDM.options.push({ value: options[j], text: options[j] });
          }
        }
      }
    } else if (Array.isArray(field.options)) {
      cptDM.options = field.options;
      /*for(var j=0;j<field.options.length;j++) {
        cptDM.options.push({value:field.options[j], text:field.options[j]});
      }*/
    }
  }
  if (cptDM.type == "Switch" && !cptDM.options) cptDM.options = [false, true];
  if (cptDM.type == "Select") cptDM.rootParentId = "0";
  if (["Date", "DateTime", "User", "Dep", "Role"].contains(cptDM.type)) {
    cptDM.showIcon = true;
  }
  if (["User", "Dep", "Role"].contains(cptDM.type)) {
    cptDM.valueType = "id";
  }

  //如果当前页面为绝对定位，必填项提示放在输入项标签前面，因为无法很好的计算输入项标题组件的长度
  //if (pageDM.positionType == "absolute" && field.notnull)
  //  labelContainerDM.components.push(cptLabelRequired);
  labelContainerDM.components.push(cptLabelDM);
  //如果当前页面为浮动定位，必填项提示放在输入项标签后面
  //if (pageDM.positionType == "float" && field.notnull)
  //  labelContainerDM.components.push(cptLabelRequired);
  cptContainerDM.components.push(cptDM);
};