var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TBSCompiler = require('TBSCompiler');

/**
 * 添加数据添加页面
 */
var CreateDataAddTFP = function () {
  Service.call(this);
  this.sqlInject = {check: false};
};

util.inherits(CreateDataAddTFP, Service);

module.exports = CreateDataAddTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataAddTFP.prototype.process = function (req, res) {
  if (!req.proj) {
    this.onLogicError(1, "请提供项目名称！");
    return;
  }
  if (!req.path) {
    this.onLogicError(2, "请提供保存路径！");
    return;
  }
  req.path = req.path.endWith(".tfp") ? req.path : req.path + ".tfp";
  let fileName = req.path.substr(req.path.lastIndexOf("/") + 1);
  if (!fileName) {
    this.onLogicError(3, "请提供文件名称！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  if (!req.pageType) {
    this.onLogicError(7, "请提供页面类型！");
    return;
  }
  if (!req.positionType) {
    this.onLogicError(8, "请提供定位方式！");
    return;
  }
  // if(!req.bgColorMode) {
  //   this.onLogicError(8, "请提供背景颜色！");
  //   return;
  // }
  // if(req.pageType=="dialog") {
  //   if(!req.dialogWidth) {
  //     this.onLogicError(9, "请提供窗口宽度！");
  //     return;
  //   }
  //   req.dialogWidth += "";
  //   if(!req.dialogHeight) {
  //     this.onLogicError(10, "请提供窗口高度！");
  //     return;
  //   }
  //   req.dialogHeight += "";
  // }
  if (!req.model) {
    this.onLogicError(11, "请提供数据模型名称！");
    return;
  }

  req.modelName = "";
  req.modelPath = "";
  if (req.model.indexOf("/") < 0) {
    req.modelName = req.model;
    req.modelPath = "/app/" + req.proj + "/model/" + req.model + ".tdm";
  } else {
    req.modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    req.modelName = req.modelName.substr(0, req.modelName.lastIndexOf("."));
    req.modelPath = "/app/" + req.model;
  }

  if (!req.fields || req.fields.length == 0) {
    this.onLogicError(12, "请提供要添加的字段信息！");
    return;
  }
  let filePath = utils.getPath(req.path);
  if (fs.existsSync(filePath)) {
    this.onLogicError(14, "TFP文件已存在！");
    return;
  }
  let serviceFilePath = "";
  let servcieType = "tbs";
  let servicePath = "";
  if (req.addServicePath) {
    servicePath = req.addServicePath;
    if (servicePath.endsWith(".js")) servcieType = "js";
  }
  let addServiceExists = false;
  if (req.createService) {
    if (!req.addServicePath) {
      this.onLogicError(15, "请设置添加数据的服务路径！");
      return;
    }
    serviceFilePath = utils.getPath("/app/" + req.addServicePath);
    if (fs.existsSync(serviceFilePath)) {
      addServiceExists = true;
      //this.onLogicError(16, "服务文件已存在！");
      //return;
    }
  }

  let onResponseCode = "  //跳转到模块首页，如果首页文件名不是index，请修改\n" +
    //"  var pages = getCurrentPages();\n"+
    //"  var prev = pages[pages.length - 2];\n"+
    //"  prev.onRefresh();\n"+
    "  wx.redirectTo({url: '../index/index'});\n";

  var pageDM = {
    client: req.client,
    framework: "wxfp",
    positionType: req.positionType,
    bgColorMode: req.bgColorMode,
    pageType: req.pageType,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: [
      {
        id: "panel_page",
        type: "Panel",
        components: [
          {
            id: "panel_title",
            type: "Panel",
            styles: {
              "width": "100%",
              "height": "50px",
            },
            components: [{
              id: "label_page_title",
              type: "Label",
              value: req.title,
              styles: {
                "margin-left": "20px",
                "font-weight": "bold",
                "height": "50px",
                "line-height": "50px"
              }
            }]
          },
          {
            id: "form1",
            type: "Form",
            submitService: "serviceAdd",
            styles: {
              "width": "100%",
              "margin-top": "10px",
              "margin-bottom": "10px"
            },
            components: []
          }
        ]
      },
      {
        id: "serviceAdd",
        type: "Service",
        path: servicePath,
        autoShowError: true,
        onResponse: "serviceAdd_onResponse",
        argSettings: []
      }
    ],
    jsFuncs: [
      {
        "name": "serviceAdd_onResponse",
        "comment": "服务响应时",
        "editType": "code",
        "args": [
          {
            "name": "req",
            "type": "Object",
            "comment": "请求参数"
          },
          {
            "name": "res",
            "type": "Object",
            "comment": "响应参数"
          }
        ],
        "code": onResponseCode
      }
    ]
  };

  // if(pageDM.pageType=="page") {
  //   pageDM.components[0].styles = {
  //     "left": "10px",
  //     "top": "10px",
  //     "right": "10px",
  //     "bottom": "10px",
  //     "position": "absolute",
  //     "border-radius": " 6px 6px 6px 6px",
  //     "border": "1px solid #eee",
  //     "box-shadow": " 3px 5px 5px #cccccc",
  //     "overflow": "auto"
  //   };
  // } else {
  //   pageDM.components[0].styles = {
  //     "left": "0",
  //     "top": "0",
  //     "right": "0",
  //     "bottom": "0",
  //     "position": "absolute",
  //     "overflow": "auto"
  //   };
  //   pageDM.width = req.dialogWidth.indexOf("px")>0 ? req.dialogWidth : req.dialogWidth+"px";
  //   pageDM.height = req.dialogHeight.indexOf("px")>0 ? req.dialogHeight : req.dialogHeight+"px";
  //   //对话框不显示标题栏
  //   pageDM.components[0].components[0].styles["display"] = "none";
  //   pageDM.components[0].components[1].styles["top"] = "0";
  //   pageDM.components[0].components[2].components[1].onClick = "tfp.closeCurDialog()";
  // }
  // if(pageDM.bgColorMode=="light") {
  //   pageDM.components[0].styles["background-color"] = "#FFFFFF";
  //   pageDM.styles = {
  //     "background-color": "#F0F0F0"
  //   };
  // } else {
  //   pageDM.components[0].styles["background-color"] = "#333333";
  //   pageDM.styles = {
  //     "background-color": "#222222"
  //   };
  // }

  var statement = {
    category: "db",
    type: "insert",
    model: {
      name: req.modelName,
      path: req.modelPath
    },
    fields: [],
    cbArg: "ret",
    statements: [{
      category: "common",
      type: "assign",
      varName: "res.id",
      operator: "=",
      value: "ret.insertId"
    }, {
      category: "common",
      type: "end"
    }]
  };

  var reqArgs = [];

  let cptMetaDatas = global.server.tfpLibFilesCache[req.client].metaDatas;
  let formDM = pageDM.components[0].components[1];

  this.curCptTop = 60;
  //if (pageDM.pageType == "dialog") this.curCptTop = 10;
  for (var i = 0; i < req.fields.length; i++) {
    let field = req.fields[i];
    this.addRow(pageDM, cptMetaDatas, formDM, field, i);

    statement.fields.push({
      name: field.name,
      value: "req." + field.name
    });

    let reqArg = {
      name: field.name,
      comment: field.label,
      type: "string"
    };
    if (field.notnull) reqArg.notNull = true;
    reqArgs.push(reqArg);
  }

  formDM.components.push(
    {
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "width": "100%",
        "margin-top": "10px",
        "margin-bottom": "10px"
      },
      components: [{
        id: "button_submit",
        type: "Button",
        buttonType: "primary",
        value: "确定",
        styles: {},
        formType: "submit"
      }]
    }
  );

  fs.writeFileSync(filePath, JSON.stringify(pageDM, null, "\t"));

  if (!req.createService || addServiceExists) {
    this.end(res);
    return;
  }

  var tbs = {
    name: req.modelName.substr(0, 1).toUpperCase() + req.modelName.substr(1) + "_Add",
    comment: "添加" + req.modelName,
    reqArgs: reqArgs,
    resArgs: [{ name: "id", type: "int" }],
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [statement]
    }]
  };

  res.servicePath = "/app/" + servicePath;
  res.servcieType = servcieType;

  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
  } catch (err) {
    logger.log(err);
    cb(err);
    return;
  }

  if (servcieType == "js") {
    var self = this;
    var compiler = new TBSCompiler();
    compiler.process({ tbs: tbs }, { code: 0 }, function (res2) {
      if (res2.code != 0) {
        self.onLogicError(6, "TBS文件编译失败：" + res2.message);
        return;
      }
      fs.writeFileSync(serviceFilePath, res2.jsCode);
      self.end(res);
    });
  } else {
    fs.writeFileSync(serviceFilePath, JSON.stringify(tbs, null, "\t"));
    this.end(res);
  }
};

CreateDataAddTFP.prototype.addRow = function (pageDM, cptMetaDatas, formDM, field, index) {
  let cptLabelDM = {
    id: "label_" + field.name,
    type: "Label",
    value: field.label + "："
  };
  let cptLabelRequired = {
    id: "label_" + field.name + "_required",
    type: "Label",
    value: "*",
    styles: {
      "color": "#FF0000"
    }
  };
  //if(field.notnull) cptLabelDM.styles["color"] = "#FF0000";
  let cptType = cptMetaDatas[field.type];

  let cptDM = {
    id: field.name,
    type: field.type,
    comment: field.label
  };

  if (field.notnull) {
    cptDM.required = true;
    /*form.components.push({
      id: "panel_"+field.name+"_required",
      type: "Panel",
      styles: {
        "left": "130px",
        "top": (this.curCptTop+10)+"px",
        "position": "absolute",
        "width": "3px",
        "height": "20px",
        "background-color": "#FF6600"
      }
    });*/
  }
  if (field.default) cptDM.value = field.default;
  if (cptType.defaultStyles) {
    if (!cptDM.styles) cptDM.styles = {};
    for (styleName in cptType.defaultStyles) {
      cptDM.styles[styleName] = cptType.defaultStyles[styleName];
    }
  }
  if (field.width) {
    cptDM.styles.width = field.width + "";
    if (cptDM.styles.width.indexOf("px") < 0) cptDM.styles.width += "px";
  }

  let labelContainerDM = formDM;
  let cptContainerDM = formDM;
  if (pageDM.positionType == "float") {
    let flexDM = {
      "type": "FlexBox",
      "id": "flexBox" + index,
      "styles": {
        "width": "100%"
      },
      "components": [
        {
          "id": "flexBox" + index + "_panel1",
          "type": "Panel",
          "styles": {
            "flex-basis": "30%"
          },
          "components": []
        },
        {
          "id": "flexBox" + index + "_panel2",
          "type": "Panel",
          "styles": {
            "flex-basis": "60%"
          },
          "components": []
        }
      ]
    };
    labelContainerDM = flexDM.components[0];
    cptContainerDM = flexDM.components[1];
    if (cptDM.type == "TextArea" || cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      labelContainerDM.styles["height"] = cptType.defaultStyles.height;
      labelContainerDM.styles["line-height"] = cptType.defaultStyles.height;
    }
    formDM.components.push(flexDM);
  } else {
    if (cptDM.type == "TextArea") {
      let height = 120;
      if (cptType.defaultStyles.height)
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      this.curCptTop += height + 20;
      //cptDM.styles["margin-top"] = "10px";
    } else if (cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      let height = 220;
      if (cptType.defaultStyles.height)
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      this.curCptTop += height + 20;
      //cptDM.styles["margin-top"] = "10px";
    } else if (cptDM.type == "Radio" || cptDM.type == "CheckBox") {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "9px";
    } else if (cptDM.type == "Switch") {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "10px";
    } else {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "8px";
    }
  }
  if (field.options && ["Radio", "CheckBox", "Select", "Switch"].contains(cptDM.type)) {
    cptDM.options = [];
    if (typeof (field.options) == "string") {
      if (field.options.startWith("[") && field.options.endWith("[")) {
        cptDM.options = JSON.parse(field.options);
      } else {
        let options = field.options.split(",");
        if (cptDM.type == "Switch") {
          cptDM.options = options;
        } else {
          for (var j = 0; j < options.length; j++) {
            cptDM.options.push({ value: options[j], text: options[j] });
          }
        }
      }
    } else if (Array.isArray(field.options)) {
      cptDM.options = field.options;
      /*for(var j=0;j<field.options.length;j++) {
        cptDM.options.push({value:field.options[j], text:field.options[j]});
      }*/
    }
  }
  if (cptDM.type == "Switch" && !cptDM.options) cptDM.options = [false, true];
  if (cptDM.type == "Select") cptDM.rootParentId = "0";
  if (["Date", "DateTime", "User", "Dep", "Role"].contains(cptDM.type)) {
    cptDM.showIcon = true;
  }

  //如果当前页面为绝对定位，必填项提示放在输入项标签前面，因为无法很好的计算输入项标题组件的长度
  if (pageDM.positionType == "absolute" && field.notnull)
    labelContainerDM.components.push(cptLabelRequired);
  labelContainerDM.components.push(cptLabelDM);
  //如果当前页面为浮动定位，必填项提示放在输入项标签后面
  if (pageDM.positionType == "float" && field.notnull)
    labelContainerDM.components.push(cptLabelRequired);
  cptContainerDM.components.push(cptDM);
};

