var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TBSCompiler = require('TBSCompiler');

/**
 * 添加数据添加页面
 */
var CreateDataAddTFP = function () {
  Service.call(this);
  this.sqlInject = { check: false };
};

util.inherits(CreateDataAddTFP, Service);

module.exports = CreateDataAddTFP;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
CreateDataAddTFP.prototype.process = function (req, res) {
  if (!req.proj) {
    this.onLogicError(1, "请提供项目名称！");
    return;
  }
  if (!req.path) {
    this.onLogicError(2, "请提供保存路径！");
    return;
  }
  req.path = req.path.endWith(".tfp") ? req.path : req.path + ".tfp";
  let fileName = req.path.substr(req.path.lastIndexOf("/") + 1);
  if (!fileName) {
    this.onLogicError(3, "请提供文件名称！");
    return;
  }
  if (!req.title) {
    this.onLogicError(4, "请提供页面标题！");
    return;
  }
  if (!req.client) {
    this.onLogicError(5, "请提供客户端类型！");
    return;
  }
  if (!req.pageType) {
    this.onLogicError(7, "请提供页面类型！");
    return;
  }
  if (!req.positionType) {
    this.onLogicError(8, "请提供定位方式！");
    return;
  }
  if (!req.bgColorMode) {
    this.onLogicError(8, "请提供背景颜色！");
    return;
  }
  if (req.pageType == "dialog") {
    if (!req.dialogWidth) {
      this.onLogicError(9, "请提供窗口宽度！");
      return;
    }
    req.dialogWidth += "";
    if (!req.dialogHeight) {
      this.onLogicError(10, "请提供窗口高度！");
      return;
    }
    req.dialogHeight += "";
  }
  if (!req.model) {
    this.onLogicError(11, "请提供数据模型名称！");
    return;
  }

  req.modelName = "";
  req.modelPath = "";
  if (req.model.indexOf("/") < 0) {
    req.modelName = req.model;
    req.modelPath = "/app/" + req.proj + "/model/" + req.model + ".tdm";
  } else {
    req.modelName = req.model.substr(req.model.lastIndexOf("/") + 1);
    req.modelName = req.modelName.substr(0, req.modelName.lastIndexOf("."));
    req.modelPath = "/app/" + req.model;
  }

  if (!req.fields || req.fields.length == 0) {
    this.onLogicError(12, "请提供要添加的字段信息！");
    return;
  }
  let filePath = utils.getPath(req.path);
  if (fs.existsSync(filePath)) {
    this.onLogicError(14, "TFP文件已存在！");
    return;
  }

  this.labelPosition = req.labelPosition;

  let tbsPath = req.path.substring(("/web/app/"+req.proj+"/").length);
  if (tbsPath.indexOf("/") < 0) {
    tbsPath = req.proj+"/service";
  } else {
    tbsPath = req.proj+"/service/"+tbsPath.substring(0, tbsPath.lastIndexOf("/"));
  }

  let fileNameMini = fileName.substring(0, fileName.lastIndexOf("."));

  let serviceFilePath = "";
  let servcieType = "tbs";
  let servicePath = "";
  let addServiceExists = false;
  if (req.createService) {
    if (req.addServicePath) {
      servicePath = req.addServicePath.substring(0, req.addServicePath.lastIndexOf("/")) + "/" + fileNameMini + "_form1_add.tbs";;
    } else {
      servicePath = tbsPath + "/" + fileNameMini + "_form1_add.tbs";
      req.addServicePath = servicePath;
    }
  } else {
    servicePath = req.addServicePath;
  }
  serviceFilePath = utils.getPath("/app/" + servicePath);

  let onResponseCode = [{
    "category": "page",
    "type": "tfp.gotoPage",
    "url": "'index.tfp'"
  }];
  let button_cancel_onClick = {
    "category": "page",
    "type": "tfp.closeCurPage"
  };
  if (req.pageType == "dialog") {
    onResponseCode = [
      {
        "category": "dialog",
        "type": "tfp.getCurDialog",
        "retVarName": "dialog"
      },
      {
        "category": "common",
        "type": "custom",
        "content": "dialog.opener.grid1.reloadData()"
      },
      {
        "category": "dialog",
        "type": "tfp.closeCurDialog"
      }
    ];
    button_cancel_onClick = {
      "category": "dialog",
      "type": "tfp.closeCurDialog"
    };
  } else if (req.pageType == "drawer") {
    onResponseCode = [
      {
        "category": "drawer",
        "type": "tfp.getCurDrawer",
        "retVarName": "drawer"
      },
      {
        "category": "common",
        "type": "custom",
        "content": "drawer.opener.grid1.reloadData()"
      },
      {
        "category": "drawer",
        "type": "tfp.closeDrawer"
      }
    ];
  }

  var pageDM = {
    client: req.client,
    framework: "tfp",
    positionType: req.positionType,
    bgColorMode: req.bgColorMode,
    pageType: req.pageType,
    title: req.title,
    type: "Page",
    docType: "HTML5",
    components: [{
      id: "panel_page",
      type: "Panel",
      components: [{
        id: "form1",
        type: "Form",
        styles: {
          "left": "0",
          "top": "20px",
          "right": "0",
          "bottom": "20px",
          "position": "absolute",
          "overflow": "auto"
        },
        "dataSubmitSetting": {
          "requestMode": req.createService ? "model" : "service",
          "requestArgs": [],
          "servicePath": servicePath
        },
        components: [],
        "onAfterSubmit": "form1_onAfterSubmit(req, res)"
      }]
    }],
    jsFuncs: [
      {
        "name": "form1_onAfterSubmit",
        "comment": "表单提交后",
        "editType": "gui",
        "args": [
          {
            "name": "req",
            "type": "Object",
            "comment": "请求参数"
          },
          {
            "name": "res",
            "type": "Object",
            "comment": "响应参数"
          }
        ],
        "statements": onResponseCode
      }
    ],
    cptDataBindSetting: {
      form1: {}
    }
  };
  if(req.pageType=="drawer") {
    pageDM.jsFuncs.push({
			"name": "page1_onClickDrawerOKButton",
			"comment": "点击抽屉页确定按钮时",
			"editType": "gui",
			"args": [],
			"statements": [
				{
					"category": "component",
					"type": "callCptFunc",
					"cptId": "form1",
					"funcName": "submit"
				}
			]
		});
    pageDM.onClickDrawerOKButton = "page1_onClickDrawerOKButton()";
  }
  if(req.createService) {
    pageDM.cptDataBindSetting.form1.dataSubmitSetting = {
      "requestMode": "model",
      "modelPath": req.modelPath.substring(("/app/").length),
      "submitType": "add",
      "cptType": "Form",
      "fields": [],
      "uploaders": [],
      "type": "submit",
      "serviceName": "form1_add",
      "servicePath": servicePath
    };
  }

  //如果不是抽屉页，在页面底部添加确定和取消按钮
  if (pageDM.pageType != "drawer") {
    pageDM.components[0].components[0].styles["bottom"] = "50px";
    pageDM.components[0].components.push({
      id: "panel_bottom",
      type: "Panel",
      styles: {
        "left": "0",
        "height": "50px",
        "right": "0",
        "bottom": "0",
        "position": "absolute",
        "overflow": "auto",
        "display": "flex",
        "flex-direction": "row",
        "align-items": "center",
        "justify-content": (pageDM.pageType == "dialog") ? "flex-end" : "center"
      },
      components: [{
        id: "button_submit",
        type: "Button",
        buttonType: "primary",
        value: "确定",
        theme: "rect",
        styles: {
          "cursor": "pointer",
          "text-align": "center",
          "height": "30px"
        },
        onClick: "button_submit_onClick()",
        "showImage": true,
        "imageUrl": "tfp-button-icon tfp-button-icon-ziyuanxhdpi",
        "imageWidth": "16",
        "imageHeight": "16"
      }, {
        id: "button_cancel",
        type: "Button",
        buttonType: "default",
        value: "取消",
        theme: "rect",
        styles: {
          "margin-left": "10px",
          "cursor": "pointer",
          "text-align": "center",
          "margin-right": "20",
          "height": "30px"
        },
        onClick: "button_cancel_onClick()",
        "showImage": true,
        "imageUrl": "tfp-button-icon tfp-button-icon-quxiao",
        "imageWidth": "16",
        "imageHeight": "16"
      }]
    });
    pageDM.jsFuncs.push({
      "name": "button_submit_onClick",
      "comment": "点击确定按钮时",
      "editType": "gui",
      "args": [],
			"statements": [
				{
					"category": "component",
					"type": "callCptFunc",
					"cptId": "form1",
					"funcName": "submit"
				}
			]
    });
    pageDM.jsFuncs.push({
      "name": "button_cancel_onClick",
      "comment": "点击取消按钮时",
      "editType": "gui",
      "args": [],
      "statements": [ button_cancel_onClick ]
    });
  }

  //如果不是对话框，要增加页边距
  if (pageDM.pageType != "dialog" && pageDM.pageType != "drawer") {
    pageDM.components[0].styles = {
      "left": "10px",
      "top": "10px",
      "right": "10px",
      "bottom": "10px",
      "position": "absolute",
      "border-radius": " 6px 6px 6px 6px",
      "border": "1px solid #eee",
      "box-shadow": " 3px 5px 5px #cccccc",
      "overflow": "auto"
    };
  } else {
    pageDM.components[0].styles = {
      "left": "0",
      "top": "0",
      "right": "0",
      "bottom": "0",
      "position": "absolute",
      "overflow": "auto"
    };
    if(pageDM.pageType == "dialog") {
      pageDM.width = req.dialogWidth.indexOf("px") > 0 ? req.dialogWidth : req.dialogWidth + "px";
      pageDM.height = req.dialogHeight.indexOf("px") > 0 ? req.dialogHeight : req.dialogHeight + "px";
    }
    //对话框不显示标题栏
    //pageDM.components[0].components[0].styles["display"] = "none";
    pageDM.components[0].components[0].styles["top"] = "0";
  }
  if (pageDM.bgColorMode == "light") {
    pageDM.components[0].styles["background-color"] = "#FFFFFF";
    pageDM.styles = {
      "background-color": "#F0F0F0"
    };
  } else {
    pageDM.components[0].styles["background-color"] = "#333333";
    pageDM.styles = {
      "background-color": "#222222"
    };
  }

  var statement = {
    category: "db",
    type: "insert",
    model: {
      name: req.modelName,
      path: req.modelPath
    },
    fields: [],
    cbArg: "ret",
    statements: [{
      category: "common",
      type: "assign",
      varName: "res.id",
      operator: "=",
      value: "ret.insertId"
    }, {
      category: "common",
      type: "end"
    }]
  };

  var reqArgs = [];

  let cptMetaDatas = global.server.tfpLibFilesCache[req.client].metaDatas;
  let formDM = pageDM.components[0].components[0];

  this.curCptTop = 60;
  let inputSizeInRow = 1;
  if (req.inputSizeInRow) inputSizeInRow = parseInt(req.inputSizeInRow);
  if (pageDM.pageType == "dialog") this.curCptTop = 10;
  let rowIndex = 0;
  let cellIndex = 0;
  let colIndex = 0;
  for (var i = 0; i < req.fields.length; i++) {
    let field = req.fields[i];
    //如果一行显示一个输入项，或者定位方式为绝对定位
    if (inputSizeInRow == 1 || pageDM.positionType == "absolute") {
      this.addRow(pageDM, cptMetaDatas, formDM, field, i);
    } else {  //如果是浮动定位，且一行多个输入项，则每行要先用一个弹性栅格作为容器
      let flexBasisOneCol = Number((100 / inputSizeInRow).toString().match(/^\d+(?:\.\d{0,2})?/));
      if (cellIndex % inputSizeInRow == 0) {
        colIndex = 0;
        let rowPanel = {
          "id": "flexBox_row_" + (rowIndex + 1),
          "type": "FlexBox",
          "styles": {
            "display": "flex",
            "width": "100%",
            "padding-left": "20px",
            "padding-right": "20px"
          },
          "components": []
        };
        for (let j = 0; j < inputSizeInRow; j++) {
          let cptPanel = {
            "id": "flexBox_row_" + (rowIndex + 1) + "_panel" + (j + 1),
            "type": "Panel",
            "styles": {
              "flex-grow": 0,
              "flex-shrink": 0,
              "height": "40px"
            },
            "components": []
          };
          if (req.labelPosition == "top") cptPanel.styles["height"] = "80px";
          cptPanel.styles["flex-basis"] = flexBasisOneCol + "%";
          rowPanel.components.push(cptPanel);
        }
        this.curRowPanel = rowPanel;
        formDM.components.push(rowPanel);
        rowIndex++;
      }
      let curCptPanel = this.curRowPanel.components[colIndex];
      //如果当前输入项占用多列
      if(field.colcount && field.colcount>1) {
        if(field.colcount>inputSizeInRow) field.colcount = inputSizeInRow;
        //如果剩下的列数小于当前输入项需要占用的列数，则需要另起一行
        if((inputSizeInRow-cellIndex % inputSizeInRow)<field.colcount) {
          cellIndex += inputSizeInRow - cellIndex % inputSizeInRow;
          console.log("另起一行,cellIndex:"+cellIndex);
          i--;
          colIndex = 0;
          continue;
        } else {
          curCptPanel.styles["flex-basis"] = (flexBasisOneCol * field.colcount) + "%";
          cellIndex += field.colcount - 1;
          for(let j=0;j<field.colcount - 1;j++) {
            this.curRowPanel.components.pop();
          }
        }
      }
      colIndex++;
      cellIndex++;
      this.addRow(pageDM, cptMetaDatas, curCptPanel, field, i);
    }

    statement.fields.push({
      name: field.name,
      comment: field.label,
      value: "req." + field.name
    });

    let reqArg = {
      name: field.name,
      comment: field.label,
      type: "string"
    };
    if (field.notnull) reqArg.notNull = true;
    if (field.default) reqArg.default = field.default;
    reqArgs.push(reqArg);
  }

  //如果有在后台服务里设置的字段
  if(req.bgSetFields) {
    for (var i = 0; i < req.bgSetFields.length; i++) {
      let field = req.bgSetFields[i];

      statement.fields.push({
        name: field.fieldName,
        comment: field.fieldName,
        value: field.fieldValue
      });
    }
  }

  if(req.createService) pageDM.cptDataBindSetting.form1.dataSubmitSetting.fields = statement.fields;

  fs.writeFileSync(filePath, JSON.stringify(pageDM, null, "\t"));

  if (!req.createService) {
    this.end(res);
    return;
  }

  var tbs = {
    name: req.modelName.substr(0, 1).toUpperCase() + req.modelName.substr(1) + "_Add",
    comment: "添加" + req.modelName,
    reqArgs: reqArgs,
    resArgs: [{ name: "id", type: "int" }],
    methods: [{
      name: "process",
      comment: "处理服务请求",
      args: [{
        name: "req",
        type: "object",
        comment: "服务请求对象"
      }, {
        name: "res",
        type: "object",
        comment: "服务响应对象"
      }],
      statements: [statement]
    }]
  };

  res.servicePath = "/app/" + servicePath;
  res.servcieType = servcieType;

  let arrDir = servicePath.split("/");
  try {
    let serviceDir = utils.getPath("/app");
    for (let i = 0; i < arrDir.length - 1; i++) {
      if (arrDir[i] == "") continue;
      serviceDir += "/" + arrDir[i];
      if (!fs.existsSync(serviceDir)) fs.mkdirSync(serviceDir);
    }
  } catch (err) {
    logger.log(err);
    cb(err);
    return;
  }

  if (servcieType == "js") {
    var self = this;
    var compiler = new TBSCompiler();
    compiler.process({ tbs: tbs }, { code: 0 }, function (res2) {
      if (res2.code != 0) {
        self.onLogicError(6, "TBS文件编译失败：" + res2.message);
        return;
      }
      fs.writeFileSync(serviceFilePath, res2.jsCode);
      self.end(res);
    });
  } else {
    fs.writeFileSync(serviceFilePath, JSON.stringify(tbs, null, "\t"));
    this.end(res);
  }
};

CreateDataAddTFP.prototype.addRow = function (pageDM, cptMetaDatas, parentDM, field, index) {
  let labelWidth = "180px";
  if (pageDM.pageType == "dialog") labelWidth = "120px";
  let cptLabelDM = {
    id: "label_" + field.name,
    type: "Label",
    value: field.label + "："
  };
  if (pageDM.positionType == "float") {
    cptLabelDM.styles = {
      "line-height": "30px",
      "color": "#666666",
      "width": "100%"
    };
  } else {
    cptLabelDM.styles = {
      "position": "absolute",
      "z-index": "1",
      "left": "40px",
      "top": this.curCptTop + "px",
      "color": "#666666"
    };
  }
  let cptType = cptMetaDatas[field.type];

  let cptDM = {
    id: field.name,
    type: field.type,
    comment: field.label,
    styles: {}
  };

  //如果设置了数据字典
  if (field.datadic) {
    cptDM.type = "DataDic";
    cptDM.typeCode = field.datadic;
  } else if(field.type=="EncodingRule") {
    cptDM.updateMode = "R";
    cptDM.readonly = true;
    cptDM.ruleCode = field.default;
  }
  //设置组件默认样式
  if (cptType.defaultStyles) {
    for (styleName in cptType.defaultStyles) {
      cptDM.styles[styleName] = cptType.defaultStyles[styleName];
    }
  }
  if (pageDM.positionType == "float") {
    cptDM.styles.width = "100%";
  } else {
    cptDM.styles.position = "absolute";
    cptDM.styles["z-index"] = "1";
    cptDM.styles.left = labelWidth;
    cptDM.styles.top = this.curCptTop + "px";
  }
  if (field.notnull) {
    cptDM.required = true;
    cptLabelDM.attach = "asterisk-suffix";
  }
  if (field.default) cptDM.value = field.default;
  if (field.width) {
    cptDM.styles.width = field.width + "";
    if (cptDM.styles.width.indexOf("px") < 0 && cptDM.styles.width.indexOf("%") < 0) cptDM.styles.width += "px";
  } else if (cptDM.type == "User" || cptDM.type == "Dep" || cptDM.type == "Role") {
    cptDM.styles["height"] = "30px";
    cptDM.valueType = "id";
  } else if (cptDM.type == "Date" || cptDM.type == "DateTime" || cptDM.type == "Time") {
    cptDM.styles["height"] = "30px";
  }
  if(cptDM.type=="Switch") delete cptDM.styles["width"];

  let labelContainerDM = parentDM;
  let cptContainerDM = parentDM;
  if (pageDM.positionType == "float") {
    let flexDM = {
      "type": "FlexBox",
      "id": "flexBox" + index,
      "styles": {
        "display": "flex",
        "width": "100%",
        "padding-left": "10px",
        "padding-right": "10px"
      },
      "components": [
        {
          "id": "flexBox" + index + "_panel1",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "40%",
            "height": "30px",
            "margin-top": "5px",
            "margin-bottom": "5px"
          },
          "components": []
        },
        {
          "id": "flexBox" + index + "_panel2",
          "type": "Panel",
          "styles": {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "60%",
            "height": "30px",
            "margin-top": "5px",
            "margin-bottom": "5px"
          },
          "components": []
        }
      ]
    };
    labelContainerDM = flexDM.components[0];
    cptContainerDM = flexDM.components[1];
    if (this.labelPosition == "top") {
      flexDM.styles["flex-direction"] = "column";
      flexDM.components[0].styles["flex-basis"] = "30px";
      flexDM.components[1].styles["flex-basis"] = "30px";
    } else {
      flexDM.components[0].styles["flex-basis"] = "100px";
      flexDM.components[1].styles["flex-grow"] = "1";
      flexDM.components[1].styles["flex-shrink"] = "1";
      flexDM.components[1].styles["flex-basis"] = "auto";
    }
    if (cptDM.type == "TextArea" || cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      if (this.labelPosition == "top") {
        cptContainerDM.styles["flex-basis"] = cptType.defaultStyles.height;
      } else {
        cptContainerDM.styles["height"] = cptType.defaultStyles.height;
      }
      if (parentDM.type != "Form") {
        let iptHeight = parseInt(cptType.defaultStyles.height.replace("px", ""));
        if (this.labelPosition == "top") {
          parentDM.styles["height"] = (iptHeight + 50) + "px";
        } else {
          parentDM.styles["height"] = (iptHeight + 10) + "px";
        }
      }
      //labelContainerDM.styles["line-height"] = cptType.defaultStyles.height;
    } else if(cptDM.type=="FileUpload" || cptDM.type=="PhotoUpload") {
      let cptHeight = "150px";
      if (this.labelPosition == "top") {
        cptContainerDM.styles["flex-basis"] = cptHeight;
      } else {
        cptContainerDM.styles["height"] = cptHeight;
      }
      if (parentDM.type != "Form") {
        if (this.labelPosition == "top") {
          parentDM.styles["height"] = "200px";
        } else {
          parentDM.styles["height"] = "160px";
        }
      }
    }
    parentDM.components.push(flexDM);
  } else {
    if (cptDM.type == "TextArea" || cptDM.type == "FileUpload" || cptDM.type == "PhotoUpload") {
      let height = 120;
      if (cptType.defaultStyles.height)
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      this.curCptTop += height + 20;
      //cptDM.styles["margin-top"] = "10px";
    } else if (cptDM.type == "RichText" || cptDM.type == "CKEditor") {
      let height = 220;
      if (cptType.defaultStyles.height)
        height = parseInt((cptType.defaultStyles.height + "").replace("px", ""));
      this.curCptTop += height + 20;
      //cptDM.styles["margin-top"] = "10px";
    } else if (cptDM.type == "Radio" || cptDM.type == "CheckBox") {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "9px";
    } else if (cptDM.type == "Switch") {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "10px";
    } else {
      this.curCptTop += 40;
      //cptDM.styles["margin-top"] = "8px";
    }
  }
  if (field.options && ["Radio", "CheckBox", "Select", "PopupList", "Switch"].contains(cptDM.type)) {
    cptDM.options = [];
    if (typeof (field.options) == "string") {
      if (field.options.startWith("[") && field.options.endWith("[")) {
        cptDM.options = JSON.parse(field.options);
      } else {
        let options = field.options.split(",");
        if (cptDM.type == "Switch") {
          cptDM.options = options;
        } else {
          for (var j = 0; j < options.length; j++) {
            cptDM.options.push({ value: options[j], text: options[j] });
          }
        }
      }
    } else if (Array.isArray(field.options)) {
      cptDM.options = field.options;
      /*for(var j=0;j<field.options.length;j++) {
        cptDM.options.push({value:field.options[j], text:field.options[j]});
      }*/
    }
  }
  if (cptDM.type == "Switch" && !cptDM.options) cptDM.options = [false, true];
  if (cptDM.type == "Select") cptDM.rootParentId = "0";
  if (["Date", "DateTime", "Time", "User", "Dep", "Role"].contains(cptDM.type)) {
    cptDM.showIcon = true;
  }

  labelContainerDM.components.push(cptLabelDM);
  cptContainerDM.components.push(cptDM);
};