var utils = require('utils');
var TFPHandler = require('TFPHandler');
var Module = require('module');
var Tasgine = require('Tasgine');
var fs = require('fs');
var path = require('path');

var BatchCompiler = function () {
    this.projCode = "";
    this.fileList = [];
};

module.exports = BatchCompiler;

BatchCompiler.prototype.process = function (projCode) {
    if (process.argv.length < 3) {
        console.log("请提供项目代码，示例：");
        console.log("tasgine compiletfp jxc");
        return;
    }
    this.projCode = process.argv[2];
    global.server = new Tasgine();
    global.server.config = require('../../../../config/Tasgine.json');
    global.server.moduleLoader = new Module('Tasgine');

    var Logger = require('Logger');
    global.logger = new Logger();
    global.logger.serverType = 'BatchTFPCompiler';
    global.logger.setConfig(server.config.Logger);
    global.logger.start();

    console.log('正在加载tfp组件库文件...');
    let tfpFullJsPath = utils.getPath("/web" + server.config.TFPHandler.tfpRootPath + "/src/tfp.full.js");
    tfpFullJsPath = "file:///" + tfpFullJsPath.replace(/\\/g, "/");
    let startJsPath = utils.getPath("/web" + server.config.TFPHandler.tfpRootPath + "/index.js");
    startJsPath = "file:///" + startJsPath.replace(/\\/g, "/");

    var self = this;
    let tfpFullPromise = global.server.moduleLoader.importESModule(tfpFullJsPath, startJsPath);
    tfpFullPromise.then(function (tfpFull) {
        server.setTfpLibCache(tfpFull.default);
        console.log("正在分析项目文件结构...");
        self.getFileList(utils.getPath("/web/app/" + self.projCode));
        if (self.fileList.length == 0) {
            console.log("未找到tfp文件。");
            return;
        }
        console.log("共找到 " + self.fileList.length + " 个tfp文件，开始编译...");
        self.startTime = new Date();
        self.compileTFP(0);
    });
}

BatchCompiler.prototype.getFileList = function (dirPath, cb) {
    let list = fs.readdirSync(dirPath);
    if (list.length == 0) return;
    for (var i = 0; i < list.length; i++) {
        let pathName = path.join(dirPath, "/" + list[i]);
        let stat = fs.statSync(pathName);
        if (stat.isFile()) {
            if (path.extname(pathName) == ".tfp") this.fileList.push(pathName);
        } else {
            this.getFileList(pathName);
        }
    }
}


function formatDuring(mss) {
    if (mss < 1000) return mss + " 毫秒";
    var days = parseInt(mss / (1000 * 60 * 60 * 24));
    var hours = parseInt((mss % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = parseInt((mss % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = ((mss % (1000 * 60)) / 1000).toFixed(0);
    let ret = "";
    if (days > 0) ret = days + " 天 ";
    if (hours > 0 || days > 0) ret += hours + " 小时 ";
    if (minutes > 0 || hours > 0 || days > 0) ret += minutes + " 分钟 ";
    ret += seconds + " 秒 ";
    return ret;
}

BatchCompiler.prototype.compileTFP = function (index) {
    if (index >= this.fileList.length) {
        console.log("项目[" + this.projCode + "]的所有tfp文件都已编译完毕！");
        this.endTime = new Date();
        console.log("共编译 " + this.fileList.length + " 个tfp文件，总用时：" + formatDuring(this.endTime - this.startTime));
        logger.isRunning = false;
        return;
    }
    let filePath = this.fileList[index];
    let urlPath = filePath.substr(filePath.indexOf("\\web") + 4).replace(/\\/g, '/');
    console.log('正在编译文件：' + urlPath);
    var self = this;
    fs.readFile(filePath, "utf-8", function (err, data) {
        if (err) {
            logger.log(err);
            return;
        }

        let pageDataModel;
        try {
            pageDataModel = JSON.parse(data);
        } catch (e) {
            logger.log(e);
            return;
        }

        let options = {
            urlPath: urlPath,
            pageDataModel: pageDataModel,
            createFile: true
        };
        var tfpHandler = new TFPHandler();
        tfpHandler.compileTfp(options, function (err, html) {
            self.compileTFP(index + 1);
        });
    });
}