var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');
var PackageManager = require('../proj/packageManager.js');

/**
 * 保存数据模型（文件）
 */
var Save = function () {
    Service.call(this);
    this.sqlInject.exclude = ['tdmData'];
    this.xssInject.exclude = ['tdmData'];
    this.pkManager = new PackageManager();

    // VARCHAR
    // CHAR
    // TEXT
    // INT
    // SMALLINT
    // BIGINT
    // FLOAT
    // DECIMAL
    // DATETIME
    // TIMESTAMP


    //例子
    // var obj = {
    //   'dt_name': 't',
    //   'dt_type': 'table',
    //   'dt_comment': ''
    // };

    // var list = [{
    //   'dc_name': 'a',
    //   'dc_type': 'a',
    //   'dc_p': true,
    //   'dc_i': true,
    //   'dc_m': true,
    //   'dc_u': true,
    //   'dc_length': 50,
    //   'dc_precision': 16,
    //   'dc_scale': 2,
    //   'dc_default': '',
    //   'dc_comment': 'w',
    // }];

    // var tdm = {
    //   'table': 't',
    //   'type': 'table',
    //   'fields': {
    //     'a': {
    //       'type': 'int',
    //       'primaryKey': true, //p
    //       'autoIncrement': true, //i
    //       'notNull': true, //m
    //       'uniqueIndex': false, //u
    //       'length': 50,
    //       'precision': 16,
    //       'scale': 2,
    //       'default': '',
    //       'comment': 'w',
    //       'order': 1 //
    //     }
    //   }
    // };
};

util.inherits(Save, Service);

module.exports = Save;

/**
 * 保存数据模型（文件）
 * @param {*} req 
 * projName modelName tdmData oldModelName mode
 * --应用名称 模型名称 数据 原模型名称 模式（0 只保存 1 保存并返回语句 2 保存并执行）
 * @param {*} res 
 * @param {*} cb 
 */
Save.prototype.process = function (req, res) {
    if (!req.projName) {
        this.onLogicError(1, '请提供项目名称！');
        return;
    }
    if (!req.modelName && !req.modelPath) {
        this.onLogicError(2, '请提供数据模型名称或路径！');
        return;
    }
    this._tdmData = JSON.parse(JSON.stringify(req.tdmData));
    let dsConfig = dsUtils.getDsConfig(req.tdmData.dsId);
    var dao = dsUtils.createDao(this, null, dsConfig);
    var connection = new Connection(dsConfig);
    var projName = req.projName;
    var filePath = '';
    if (req.modelName) {
        let modelName = req.modelName.endWith('.tdm') ? req.modelName : req.modelName + '.tdm';
        filePath = utils.getPath('/app/' + req.projName + '/model/' + modelName);
        req.modelPath = req.projName + '/model/' + modelName;
    } else if (req.modelPath) {
        filePath = utils.getPath('/app/' + req.modelPath);
    }
    if (req.oldModelName) {
        var oldModelName = req.oldModelName.endWith('.tdm') ? req.oldModelName : req.oldModelName + '.tdm';
        var oldFilePath = filePath.substring(0, filePath.lastIndexOf('/') + 1) + oldModelName;
        if (fs.existsSync(oldFilePath)) fs.unlinkSync(oldFilePath);
    }

    //var appPath = utils.getPath('/app/' + projName);
    //var dirPath = utils.getPath('/app/' + projName + '/model');
    //if (!fs.existsSync(appPath)) fs.mkdirSync(appPath);
    //if (!fs.existsSync(dirPath)) fs.mkdirSync(dirPath);
    // if (fs.existsSync(filePath)) fs.unlinkSync(filePath);

    //保存并生成语句
    if (req.mode == '1') {
        var fileData = (req.tdmData) ? JSON.stringify(req.tdmData, null, '\t') : '';
        fs.writeFileSync(filePath, fileData);
        res.fileData = fileData;
        var tdmData = req.tdmData;
        res.sqlList = connection.getDDL(tdmData);
        this.updatePackageInfo(req, res);
    }
    //执行语句后保存
    else if (req.mode == '2') {
        var self = this;
        var tdmData = req.tdmData;
        res.sqlList = connection.getDDL(tdmData);
        this.executeAll(dao, res.sqlList, 0, function () {
            if (tdmData.type == 'view') {
                tdmData.version = 1;
                if ('oldName' in tdmData) delete tdmData['oldName'];
                if ('oldVersion' in tdmData) delete tdmData['oldVersion'];
                if ('status' in tdmData) delete tdmData['status'];
                if ('oldStatement' in tdmData) delete tdmData['oldStatement'];
                if ('isUpdateVersion' in tdmData) delete tdmData['isUpdateVersion'];
                self.generateFields(dao, connection, tdmData, function (tdmData) {
                    var fileData = (tdmData) ? JSON.stringify(tdmData, null, '\t') : '';
                    fs.writeFileSync(filePath, '');
                    fs.writeFileSync(filePath, fileData);
                    res.fileData = fileData;
                    self.updatePackageInfo(req, res, function () {
                        self.saveRecord(req, res);
                    });
                });
            }
            else {
                var fileData = (tdmData) ? JSON.stringify(tdmData, null, '\t') : '';
                fs.writeFileSync(filePath, '');
                fs.writeFileSync(filePath, fileData);
                res.fileData = fileData;
                self.updatePackageInfo(req, res, function () {
                    self.saveRecord(req, res);
                });
            }
        });
        // dao.exeSql(res.sql, function () {
        //   var fileData = (tdmData) ? JSON.stringify(tdmData, null, '\t') : '';
        //   fs.writeFileSync(filePath, fileData);
        //   res.fileData = fileData;
        //   self.updatePackageInfo(req, res);
        // });
    }
    //只保存
    else {
        var self = this;
        var tdmData = req.tdmData;
        var fileData = (tdmData) ? JSON.stringify(tdmData, null, '\t') : '';
        fs.writeFileSync(filePath, '');
        fs.writeFileSync(filePath, fileData);
        res.fileData = fileData;
        self.updatePackageInfo(req, res);
    }
};

/**
 * 更新项目或产品的包信息
 * @param {*} req 
 * @param {*} res 
 */
Save.prototype.updatePackageInfo = function (req, res, cb) {
    var self = this;
    this.pkManager.setModelInfo(req, req.modelPath, req.tdmData, function () {
        if (cb) cb();
        else self.end(res);
    });
};

Save.prototype.executeAll = function (dao, sqlList, index, cb) {
    var self = this;
    if (index >= sqlList.length) return cb();
    dao.exec(sqlList[index], [], { openTransaction: true }, function () {
        self.executeAll(dao, sqlList, ++index, cb);
    });
};

Save.prototype.generateFields = function (dao, connection, tdmData, cb) {
    dao.execute(connection.getItemsMETA({
        "object_type": tdmData.type,
        "object_name": tdmData.table
    }), null, function (itemsMETA) {
        tdmData.fields = {};
        tdmData.indexs.length = 0;
        for (var i = 0; i < itemsMETA.length; i++) {
            var item = itemsMETA[i];
            tdmData.fields[item.object_name] = connection.getModelTypeDDL(item);
            tdmData.indexs.push(item.object_name);
        }
        if (tdmData.type == 'view') {
            // 替换fields中的备注为configuration.select中的备注
            if (tdmData.configuration) {
                tdmData.configuration.select.forEach(_item => {
                    if (tdmData.fields[_item.alias]) {
                        tdmData.fields[_item.alias].comment = _item.remark;
                    }
                });
            }
            dao.execute(connection.getDetailMETA({
                object_type: 'VIEW',
                object_name: tdmData.table
            }), [], function (sql) {
                tdmData.statement = sql[0].sql_statement;
                cb(tdmData);
            });
        } else {
            cb(tdmData);
        }
    });
};

Save.prototype.saveRecord = function (req, res) {
    if (!req.tdmData) {
        this.end(res);
        return;
    }
    var self = this;
    var dbDir = "";
    if (req.modelPath) {
        var appJsonPath = utils.getPath('/app/' + req.modelPath.split('model')[0]) + 'app.json';
        if (!fs.existsSync(appJsonPath)) {
            this.end(res);
            return;
        }
        var appJson = JSON.parse(fs.readFileSync(appJsonPath, 'utf8'));
        if (!appJson || (appJson && !appJson.id)) {
            this.end(res);
            return;
        }
        var modelDir = path.dirname(req.modelPath);
        dbDir = utils.getPath('/app/' + modelDir.replace('model', 'db'));
    } else {
        var appJsonPath = utils.getPath('/app/' + req.projName) + 'app.json';
        if (!fs.existsSync(appJsonPath)) {
            this.end(res);
            return;
        }
        var appJson = JSON.parse(fs.readFileSync(appJsonPath, 'utf8'));
        if (!appJson || (appJson && !appJson.id)) {
            this.end(res);
            return;
        }
        dbDir = utils.getPath('/app/' + req.projName + '/db');
    }

    // if (!fs.existsSync(dbDir)) fs.mkdirSync(dbDir);
    this.mkdirsSync(dbDir);
    var tdmDir = dbDir + '/' + req.tdmData.table;
    if (!fs.existsSync(tdmDir)) fs.mkdirSync(tdmDir);
    var sqlContent = '';
    var tdmSqlPath = tdmDir + '/' + req.tdmData.table + '_tmp.sql';
    if (fs.existsSync(tdmSqlPath)) sqlContent = fs.readFileSync(tdmSqlPath, 'utf8');
    getSqlList(function(sqlList) {
        for (var i = 0; i < sqlList.length; i++) {
            if (sqlContent && sqlContent != '') sqlContent += '\n';
            sqlContent += sqlList[i];
        }
        fs.writeFileSync(tdmSqlPath, sqlContent);

        // var packageJson = '';
        // var packagePath = path.join(tdmDir, 'package.json');
        // if (!fs.existsSync(packagePath)) {
        //     packageJson = {
        //         table: req.tdmData.table,
        //         type: req.tdmData.type,
        //         dbType: req.tdmData.dbType,
        //         version: 1,
        //         status: req.tdmData.status,
        //         record: []
        //     }
        //     fs.writeFileSync(packagePath, JSON.stringify(packageJson, null, '\t'));
        // }
        self.end(res);
    });

    function getSqlList(cb) {
        var sqlList = [];
        var tdmData = JSON.parse(JSON.stringify(self._tdmData));
        // self.pipe(require('./getCreateDDL'), { tdmData }, res, function (req1, res1) {
        //     sqlList = [...sqlList, ...res1.sqlList];
        //     tdmData = JSON.parse(JSON.stringify(self._tdmData));
        //     if (tdmData.oldVersion === 0) return cb(sqlList);
        //     else {
                tdmData.recreate = false;
                tdmData.blalter = true;
                tdmData.iscreate = true;
                tdmData.startrun = true;
                self.pipe(require('./getAlterDDL'), { tdmData }, res, function (req2, res2) {
                    sqlList = [...sqlList, ...res2.sqlList];
                    return cb(sqlList);
                });
        //     }
        // })
    }
};

/**
 * 递归创建目录(同步)
 * @param {*} dirname 
 * @returns 
 */
Save.prototype.mkdirsSync = function (dirname) {
    var self = this;
    if (fs.existsSync(dirname)) {
        return true;
    } else {
        if (self.mkdirsSync(path.dirname(dirname))) {
            fs.mkdirSync(dirname);
            return true;
        }
    }
}
