var Service = require('Service');
var util = require('util');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');

/**
 * 列表-数据库中表和视图
 */
var GetObjectsMETA = function () {
    Service.call(this);
};

util.inherits(GetObjectsMETA, Service);

module.exports = GetObjectsMETA;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {String} [req.tableName] 表或视图名称
 * @param  {String} [req.getComment] 是否返回备注
 * @param  {Object} res 服务响应对象
 */
GetObjectsMETA.prototype.process = async function (req, res) {
    const dsConfig = dsUtils.getDsConfig(req.dsid);
    const dao = dsUtils.createDao(this, null, dsConfig);
    const connection = new Connection(dsConfig);
    const objectsMETA = await dao.executeSync(connection.getObjectsMETA({
        'object_name': req.tableName,
        'object_type': 'TABLE,VIEW'
    }), null);
    const tables = [];
    const views = [];
    objectsMETA.forEach(table => {
        if (table.object_type == 'TABLE') tables.push(req.getComment ? {
            name: table.object_name,
            comment: table.object_comment
        } : table.object_name);
        if (table.object_type == 'VIEW') views.push(req.getComment ? {
            name: table.object_name,
            comment: table.object_comment
        } : table.object_name);
    });
    this.end({ ...res, tables, views });
};
