var Service = require('Service');
var util = require('util');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');

/**
 * 列表-数据库中字段
 */
var GetFieldsMETA = function () {
    Service.call(this);
};

util.inherits(GetFieldsMETA, Service);

module.exports = GetFieldsMETA;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {String} req.tableName 表或视图名称
 * @param  {Object} res 服务响应对象
 */
GetFieldsMETA.prototype.process = async function (req, res) {
    const dsConfig = dsUtils.getDsConfig(req.dsid);
    const dao = dsUtils.createDao(this, null, dsConfig);
    const connection = new Connection(dsConfig);
    const fieldsMETA = await dao.executeSync(connection.getFieldsMETA(req.tableName), null);
    this.end({ ...res, fields: fieldsMETA });
};
