var Service = require('Service');
var util = require('util');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');

/**
 * 获取-创建语句DDL
 */
var GetCreateDDL = function () {
  Service.call(this);
};

util.inherits(GetCreateDDL, Service);

module.exports = GetCreateDDL;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetCreateDDL.prototype.process = function (req, res) {
  let dsConfig = dsUtils.getDsConfig(req.dsid);
  var connection = new Connection(dsConfig);
  if(req.tdmData.type == 'table') res.sqlList = connection.getCreateTableDDL(req.tdmData);
  if(req.tdmData.type == 'view') res.sqlList = connection.getCreateViewDDL(req.tdmData);
  this.end(res);
};
