var Service = require('Service');
var util = require('util');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');

/**
 * 获取-变更语句DDL
 */
var GetAlterDDL = function () {
  Service.call(this);
};

util.inherits(GetAlterDDL, Service);

module.exports = GetAlterDDL;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetAlterDDL.prototype.process = function (req, res) {
  let dsConfig = dsUtils.getDsConfig(req.dsid);
  var connection = new Connection(dsConfig);
  res.sqlList = connection.getDDL(req.tdmData);
  this.end(res);
};
