var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Connection = require('Connection');
var dsUtils = require('../dsUtils');

/**
 * 获取数据模型（文件）
 */
var Get = function () {
  Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 获取数据模型（文件）
 * @param {*} req 
 * projName modelName
 * --应用名称 模型名称
 * @param {*} res 
 * @param {*} cb 
 */
Get.prototype.process = function (req, res) {
  if (!req.projName) {
    this.onLogicError(1, '请提供项目名称！');
    return;
  }
  if(!req.modelName && !req.modelPath) {
    this.onLogicError(2, '请提供数据模型名称或路径！');
    return;
  }

  var projName = req.projName;
  var filePath = "";
  if(req.modelName) {
    let modelName = req.modelName.endWith(".tdm") ? req.modelName : req.modelName+".tdm";
    filePath = utils.getPath("/app/"+req.projName+"/model/"+modelName);
  } else if(req.modelPath) {
    filePath = utils.getPath("/app/"+req.modelPath);
  }
  if (!fs.existsSync(filePath)) {
    this.onLogicError(3, '文件不存在！');
    return;
  }
  var self = this;
  fs.readFile(filePath, "utf-8", function (err, data) {
    res.model = JSON.parse(data);
    let dsConfig = dsUtils.getDsConfig(res.model.dsId);
    var dao = dsUtils.createDao(self, null, dsConfig);
    var connection = new Connection(dsConfig);
    if(!res.model.dbType) res.model.dbType = dsConfig.type;
    if (res.model.type == 'view') {
      dao.execute(connection.getDetailMETA({
        object_type: 'VIEW',
        object_name: res.model.table
      }), [], function (sql) {
        if(sql.length>0) res.model.statement = sql[0].sql_statement;
        self.end(res);
      });
    } else {
      self.end(res);
    }
  });
};
