var Service = require('Service');
var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');

/**
 * 删除数据模型（文件）
 */
var Delete = function () {
  Service.call(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 删除数据模型（文件）
 * @param {*} req 
 * projName modelName
 * --应用名称 模型名称
 * @param {*} res 
 * @param {*} cb 
 */
Delete.prototype.process = function (req, res) {
  if (!req.projName) {
    this.onLogicError(1, '请提供项目名称！');
    return;
  }
  if(!req.modelName && !req.modelPath) {
    this.onLogicError(2, '请提供数据模型名称或路径！');
    return;
  }
  var projName = req.projName;
  var filePath = "";
  if(req.modelName) {
    let modelName = req.modelName.endWith(".tdm") ? req.modelName : req.modelName+".tdm";
    filePath = utils.getPath("/app/"+req.projName+"/model/"+modelName);
  } else if(req.modelPath) {
    filePath = utils.getPath("/app/"+req.modelPath);
  }
  if (fs.existsSync(filePath)) fs.unlinkSync(filePath);
  this.end(res);
};