var util = require('util');
var path = require('path');
var fs = require('fs');
var utils = require('utils');
var Service = require('Service');
var TdfManagerBl = require('../../bll/tdfManagerBl');

/**
 * 验证文件
 * 判断文件路径是否正确，如果不正确则修改文件内容并创建相关数据表
 */
var SaveFileContent = function () {
    Service.call(this);
    this.sqlInject.exclude = ['filePath', 'data'];
    this.xssInject.exclude = ['filePath', 'data'];
};

util.inherits(SaveFileContent, Service);

module.exports = SaveFileContent;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} req.filePath 文件路径
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
SaveFileContent.prototype.process = function (req, res) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');

    this.filePath = req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, '');
    this.fileFullPath = utils.getPath(this.filePath);
    this.tdf = JSON.parse(fs.readFileSync(this.fileFullPath, 'utf-8'));
    this.tdfManagerBl = new TdfManagerBl(this);
    this.mode = this.filePath.replace('/app', '') != this.tdf.info.filePath ? 'create' : '';

    this.transformInfo((tdf) => {
        this.saveFile(() => {
            res.data = JSON.stringify(tdf);
            this.end(res);
        });
    });
};

SaveFileContent.prototype.transformInfo = function (cb) {
    const { tdf, tdfManagerBl, filePath, mode } = this;

    // 更新文件基础信息
    tdf.info = tdfManagerBl.transformInfo({
        info: tdf.info,
        filePath: filePath
    });

    // 更新前台文件
    for (const key in tdf.views) {
        tdf.views[key].tfp.projName = tdf.info.projName;
    }

    // 更新后台文件信息
    tdf.services.save.tbs = tdfManagerBl.transformTBS({
        'type': 'save',
        'info': tdf.info,
        'items': tdf.items
    });
    tdf.services.get.tbs = tdfManagerBl.transformTBS({
        'type': 'get',
        'info': tdf.info,
        'items': tdf.items
    });
    tdf.services.remove.tbs = tdfManagerBl.transformTBS({
        'type': 'remove',
        'tbs': tdfManagerBl.defaultTBS({
            'type': 'remove',
            'info': tdf.info
        }),
        'info': tdf.info,
        'items': tdf.items
    });

    // 更新模型文件信息
    if(mode == 'create') {
        for (const modelName in tdf.models) {
            const model = tdf.models[modelName];
            if(!model.tdm) continue;
            model.tdm.version = 0;
            model.tdm.oldVersion = 0;
            if(!model.tdm.fields) continue;
            for (const fieldName in model.tdm.fields) {
                const field = model.tdm.fields[fieldName];
                field.version = 0;
                field.oldVersion = 0;
            }
        }
    }
    tdfManagerBl.transformModels({
        'info': tdf.info,
        'models': tdf.models,
        'items': tdf.items,
        'mode': mode
    }, models => {
        tdf.models = models;
        cb(tdf);
    });
}

SaveFileContent.prototype.saveFile = function (cb) {
    const { tdf, fileFullPath } = this;
    fs.writeFile(fileFullPath, JSON.stringify(tdf, null, "  "), err => {
        if (err) return this.onError(err);
        cb();
    });
}