const util = require('util');
const fs = require('fs');
const utils = require('utils');
const Service = require('Service');

/**
 * 分解tdf文件为tdm、tbs、tfp
 */
const SplitTDF = function () {
    Service.call(this);
};

util.inherits(SplitTDF, Service);

module.exports = SplitTDF;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {String} req.filePath 文件路径
 * @param  {Boolean} req.isCover 是否覆盖
 * @param  {Object} res 服务响应对象
 */
SplitTDF.prototype.process = function (req, res) {
    if (!req.filePath) return this.onLogicError(1, '请提供文件路径！');

    const isCover = typeof req.isCover == 'boolean' ? req.isCover : true;
    const filePath = utils.getPath(req.filePath.replace(/\.\.\//g, '').replace(/\.\//g, ''));
    const fileName = filePath.split('/').pop();
    const tdf = JSON.parse(fs.readFileSync(filePath, "utf-8"));
    const { dataPath, dataName } = tdf.info;
    const templateFilePath = {
        'tdm': filePath.replaceWithEnd('/tdf/', '/model/').replaceWithEnd(fileName, tdf.info.dataName + '/'),
        'tbs': filePath.replaceWithEnd('/tdf/', '/service/').replaceWithEnd(fileName, tdf.info.dataName + '/'),
        'tfp': filePath.replace(/\/app\/(.*)tdf\//, '/web/app/$1').replaceWithEnd(fileName, tdf.info.dataName + '/'),
    };

    // 获取文件路径及内容
    const { views, services, models } = tdf;
    const splitFiles = {};
    for (const modelName in models) {
        const path = `${templateFilePath.tdm}${modelName}.tdm`;
        splitFiles[path] = models[modelName].tdm;
    }
    for (const serviceName in services) {
        const path = `${templateFilePath.tbs}${serviceName}.tbs`;
        splitFiles[path] = transformTbs(services[serviceName].tbs);
    }
    for (const viewName in views) {
        const path = `${templateFilePath.tfp}${viewName}.tfp`;
        splitFiles[path] = transformTfp(views[viewName].tfp);
    }

    // 创建路径
    for (const type in templateFilePath) {
        const path = templateFilePath[type];
        const mkPath = dataPath + '/' + dataName;
        let temp = path.split(mkPath + '/').join('');
        mkPath.split('/').forEach((dir) => {
            temp += (dir + '/');
            if (!fs.existsSync(temp)) fs.mkdirSync(temp);
        });
    }

    // 创建文件
    for (const filePath in splitFiles) {
        const content = splitFiles[filePath];
        if (fs.existsSync(filePath) && !isCover) continue;
        fs.writeFileSync(filePath, JSON.stringify(content, null, '\t'));
    }

    this.end(res);
};

function transformTbs(tbs) {
    return tbs;
}

function transformTfp(tfp) {
    return tfp;
}

String.prototype.replaceWithEnd = function (searchValue, replaceValue) {
    const reg = new RegExp(`(.*)${searchValue}`);
    return this.replace(reg, `$1${replaceValue}`);
}